// Generated by Karakum - do not modify it manually!


package node.http2

import node.events.EventEmitter


@Suppress("INTERFACE_WITH_SUPERCLASS")

sealed external interface Http2Session : EventEmitter {
    /**
     * Value will be `undefined` if the `Http2Session` is not yet connected to a
     * socket, `h2c` if the `Http2Session` is not connected to a `TLSSocket`, or
     * will return the value of the connected `TLSSocket`'s own `alpnProtocol`property.
     * @since v9.4.0
     */
    val alpnProtocol: String?

    /**
     * Will be `true` if this `Http2Session` instance has been closed, otherwise`false`.
     * @since v9.4.0
     */
    val closed: Boolean

    /**
     * Will be `true` if this `Http2Session` instance is still connecting, will be set
     * to `false` before emitting `connect` event and/or calling the `http2.connect`callback.
     * @since v10.0.0
     */
    val connecting: Boolean

    /**
     * Will be `true` if this `Http2Session` instance has been destroyed and must no
     * longer be used, otherwise `false`.
     * @since v8.4.0
     */
    val destroyed: Boolean

    /**
     * Value is `undefined` if the `Http2Session` session socket has not yet been
     * connected, `true` if the `Http2Session` is connected with a `TLSSocket`,
     * and `false` if the `Http2Session` is connected to any other kind of socket
     * or stream.
     * @since v9.4.0
     */
    val encrypted: Boolean?

    /**
     * A prototype-less object describing the current local settings of this`Http2Session`. The local settings are local to _this_`Http2Session` instance.
     * @since v8.4.0
     */
    val localSettings: Settings

    /**
     * If the `Http2Session` is connected to a `TLSSocket`, the `originSet` property
     * will return an `Array` of origins for which the `Http2Session` may be
     * considered authoritative.
     *
     * The `originSet` property is only available when using a secure TLS connection.
     * @since v9.4.0
     */
    val originSet: js.array.ReadonlyArray<String>?

    /**
     * Indicates whether the `Http2Session` is currently waiting for acknowledgment of
     * a sent `SETTINGS` frame. Will be `true` after calling the`http2session.settings()` method. Will be `false` once all sent `SETTINGS`frames have been acknowledged.
     * @since v8.4.0
     */
    val pendingSettingsAck: Boolean

    /**
     * A prototype-less object describing the current remote settings of this`Http2Session`. The remote settings are set by the _connected_ HTTP/2 peer.
     * @since v8.4.0
     */
    val remoteSettings: Settings

    /**
     * Returns a `Proxy` object that acts as a `net.Socket` (or `tls.TLSSocket`) but
     * limits available methods to ones safe to use with HTTP/2.
     *
     * `destroy`, `emit`, `end`, `pause`, `read`, `resume`, and `write` will throw
     * an error with code `ERR_HTTP2_NO_SOCKET_MANIPULATION`. See `Http2Session and Sockets` for more information.
     *
     * `setTimeout` method will be called on this `Http2Session`.
     *
     * All other interactions will be routed directly to the socket.
     * @since v8.4.0
     */
    val socket: Any /* net.Socket | tls.TLSSocket */

    /**
     * Provides miscellaneous information about the current state of the`Http2Session`.
     *
     * An object describing the current status of this `Http2Session`.
     * @since v8.4.0
     */
    val state: SessionState

    /**
     * The `http2session.type` will be equal to`http2.constants.NGHTTP2_SESSION_SERVER` if this `Http2Session` instance is a
     * server, and `http2.constants.NGHTTP2_SESSION_CLIENT` if the instance is a
     * client.
     * @since v8.4.0
     */
    val type: Double

    /**
     * Gracefully closes the `Http2Session`, allowing any existing streams to
     * complete on their own and preventing new `Http2Stream` instances from being
     * created. Once closed, `http2session.destroy()`_might_ be called if there
     * are no open `Http2Stream` instances.
     *
     * If specified, the `callback` function is registered as a handler for the`'close'` event.
     * @since v9.4.0
     */
    fun close(callback: () -> Unit = definedExternally): Unit

    /**
     * Immediately terminates the `Http2Session` and the associated `net.Socket` or`tls.TLSSocket`.
     *
     * Once destroyed, the `Http2Session` will emit the `'close'` event. If `error`is not undefined, an `'error'` event will be emitted immediately before the`'close'` event.
     *
     * If there are any remaining open `Http2Streams` associated with the`Http2Session`, those will also be destroyed.
     * @since v8.4.0
     * @param error An `Error` object if the `Http2Session` is being destroyed due to an error.
     * @param code The HTTP/2 error code to send in the final `GOAWAY` frame. If unspecified, and `error` is not undefined, the default is `INTERNAL_ERROR`, otherwise defaults to `NO_ERROR`.
     */
    fun destroy(error: Throwable /* JsError */ = definedExternally, code: Number = definedExternally): Unit

    /**
     * Transmits a `GOAWAY` frame to the connected peer _without_ shutting down the`Http2Session`.
     * @since v9.4.0
     * @param code An HTTP/2 error code
     * @param lastStreamID The numeric ID of the last processed `Http2Stream`
     * @param opaqueData A `TypedArray` or `DataView` instance containing additional data to be carried within the `GOAWAY` frame.
     */
    fun goaway(
        code: Number = definedExternally,
        lastStreamID: Number = definedExternally,
        opaqueData: js.buffer.ArrayBufferView = definedExternally,
    ): Unit

    /**
     * Sends a `PING` frame to the connected HTTP/2 peer. A `callback` function must
     * be provided. The method will return `true` if the `PING` was sent, `false`otherwise.
     *
     * The maximum number of outstanding (unacknowledged) pings is determined by the`maxOutstandingPings` configuration option. The default maximum is 10.
     *
     * If provided, the `payload` must be a `Buffer`, `TypedArray`, or `DataView`containing 8 bytes of data that will be transmitted with the `PING` and
     * returned with the ping acknowledgment.
     *
     * The callback will be invoked with three arguments: an error argument that will
     * be `null` if the `PING` was successfully acknowledged, a `duration` argument
     * that reports the number of milliseconds elapsed since the ping was sent and the
     * acknowledgment was received, and a `Buffer` containing the 8-byte `PING`payload.
     *
     * ```js
     * session.ping(Buffer.from('abcdefgh'), (err, duration, payload) => {
     *   if (!err) {
     *     console.log(`Ping acknowledged in ${duration} milliseconds`);
     *     console.log(`With payload '${payload.toString()}'`);
     *   }
     * });
     * ```
     *
     * If the `payload` argument is not specified, the default payload will be the
     * 64-bit timestamp (little endian) marking the start of the `PING` duration.
     * @since v8.9.3
     * @param payload Optional ping payload.
     */
    fun ping(callback: (err: Throwable /* JsError */?, duration: Double, payload: node.buffer.Buffer) -> Unit): Boolean
    fun ping(
        payload: js.buffer.ArrayBufferView,
        callback: (err: Throwable /* JsError */?, duration: Double, payload: node.buffer.Buffer) -> Unit,
    ): Boolean

    /**
     * Calls `ref()` on this `Http2Session`instance's underlying `net.Socket`.
     * @since v9.4.0
     */
    fun ref(): Unit

    /**
     * Sets the local endpoint's window size.
     * The `windowSize` is the total window size to set, not
     * the delta.
     *
     * ```js
     * const http2 = require('node:http2');
     *
     * const server = http2.createServer();
     * const expectedWindowSize = 2 ** 20;
     * server.on('connect', (session) => {
     *
     *   // Set local window size to be 2 ** 20
     *   session.setLocalWindowSize(expectedWindowSize);
     * });
     * ```
     * @since v15.3.0, v14.18.0
     */
    fun setLocalWindowSize(windowSize: Number): Unit

    /**
     * Used to set a callback function that is called when there is no activity on
     * the `Http2Session` after `msecs` milliseconds. The given `callback` is
     * registered as a listener on the `'timeout'` event.
     * @since v8.4.0
     */
    fun setTimeout(msecs: Number, callback: () -> Unit = definedExternally): Unit

    /**
     * Updates the current local settings for this `Http2Session` and sends a new`SETTINGS` frame to the connected HTTP/2 peer.
     *
     * Once called, the `http2session.pendingSettingsAck` property will be `true`while the session is waiting for the remote peer to acknowledge the new
     * settings.
     *
     * The new settings will not become effective until the `SETTINGS` acknowledgment
     * is received and the `'localSettings'` event is emitted. It is possible to send
     * multiple `SETTINGS` frames while acknowledgment is still pending.
     * @since v8.4.0
     * @param callback Callback that is called once the session is connected or right away if the session is already connected.
     */
    fun settings(
        settings: Settings,
        callback: (err: Throwable /* JsError */?, settings: Settings, duration: Double) -> Unit = definedExternally,
    ): Unit

    /**
     * Calls `unref()` on this `Http2Session`instance's underlying `net.Socket`.
     * @since v9.4.0
     */
    fun unref(): Unit
    fun addListener(event: Http2SessionEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun addListener(event: Http2SessionEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */
    fun addListener(
        event: Http2SessionEvent.FRAMEERROR,
        listener: (frameType: Double, errorCode: Double, streamID: Double) -> Unit,
    ): Unit /* this */

    fun addListener(
        event: Http2SessionEvent.GOAWAY,
        listener: (errorCode: Double, lastStreamID: Double, opaqueData: node.buffer.Buffer? /* use undefined for default */) -> Unit,
    ): Unit /* this */

    fun addListener(event: Http2SessionEvent.LOCALSETTINGS, listener: (settings: Settings) -> Unit): Unit /* this */
    fun addListener(event: Http2SessionEvent.PING, listener: () -> Unit): Unit /* this */
    fun addListener(event: Http2SessionEvent.REMOTESETTINGS, listener: (settings: Settings) -> Unit): Unit /* this */
    fun addListener(event: Http2SessionEvent.TIMEOUT, listener: () -> Unit): Unit /* this */
    fun addListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    fun addListener(event: js.symbol.Symbol, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */
    fun emit(event: Http2SessionEvent.CLOSE): Boolean
    fun emit(event: Http2SessionEvent.ERROR, err: Throwable /* JsError */): Boolean
    fun emit(event: Http2SessionEvent.FRAMEERROR, frameType: Number, errorCode: Number, streamID: Number): Boolean
    fun emit(
        event: Http2SessionEvent.GOAWAY,
        errorCode: Number,
        lastStreamID: Number,
        opaqueData: node.buffer.Buffer = definedExternally,
    ): Boolean

    fun emit(event: Http2SessionEvent.LOCALSETTINGS, settings: Settings): Boolean
    fun emit(event: Http2SessionEvent.PING): Boolean
    fun emit(event: Http2SessionEvent.REMOTESETTINGS, settings: Settings): Boolean
    fun emit(event: Http2SessionEvent.TIMEOUT): Boolean
    fun emit(event: String, vararg args: Any?): Boolean

    fun emit(event: js.symbol.Symbol, vararg args: Any?): Boolean
    fun on(event: Http2SessionEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun on(event: Http2SessionEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */
    fun on(
        event: Http2SessionEvent.FRAMEERROR,
        listener: (frameType: Double, errorCode: Double, streamID: Double) -> Unit,
    ): Unit /* this */

    fun on(
        event: Http2SessionEvent.GOAWAY,
        listener: (errorCode: Double, lastStreamID: Double, opaqueData: node.buffer.Buffer? /* use undefined for default */) -> Unit,
    ): Unit /* this */

    fun on(event: Http2SessionEvent.LOCALSETTINGS, listener: (settings: Settings) -> Unit): Unit /* this */
    fun on(event: Http2SessionEvent.PING, listener: () -> Unit): Unit /* this */
    fun on(event: Http2SessionEvent.REMOTESETTINGS, listener: (settings: Settings) -> Unit): Unit /* this */
    fun on(event: Http2SessionEvent.TIMEOUT, listener: () -> Unit): Unit /* this */
    fun on(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    fun on(event: js.symbol.Symbol, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */
    fun once(event: Http2SessionEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun once(event: Http2SessionEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */
    fun once(
        event: Http2SessionEvent.FRAMEERROR,
        listener: (frameType: Double, errorCode: Double, streamID: Double) -> Unit,
    ): Unit /* this */

    fun once(
        event: Http2SessionEvent.GOAWAY,
        listener: (errorCode: Double, lastStreamID: Double, opaqueData: node.buffer.Buffer? /* use undefined for default */) -> Unit,
    ): Unit /* this */

    fun once(event: Http2SessionEvent.LOCALSETTINGS, listener: (settings: Settings) -> Unit): Unit /* this */
    fun once(event: Http2SessionEvent.PING, listener: () -> Unit): Unit /* this */
    fun once(event: Http2SessionEvent.REMOTESETTINGS, listener: (settings: Settings) -> Unit): Unit /* this */
    fun once(event: Http2SessionEvent.TIMEOUT, listener: () -> Unit): Unit /* this */
    fun once(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    fun once(event: js.symbol.Symbol, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */
    fun prependListener(event: Http2SessionEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun prependListener(
        event: Http2SessionEvent.ERROR,
        listener: (err: Throwable /* JsError */) -> Unit,
    ): Unit /* this */

    fun prependListener(
        event: Http2SessionEvent.FRAMEERROR,
        listener: (frameType: Double, errorCode: Double, streamID: Double) -> Unit,
    ): Unit /* this */

    fun prependListener(
        event: Http2SessionEvent.GOAWAY,
        listener: (errorCode: Double, lastStreamID: Double, opaqueData: node.buffer.Buffer? /* use undefined for default */) -> Unit,
    ): Unit /* this */

    fun prependListener(event: Http2SessionEvent.LOCALSETTINGS, listener: (settings: Settings) -> Unit): Unit /* this */
    fun prependListener(event: Http2SessionEvent.PING, listener: () -> Unit): Unit /* this */
    fun prependListener(
        event: Http2SessionEvent.REMOTESETTINGS,
        listener: (settings: Settings) -> Unit,
    ): Unit /* this */

    fun prependListener(event: Http2SessionEvent.TIMEOUT, listener: () -> Unit): Unit /* this */
    fun prependListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    fun prependListener(
        event: js.symbol.Symbol,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    fun prependOnceListener(event: Http2SessionEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(
        event: Http2SessionEvent.ERROR,
        listener: (err: Throwable /* JsError */) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(
        event: Http2SessionEvent.FRAMEERROR,
        listener: (frameType: Double, errorCode: Double, streamID: Double) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(
        event: Http2SessionEvent.GOAWAY,
        listener: (errorCode: Double, lastStreamID: Double, opaqueData: node.buffer.Buffer? /* use undefined for default */) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(
        event: Http2SessionEvent.LOCALSETTINGS,
        listener: (settings: Settings) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(event: Http2SessionEvent.PING, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(
        event: Http2SessionEvent.REMOTESETTINGS,
        listener: (settings: Settings) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(event: Http2SessionEvent.TIMEOUT, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    fun prependOnceListener(
        event: js.symbol.Symbol,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */
}
