// Generated by Karakum - do not modify it manually!

@file:JsModule("node:http2")

package node.http2


/**
 * Returns a `tls.Server` instance that creates and manages `Http2Session`instances.
 *
 * ```js
 * const http2 = require('node:http2');
 * const fs = require('node:fs');
 *
 * const options = {
 *   key: fs.readFileSync('server-key.pem'),
 *   cert: fs.readFileSync('server-cert.pem'),
 * };
 *
 * // Create a secure HTTP/2 server
 * const server = http2.createSecureServer(options);
 *
 * server.on('stream', (stream, headers) => {
 *   stream.respond({
 *     'content-type': 'text/html; charset=utf-8',
 *     ':status': 200,
 *   });
 *   stream.end('<h1>Hello World</h1>');
 * });
 *
 * server.listen(8443);
 * ```
 * @since v8.4.0
 * @param onRequestHandler See `Compatibility API`
 */
external fun createSecureServer(onRequestHandler: (request: Http2ServerRequest, response: Http2ServerResponse) -> Unit = definedExternally): Http2SecureServer

external fun createSecureServer(
    options: SecureServerOptions,
    onRequestHandler: (request: Http2ServerRequest, response: Http2ServerResponse) -> Unit = definedExternally,
): Http2SecureServer
