// Generated by Karakum - do not modify it manually!

@file:JsModule("node:http2")

package node.http2


/**
 * Returns a `net.Server` instance that creates and manages `Http2Session`instances.
 *
 * Since there are no browsers known that support [unencrypted HTTP/2](https://http2.github.io/faq/#does-http2-require-encryption), the use of {@link createSecureServer} is necessary when
 * communicating
 * with browser clients.
 *
 * ```js
 * const http2 = require('node:http2');
 *
 * // Create an unencrypted HTTP/2 server.
 * // Since there are no browsers known that support
 * // unencrypted HTTP/2, the use of `http2.createSecureServer()`
 * // is necessary when communicating with browser clients.
 * const server = http2.createServer();
 *
 * server.on('stream', (stream, headers) => {
 *   stream.respond({
 *     'content-type': 'text/html; charset=utf-8',
 *     ':status': 200,
 *   });
 *   stream.end('<h1>Hello World</h1>');
 * });
 *
 * server.listen(8000);
 * ```
 * @since v8.4.0
 * @param onRequestHandler See `Compatibility API`
 */
external fun createServer(onRequestHandler: (request: Http2ServerRequest, response: Http2ServerResponse) -> Unit = definedExternally): Http2Server

external fun createServer(
    options: ServerOptions,
    onRequestHandler: (request: Http2ServerRequest, response: Http2ServerResponse) -> Unit = definedExternally,
): Http2Server
