// Generated by Karakum - do not modify it manually!

@file:JsModule("node:inspector")

package node.inspector

import node.events.EventEmitter

/**
 * The `inspector.Session` is used for dispatching messages to the V8 inspector
 * back-end and receiving message responses and notifications.
 */

external class Session : EventEmitter {
    /**
     * Create a new instance of the inspector.Session class.
     * The inspector session needs to be connected through session.connect() before the messages can be dispatched to the inspector backend.
     */
    constructor ()

    /**
     * Connects a session to the inspector back-end.
     * @since v8.0.0
     */
    fun connect(): Unit

    /**
     * Immediately close the session. All pending message callbacks will be called
     * with an error. `session.connect()` will need to be called to be able to send
     * messages again. Reconnected session will lose all inspector state, such as
     * enabled agents or configured breakpoints.
     * @since v8.0.0
     */
    fun disconnect(): Unit

    /**
     * Posts a message to the inspector back-end. `callback` will be notified when
     * a response is received. `callback` is a function that accepts two optional
     * arguments: error and message-specific result.
     *
     * ```js
     * session.post('Runtime.evaluate', { expression: '2 + 2' },
     *              (error, { result }) => console.log(result));
     * // Output: { type: 'number', value: 4, description: '4' }
     * ```
     *
     * The latest version of the V8 inspector protocol is published on the [Chrome DevTools Protocol Viewer](https://chromedevtools.github.io/devtools-protocol/v8/).
     *
     * Node.js inspector supports all the Chrome DevTools Protocol domains declared
     * by V8\. Chrome DevTools Protocol domain provides an interface for interacting
     * with one of the runtime agents used to inspect the application state and listen
     * to the run-time events.
     *
     * ## Example usage
     *
     * Apart from the debugger, various V8 Profilers are available through the DevTools
     * protocol.
     * @since v8.0.0
     */
    fun post(
        method: String,
        params: Any = definedExternally,
        callback: (err: Throwable /* JsError */?, params: (Any)? /* use undefined for default */) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: String,
        callback: (err: Throwable /* JsError */?, params: (Any)? /* use undefined for default */) -> Unit = definedExternally,
    ): Unit

    /**
     * Returns supported domains.
     */
    fun post(
        method: SessionMethod.SCHEMA_GETDOMAINS,
        callback: (err: Throwable /* JsError */?, params: node.inspector.schema.GetDomainsReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Evaluates expression on global object.
     */
    fun post(
        method: SessionMethod.RUNTIME_EVALUATE,
        params: node.inspector.runtime.EvaluateParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.EvaluateReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_EVALUATE,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.EvaluateReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Add handler to promise with given promise object id.
     */
    fun post(
        method: SessionMethod.RUNTIME_AWAITPROMISE,
        params: node.inspector.runtime.AwaitPromiseParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.AwaitPromiseReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_AWAITPROMISE,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.AwaitPromiseReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Calls function with given declaration on the given object. Object group of the result is inherited from the target object.
     */
    fun post(
        method: SessionMethod.RUNTIME_CALLFUNCTIONON,
        params: node.inspector.runtime.CallFunctionOnParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.CallFunctionOnReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_CALLFUNCTIONON,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.CallFunctionOnReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Returns properties of a given object. Object group of the result is inherited from the target object.
     */
    fun post(
        method: SessionMethod.RUNTIME_GETPROPERTIES,
        params: node.inspector.runtime.GetPropertiesParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.GetPropertiesReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_GETPROPERTIES,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.GetPropertiesReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Releases remote object with given id.
     */
    fun post(
        method: SessionMethod.RUNTIME_RELEASEOBJECT,
        params: node.inspector.runtime.ReleaseObjectParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_RELEASEOBJECT,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Releases all remote objects that belong to a given group.
     */
    fun post(
        method: SessionMethod.RUNTIME_RELEASEOBJECTGROUP,
        params: node.inspector.runtime.ReleaseObjectGroupParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_RELEASEOBJECTGROUP,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Tells inspected instance to run if it was waiting for debugger to attach.
     */
    fun post(
        method: SessionMethod.RUNTIME_RUNIFWAITINGFORDEBUGGER,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Enables reporting of execution contexts creation by means of <code>executionContextCreated</code> event. When the reporting gets enabled the event will be sent immediately for each existing execution context.
     */
    fun post(
        method: SessionMethod.RUNTIME_ENABLE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Disables reporting of execution contexts creation.
     */
    fun post(
        method: SessionMethod.RUNTIME_DISABLE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Discards collected exceptions and console API calls.
     */
    fun post(
        method: SessionMethod.RUNTIME_DISCARDCONSOLEENTRIES,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * @experimental
     */
    fun post(
        method: SessionMethod.RUNTIME_SETCUSTOMOBJECTFORMATTERENABLED,
        params: node.inspector.runtime.SetCustomObjectFormatterEnabledParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_SETCUSTOMOBJECTFORMATTERENABLED,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Compiles expression.
     */
    fun post(
        method: SessionMethod.RUNTIME_COMPILESCRIPT,
        params: node.inspector.runtime.CompileScriptParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.CompileScriptReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_COMPILESCRIPT,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.CompileScriptReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Runs script with given id in a given context.
     */
    fun post(
        method: SessionMethod.RUNTIME_RUNSCRIPT,
        params: node.inspector.runtime.RunScriptParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.RunScriptReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_RUNSCRIPT,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.RunScriptReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_QUERYOBJECTS,
        params: node.inspector.runtime.QueryObjectsParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.QueryObjectsReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_QUERYOBJECTS,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.QueryObjectsReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Returns all let, const and class variables from global scope.
     */
    fun post(
        method: SessionMethod.RUNTIME_GLOBALLEXICALSCOPENAMES,
        params: node.inspector.runtime.GlobalLexicalScopeNamesParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.GlobalLexicalScopeNamesReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.RUNTIME_GLOBALLEXICALSCOPENAMES,
        callback: (err: Throwable /* JsError */?, params: node.inspector.runtime.GlobalLexicalScopeNamesReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Enables debugger for the given page. Clients should not assume that the debugging has been enabled until the result for this command is received.
     */
    fun post(
        method: SessionMethod.DEBUGGER_ENABLE,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.EnableReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Disables debugger for given page.
     */
    fun post(
        method: SessionMethod.DEBUGGER_DISABLE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Activates / deactivates all breakpoints on the page.
     */
    fun post(
        method: SessionMethod.DEBUGGER_SETBREAKPOINTSACTIVE,
        params: node.inspector.debugger.SetBreakpointsActiveParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SETBREAKPOINTSACTIVE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Makes page not interrupt on any pauses (breakpoint, exception, dom exception etc).
     */
    fun post(
        method: SessionMethod.DEBUGGER_SETSKIPALLPAUSES,
        params: node.inspector.debugger.SetSkipAllPausesParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SETSKIPALLPAUSES,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Sets JavaScript breakpoint at given location specified either by URL or URL regex. Once this command is issued, all existing parsed scripts will have breakpoints resolved and returned in <code>locations</code> property. Further matching script parsing will result in subsequent <code>breakpointResolved</code> events issued. This logical breakpoint will survive page reloads.
     */
    fun post(
        method: SessionMethod.DEBUGGER_SETBREAKPOINTBYURL,
        params: node.inspector.debugger.SetBreakpointByUrlParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.SetBreakpointByUrlReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SETBREAKPOINTBYURL,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.SetBreakpointByUrlReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Sets JavaScript breakpoint at a given location.
     */
    fun post(
        method: SessionMethod.DEBUGGER_SETBREAKPOINT,
        params: node.inspector.debugger.SetBreakpointParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.SetBreakpointReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SETBREAKPOINT,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.SetBreakpointReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Removes JavaScript breakpoint.
     */
    fun post(
        method: SessionMethod.DEBUGGER_REMOVEBREAKPOINT,
        params: node.inspector.debugger.RemoveBreakpointParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_REMOVEBREAKPOINT,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Returns possible locations for breakpoint. scriptId in start and end range locations should be the same.
     */
    fun post(
        method: SessionMethod.DEBUGGER_GETPOSSIBLEBREAKPOINTS,
        params: node.inspector.debugger.GetPossibleBreakpointsParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.GetPossibleBreakpointsReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_GETPOSSIBLEBREAKPOINTS,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.GetPossibleBreakpointsReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Continues execution until specific location is reached.
     */
    fun post(
        method: SessionMethod.DEBUGGER_CONTINUETOLOCATION,
        params: node.inspector.debugger.ContinueToLocationParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_CONTINUETOLOCATION,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * @experimental
     */
    fun post(
        method: SessionMethod.DEBUGGER_PAUSEONASYNCCALL,
        params: node.inspector.debugger.PauseOnAsyncCallParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_PAUSEONASYNCCALL,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Steps over the statement.
     */
    fun post(
        method: SessionMethod.DEBUGGER_STEPOVER,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Steps into the function call.
     */
    fun post(
        method: SessionMethod.DEBUGGER_STEPINTO,
        params: node.inspector.debugger.StepIntoParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_STEPINTO,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Steps out of the function call.
     */
    fun post(
        method: SessionMethod.DEBUGGER_STEPOUT,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Stops on the next JavaScript statement.
     */
    fun post(
        method: SessionMethod.DEBUGGER_PAUSE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * This method is deprecated - use Debugger.stepInto with breakOnAsyncCall and Debugger.pauseOnAsyncTask instead. Steps into next scheduled async task if any is scheduled before next pause. Returns success when async task is actually scheduled, returns error if no task were scheduled or another scheduleStepIntoAsync was called.
     * @experimental
     */
    fun post(
        method: SessionMethod.DEBUGGER_SCHEDULESTEPINTOASYNC,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Resumes JavaScript execution.
     */
    fun post(
        method: SessionMethod.DEBUGGER_RESUME,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Returns stack trace with given <code>stackTraceId</code>.
     * @experimental
     */
    fun post(
        method: SessionMethod.DEBUGGER_GETSTACKTRACE,
        params: node.inspector.debugger.GetStackTraceParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.GetStackTraceReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_GETSTACKTRACE,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.GetStackTraceReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Searches for given string in script content.
     */
    fun post(
        method: SessionMethod.DEBUGGER_SEARCHINCONTENT,
        params: node.inspector.debugger.SearchInContentParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.SearchInContentReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SEARCHINCONTENT,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.SearchInContentReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Edits JavaScript source live.
     */
    fun post(
        method: SessionMethod.DEBUGGER_SETSCRIPTSOURCE,
        params: node.inspector.debugger.SetScriptSourceParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.SetScriptSourceReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SETSCRIPTSOURCE,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.SetScriptSourceReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Restarts particular call frame from the beginning.
     */
    fun post(
        method: SessionMethod.DEBUGGER_RESTARTFRAME,
        params: node.inspector.debugger.RestartFrameParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.RestartFrameReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_RESTARTFRAME,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.RestartFrameReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Returns source for the script with given id.
     */
    fun post(
        method: SessionMethod.DEBUGGER_GETSCRIPTSOURCE,
        params: node.inspector.debugger.GetScriptSourceParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.GetScriptSourceReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_GETSCRIPTSOURCE,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.GetScriptSourceReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Defines pause on exceptions state. Can be set to stop on all exceptions, uncaught exceptions or no exceptions. Initial pause on exceptions state is <code>none</code>.
     */
    fun post(
        method: SessionMethod.DEBUGGER_SETPAUSEONEXCEPTIONS,
        params: node.inspector.debugger.SetPauseOnExceptionsParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SETPAUSEONEXCEPTIONS,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Evaluates expression on a given call frame.
     */
    fun post(
        method: SessionMethod.DEBUGGER_EVALUATEONCALLFRAME,
        params: node.inspector.debugger.EvaluateOnCallFrameParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.EvaluateOnCallFrameReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_EVALUATEONCALLFRAME,
        callback: (err: Throwable /* JsError */?, params: node.inspector.debugger.EvaluateOnCallFrameReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Changes value of variable in a callframe. Object-based scopes are not supported and must be mutated manually.
     */
    fun post(
        method: SessionMethod.DEBUGGER_SETVARIABLEVALUE,
        params: node.inspector.debugger.SetVariableValueParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SETVARIABLEVALUE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Changes return value in top frame. Available only at return break position.
     * @experimental
     */
    fun post(
        method: SessionMethod.DEBUGGER_SETRETURNVALUE,
        params: node.inspector.debugger.SetReturnValueParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SETRETURNVALUE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Enables or disables async call stacks tracking.
     */
    fun post(
        method: SessionMethod.DEBUGGER_SETASYNCCALLSTACKDEPTH,
        params: node.inspector.debugger.SetAsyncCallStackDepthParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SETASYNCCALLSTACKDEPTH,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Replace previous blackbox patterns with passed ones. Forces backend to skip stepping/pausing in scripts with url matching one of the patterns. VM will try to leave blackboxed script by performing 'step in' several times, finally resorting to 'step out' if unsuccessful.
     * @experimental
     */
    fun post(
        method: SessionMethod.DEBUGGER_SETBLACKBOXPATTERNS,
        params: node.inspector.debugger.SetBlackboxPatternsParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SETBLACKBOXPATTERNS,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Makes backend skip steps in the script in blackboxed ranges. VM will try leave blacklisted scripts by performing 'step in' several times, finally resorting to 'step out' if unsuccessful. Positions array contains positions where blackbox state is changed. First interval isn't blackboxed. Array should be sorted.
     * @experimental
     */
    fun post(
        method: SessionMethod.DEBUGGER_SETBLACKBOXEDRANGES,
        params: node.inspector.debugger.SetBlackboxedRangesParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.DEBUGGER_SETBLACKBOXEDRANGES,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Enables console domain, sends the messages collected so far to the client by means of the <code>messageAdded</code> notification.
     */
    fun post(
        method: SessionMethod.CONSOLE_ENABLE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Disables console domain, prevents further console messages from being reported to the client.
     */
    fun post(
        method: SessionMethod.CONSOLE_DISABLE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Does nothing.
     */
    fun post(
        method: SessionMethod.CONSOLE_CLEARMESSAGES,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.PROFILER_ENABLE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.PROFILER_DISABLE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Changes CPU profiler sampling interval. Must be called before CPU profiles recording started.
     */
    fun post(
        method: SessionMethod.PROFILER_SETSAMPLINGINTERVAL,
        params: node.inspector.profiler.SetSamplingIntervalParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.PROFILER_SETSAMPLINGINTERVAL,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.PROFILER_START,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.PROFILER_STOP,
        callback: (err: Throwable /* JsError */?, params: node.inspector.profiler.StopReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Enable precise code coverage. Coverage data for JavaScript executed before enabling precise code coverage may be incomplete. Enabling prevents running optimized code and resets execution counters.
     */
    fun post(
        method: SessionMethod.PROFILER_STARTPRECISECOVERAGE,
        params: node.inspector.profiler.StartPreciseCoverageParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.PROFILER_STARTPRECISECOVERAGE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Disable precise code coverage. Disabling releases unnecessary execution count records and allows executing optimized code.
     */
    fun post(
        method: SessionMethod.PROFILER_STOPPRECISECOVERAGE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Collect coverage data for the current isolate, and resets execution counters. Precise code coverage needs to have started.
     */
    fun post(
        method: SessionMethod.PROFILER_TAKEPRECISECOVERAGE,
        callback: (err: Throwable /* JsError */?, params: node.inspector.profiler.TakePreciseCoverageReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Collect coverage data for the current isolate. The coverage data may be incomplete due to garbage collection.
     */
    fun post(
        method: SessionMethod.PROFILER_GETBESTEFFORTCOVERAGE,
        callback: (err: Throwable /* JsError */?, params: node.inspector.profiler.GetBestEffortCoverageReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Enable type profile.
     * @experimental
     */
    fun post(
        method: SessionMethod.PROFILER_STARTTYPEPROFILE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Disable type profile. Disabling releases type profile data collected so far.
     * @experimental
     */
    fun post(
        method: SessionMethod.PROFILER_STOPTYPEPROFILE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Collect type profile.
     * @experimental
     */
    fun post(
        method: SessionMethod.PROFILER_TAKETYPEPROFILE,
        callback: (err: Throwable /* JsError */?, params: node.inspector.profiler.TakeTypeProfileReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_ENABLE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_DISABLE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_STARTTRACKINGHEAPOBJECTS,
        params: node.inspector.heapprofiler.StartTrackingHeapObjectsParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_STARTTRACKINGHEAPOBJECTS,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_STOPTRACKINGHEAPOBJECTS,
        params: node.inspector.heapprofiler.StopTrackingHeapObjectsParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_STOPTRACKINGHEAPOBJECTS,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_TAKEHEAPSNAPSHOT,
        params: node.inspector.heapprofiler.TakeHeapSnapshotParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_TAKEHEAPSNAPSHOT,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_COLLECTGARBAGE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_GETOBJECTBYHEAPOBJECTID,
        params: node.inspector.heapprofiler.GetObjectByHeapObjectIdParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.heapprofiler.GetObjectByHeapObjectIdReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_GETOBJECTBYHEAPOBJECTID,
        callback: (err: Throwable /* JsError */?, params: node.inspector.heapprofiler.GetObjectByHeapObjectIdReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Enables console to refer to the node with given id via $x (see Command Line API for more details $x functions).
     */
    fun post(
        method: SessionMethod.HEAPPROFILER_ADDINSPECTEDHEAPOBJECT,
        params: node.inspector.heapprofiler.AddInspectedHeapObjectParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_ADDINSPECTEDHEAPOBJECT,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_GETHEAPOBJECTID,
        params: node.inspector.heapprofiler.GetHeapObjectIdParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?, params: node.inspector.heapprofiler.GetHeapObjectIdReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_GETHEAPOBJECTID,
        callback: (err: Throwable /* JsError */?, params: node.inspector.heapprofiler.GetHeapObjectIdReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_STARTSAMPLING,
        params: node.inspector.heapprofiler.StartSamplingParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_STARTSAMPLING,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_STOPSAMPLING,
        callback: (err: Throwable /* JsError */?, params: node.inspector.heapprofiler.StopSamplingReturnType) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.HEAPPROFILER_GETSAMPLINGPROFILE,
        callback: (err: Throwable /* JsError */?, params: node.inspector.heapprofiler.GetSamplingProfileReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Gets supported tracing categories.
     */
    fun post(
        method: SessionMethod.NODETRACING_GETCATEGORIES,
        callback: (err: Throwable /* JsError */?, params: node.inspector.nodetracing.GetCategoriesReturnType) -> Unit = definedExternally,
    ): Unit

    /**
     * Start trace events collection.
     */
    fun post(
        method: SessionMethod.NODETRACING_START,
        params: node.inspector.nodetracing.StartParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.NODETRACING_START,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Stop trace events collection. Remaining collected events will be sent as a sequence of
     * dataCollected events followed by tracingComplete event.
     */
    fun post(
        method: SessionMethod.NODETRACING_STOP,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Sends protocol message over session with given id.
     */
    fun post(
        method: SessionMethod.NODEWORKER_SENDMESSAGETOWORKER,
        params: node.inspector.nodeworker.SendMessageToWorkerParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.NODEWORKER_SENDMESSAGETOWORKER,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Instructs the inspector to attach to running workers. Will also attach to new workers
     * as they start
     */
    fun post(
        method: SessionMethod.NODEWORKER_ENABLE,
        params: node.inspector.nodeworker.EnableParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.NODEWORKER_ENABLE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Detaches from all running workers and disables attaching to new workers as they are started.
     */
    fun post(
        method: SessionMethod.NODEWORKER_DISABLE,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Detached from the worker with given sessionId.
     */
    fun post(
        method: SessionMethod.NODEWORKER_DETACH,
        params: node.inspector.nodeworker.DetachParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.NODEWORKER_DETACH,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    /**
     * Enable the `NodeRuntime.waitingForDisconnect`.
     */
    fun post(
        method: SessionMethod.NODERUNTIME_NOTIFYWHENWAITINGFORDISCONNECT,
        params: node.inspector.noderuntime.NotifyWhenWaitingForDisconnectParameterType = definedExternally,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    fun post(
        method: SessionMethod.NODERUNTIME_NOTIFYWHENWAITINGFORDISCONNECT,
        callback: (err: Throwable /* JsError */?) -> Unit = definedExternally,
    ): Unit

    // Events
    fun addListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    /**
     * Emitted when any notification from the V8 Inspector is received.
     */
    fun addListener(
        event: SessionEvent.INSPECTORNOTIFICATION,
        listener: (message: InspectorNotification<Any>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when new execution context is created.
     */
    fun addListener(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTCREATED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExecutionContextCreatedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when execution context is destroyed.
     */
    fun addListener(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTDESTROYED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExecutionContextDestroyedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when all executionContexts were cleared in browser
     */
    fun addListener(event: SessionEvent.RUNTIME_EXECUTIONCONTEXTSCLEARED, listener: () -> Unit): Unit /* this */

    /**
     * Issued when exception was thrown and unhandled.
     */
    fun addListener(
        event: SessionEvent.RUNTIME_EXCEPTIONTHROWN,
        listener: (message: InspectorNotification<node.inspector.runtime.ExceptionThrownEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when unhandled exception was revoked.
     */
    fun addListener(
        event: SessionEvent.RUNTIME_EXCEPTIONREVOKED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExceptionRevokedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when console API was called.
     */
    fun addListener(
        event: SessionEvent.RUNTIME_CONSOLEAPICALLED,
        listener: (message: InspectorNotification<node.inspector.runtime.ConsoleAPICalledEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when object should be inspected (for example, as a result of inspect() command line API call).
     */
    fun addListener(
        event: SessionEvent.RUNTIME_INSPECTREQUESTED,
        listener: (message: InspectorNotification<node.inspector.runtime.InspectRequestedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when virtual machine parses script. This event is also fired for all known and uncollected scripts upon enabling debugger.
     */
    fun addListener(
        event: SessionEvent.DEBUGGER_SCRIPTPARSED,
        listener: (message: InspectorNotification<node.inspector.debugger.ScriptParsedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when virtual machine fails to parse the script.
     */
    fun addListener(
        event: SessionEvent.DEBUGGER_SCRIPTFAILEDTOPARSE,
        listener: (message: InspectorNotification<node.inspector.debugger.ScriptFailedToParseEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when breakpoint is resolved to an actual script and location.
     */
    fun addListener(
        event: SessionEvent.DEBUGGER_BREAKPOINTRESOLVED,
        listener: (message: InspectorNotification<node.inspector.debugger.BreakpointResolvedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when the virtual machine stopped on breakpoint or exception or any other stop criteria.
     */
    fun addListener(
        event: SessionEvent.DEBUGGER_PAUSED,
        listener: (message: InspectorNotification<node.inspector.debugger.PausedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when the virtual machine resumed execution.
     */
    fun addListener(event: SessionEvent.DEBUGGER_RESUMED, listener: () -> Unit): Unit /* this */

    /**
     * Issued when new console message is added.
     */
    fun addListener(
        event: SessionEvent.CONSOLE_MESSAGEADDED,
        listener: (message: InspectorNotification<node.inspector.console.MessageAddedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Sent when new profile recording is started using console.profile() call.
     */
    fun addListener(
        event: SessionEvent.PROFILER_CONSOLEPROFILESTARTED,
        listener: (message: InspectorNotification<node.inspector.profiler.ConsoleProfileStartedEventDataType>) -> Unit,
    ): Unit /* this */

    fun addListener(
        event: SessionEvent.PROFILER_CONSOLEPROFILEFINISHED,
        listener: (message: InspectorNotification<node.inspector.profiler.ConsoleProfileFinishedEventDataType>) -> Unit,
    ): Unit /* this */

    fun addListener(
        event: SessionEvent.HEAPPROFILER_ADDHEAPSNAPSHOTCHUNK,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.AddHeapSnapshotChunkEventDataType>) -> Unit,
    ): Unit /* this */

    fun addListener(event: SessionEvent.HEAPPROFILER_RESETPROFILES, listener: () -> Unit): Unit /* this */
    fun addListener(
        event: SessionEvent.HEAPPROFILER_REPORTHEAPSNAPSHOTPROGRESS,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.ReportHeapSnapshotProgressEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * If heap objects tracking has been started then backend regularly sends a current value for last seen object id and corresponding timestamp. If the were changes in the heap since last event then one or more heapStatsUpdate events will be sent before a new lastSeenObjectId event.
     */
    fun addListener(
        event: SessionEvent.HEAPPROFILER_LASTSEENOBJECTID,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.LastSeenObjectIdEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * If heap objects tracking has been started then backend may send update for one or more fragments
     */
    fun addListener(
        event: SessionEvent.HEAPPROFILER_HEAPSTATSUPDATE,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.HeapStatsUpdateEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Contains an bucket of collected trace events.
     */
    fun addListener(
        event: SessionEvent.NODETRACING_DATACOLLECTED,
        listener: (message: InspectorNotification<node.inspector.nodetracing.DataCollectedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Signals that tracing is stopped and there is no trace buffers pending flush, all data were
     * delivered via dataCollected events.
     */
    fun addListener(event: SessionEvent.NODETRACING_TRACINGCOMPLETE, listener: () -> Unit): Unit /* this */

    /**
     * Issued when attached to a worker.
     */
    fun addListener(
        event: SessionEvent.NODEWORKER_ATTACHEDTOWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.AttachedToWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when detached from the worker.
     */
    fun addListener(
        event: SessionEvent.NODEWORKER_DETACHEDFROMWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.DetachedFromWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Notifies about a new protocol message received from the session
     * (session ID is provided in attachedToWorker notification).
     */
    fun addListener(
        event: SessionEvent.NODEWORKER_RECEIVEDMESSAGEFROMWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.ReceivedMessageFromWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * This event is fired instead of `Runtime.executionContextDestroyed` when
     * enabled.
     * It is fired when the Node process finished all code execution and is
     * waiting for all frontends to disconnect.
     */
    fun addListener(event: SessionEvent.NODERUNTIME_WAITINGFORDISCONNECT, listener: () -> Unit): Unit /* this */
    fun emit(event: String, vararg args: Any?): Boolean

    fun emit(event: js.symbol.Symbol, vararg args: Any?): Boolean
    fun emit(event: SessionEvent.INSPECTORNOTIFICATION, message: InspectorNotification<Any>): Boolean
    fun emit(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTCREATED,
        message: InspectorNotification<node.inspector.runtime.ExecutionContextCreatedEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTDESTROYED,
        message: InspectorNotification<node.inspector.runtime.ExecutionContextDestroyedEventDataType>,
    ): Boolean

    fun emit(event: SessionEvent.RUNTIME_EXECUTIONCONTEXTSCLEARED): Boolean
    fun emit(
        event: SessionEvent.RUNTIME_EXCEPTIONTHROWN,
        message: InspectorNotification<node.inspector.runtime.ExceptionThrownEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.RUNTIME_EXCEPTIONREVOKED,
        message: InspectorNotification<node.inspector.runtime.ExceptionRevokedEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.RUNTIME_CONSOLEAPICALLED,
        message: InspectorNotification<node.inspector.runtime.ConsoleAPICalledEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.RUNTIME_INSPECTREQUESTED,
        message: InspectorNotification<node.inspector.runtime.InspectRequestedEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.DEBUGGER_SCRIPTPARSED,
        message: InspectorNotification<node.inspector.debugger.ScriptParsedEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.DEBUGGER_SCRIPTFAILEDTOPARSE,
        message: InspectorNotification<node.inspector.debugger.ScriptFailedToParseEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.DEBUGGER_BREAKPOINTRESOLVED,
        message: InspectorNotification<node.inspector.debugger.BreakpointResolvedEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.DEBUGGER_PAUSED,
        message: InspectorNotification<node.inspector.debugger.PausedEventDataType>,
    ): Boolean

    fun emit(event: SessionEvent.DEBUGGER_RESUMED): Boolean
    fun emit(
        event: SessionEvent.CONSOLE_MESSAGEADDED,
        message: InspectorNotification<node.inspector.console.MessageAddedEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.PROFILER_CONSOLEPROFILESTARTED,
        message: InspectorNotification<node.inspector.profiler.ConsoleProfileStartedEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.PROFILER_CONSOLEPROFILEFINISHED,
        message: InspectorNotification<node.inspector.profiler.ConsoleProfileFinishedEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.HEAPPROFILER_ADDHEAPSNAPSHOTCHUNK,
        message: InspectorNotification<node.inspector.heapprofiler.AddHeapSnapshotChunkEventDataType>,
    ): Boolean

    fun emit(event: SessionEvent.HEAPPROFILER_RESETPROFILES): Boolean
    fun emit(
        event: SessionEvent.HEAPPROFILER_REPORTHEAPSNAPSHOTPROGRESS,
        message: InspectorNotification<node.inspector.heapprofiler.ReportHeapSnapshotProgressEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.HEAPPROFILER_LASTSEENOBJECTID,
        message: InspectorNotification<node.inspector.heapprofiler.LastSeenObjectIdEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.HEAPPROFILER_HEAPSTATSUPDATE,
        message: InspectorNotification<node.inspector.heapprofiler.HeapStatsUpdateEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.NODETRACING_DATACOLLECTED,
        message: InspectorNotification<node.inspector.nodetracing.DataCollectedEventDataType>,
    ): Boolean

    fun emit(event: SessionEvent.NODETRACING_TRACINGCOMPLETE): Boolean
    fun emit(
        event: SessionEvent.NODEWORKER_ATTACHEDTOWORKER,
        message: InspectorNotification<node.inspector.nodeworker.AttachedToWorkerEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.NODEWORKER_DETACHEDFROMWORKER,
        message: InspectorNotification<node.inspector.nodeworker.DetachedFromWorkerEventDataType>,
    ): Boolean

    fun emit(
        event: SessionEvent.NODEWORKER_RECEIVEDMESSAGEFROMWORKER,
        message: InspectorNotification<node.inspector.nodeworker.ReceivedMessageFromWorkerEventDataType>,
    ): Boolean

    fun emit(event: SessionEvent.NODERUNTIME_WAITINGFORDISCONNECT): Boolean
    fun on(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    /**
     * Emitted when any notification from the V8 Inspector is received.
     */
    fun on(
        event: SessionEvent.INSPECTORNOTIFICATION,
        listener: (message: InspectorNotification<Any>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when new execution context is created.
     */
    fun on(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTCREATED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExecutionContextCreatedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when execution context is destroyed.
     */
    fun on(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTDESTROYED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExecutionContextDestroyedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when all executionContexts were cleared in browser
     */
    fun on(event: SessionEvent.RUNTIME_EXECUTIONCONTEXTSCLEARED, listener: () -> Unit): Unit /* this */

    /**
     * Issued when exception was thrown and unhandled.
     */
    fun on(
        event: SessionEvent.RUNTIME_EXCEPTIONTHROWN,
        listener: (message: InspectorNotification<node.inspector.runtime.ExceptionThrownEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when unhandled exception was revoked.
     */
    fun on(
        event: SessionEvent.RUNTIME_EXCEPTIONREVOKED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExceptionRevokedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when console API was called.
     */
    fun on(
        event: SessionEvent.RUNTIME_CONSOLEAPICALLED,
        listener: (message: InspectorNotification<node.inspector.runtime.ConsoleAPICalledEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when object should be inspected (for example, as a result of inspect() command line API call).
     */
    fun on(
        event: SessionEvent.RUNTIME_INSPECTREQUESTED,
        listener: (message: InspectorNotification<node.inspector.runtime.InspectRequestedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when virtual machine parses script. This event is also fired for all known and uncollected scripts upon enabling debugger.
     */
    fun on(
        event: SessionEvent.DEBUGGER_SCRIPTPARSED,
        listener: (message: InspectorNotification<node.inspector.debugger.ScriptParsedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when virtual machine fails to parse the script.
     */
    fun on(
        event: SessionEvent.DEBUGGER_SCRIPTFAILEDTOPARSE,
        listener: (message: InspectorNotification<node.inspector.debugger.ScriptFailedToParseEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when breakpoint is resolved to an actual script and location.
     */
    fun on(
        event: SessionEvent.DEBUGGER_BREAKPOINTRESOLVED,
        listener: (message: InspectorNotification<node.inspector.debugger.BreakpointResolvedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when the virtual machine stopped on breakpoint or exception or any other stop criteria.
     */
    fun on(
        event: SessionEvent.DEBUGGER_PAUSED,
        listener: (message: InspectorNotification<node.inspector.debugger.PausedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when the virtual machine resumed execution.
     */
    fun on(event: SessionEvent.DEBUGGER_RESUMED, listener: () -> Unit): Unit /* this */

    /**
     * Issued when new console message is added.
     */
    fun on(
        event: SessionEvent.CONSOLE_MESSAGEADDED,
        listener: (message: InspectorNotification<node.inspector.console.MessageAddedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Sent when new profile recording is started using console.profile() call.
     */
    fun on(
        event: SessionEvent.PROFILER_CONSOLEPROFILESTARTED,
        listener: (message: InspectorNotification<node.inspector.profiler.ConsoleProfileStartedEventDataType>) -> Unit,
    ): Unit /* this */

    fun on(
        event: SessionEvent.PROFILER_CONSOLEPROFILEFINISHED,
        listener: (message: InspectorNotification<node.inspector.profiler.ConsoleProfileFinishedEventDataType>) -> Unit,
    ): Unit /* this */

    fun on(
        event: SessionEvent.HEAPPROFILER_ADDHEAPSNAPSHOTCHUNK,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.AddHeapSnapshotChunkEventDataType>) -> Unit,
    ): Unit /* this */

    fun on(event: SessionEvent.HEAPPROFILER_RESETPROFILES, listener: () -> Unit): Unit /* this */
    fun on(
        event: SessionEvent.HEAPPROFILER_REPORTHEAPSNAPSHOTPROGRESS,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.ReportHeapSnapshotProgressEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * If heap objects tracking has been started then backend regularly sends a current value for last seen object id and corresponding timestamp. If the were changes in the heap since last event then one or more heapStatsUpdate events will be sent before a new lastSeenObjectId event.
     */
    fun on(
        event: SessionEvent.HEAPPROFILER_LASTSEENOBJECTID,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.LastSeenObjectIdEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * If heap objects tracking has been started then backend may send update for one or more fragments
     */
    fun on(
        event: SessionEvent.HEAPPROFILER_HEAPSTATSUPDATE,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.HeapStatsUpdateEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Contains an bucket of collected trace events.
     */
    fun on(
        event: SessionEvent.NODETRACING_DATACOLLECTED,
        listener: (message: InspectorNotification<node.inspector.nodetracing.DataCollectedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Signals that tracing is stopped and there is no trace buffers pending flush, all data were
     * delivered via dataCollected events.
     */
    fun on(event: SessionEvent.NODETRACING_TRACINGCOMPLETE, listener: () -> Unit): Unit /* this */

    /**
     * Issued when attached to a worker.
     */
    fun on(
        event: SessionEvent.NODEWORKER_ATTACHEDTOWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.AttachedToWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when detached from the worker.
     */
    fun on(
        event: SessionEvent.NODEWORKER_DETACHEDFROMWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.DetachedFromWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Notifies about a new protocol message received from the session
     * (session ID is provided in attachedToWorker notification).
     */
    fun on(
        event: SessionEvent.NODEWORKER_RECEIVEDMESSAGEFROMWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.ReceivedMessageFromWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * This event is fired instead of `Runtime.executionContextDestroyed` when
     * enabled.
     * It is fired when the Node process finished all code execution and is
     * waiting for all frontends to disconnect.
     */
    fun on(event: SessionEvent.NODERUNTIME_WAITINGFORDISCONNECT, listener: () -> Unit): Unit /* this */
    fun once(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    /**
     * Emitted when any notification from the V8 Inspector is received.
     */
    fun once(
        event: SessionEvent.INSPECTORNOTIFICATION,
        listener: (message: InspectorNotification<Any>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when new execution context is created.
     */
    fun once(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTCREATED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExecutionContextCreatedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when execution context is destroyed.
     */
    fun once(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTDESTROYED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExecutionContextDestroyedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when all executionContexts were cleared in browser
     */
    fun once(event: SessionEvent.RUNTIME_EXECUTIONCONTEXTSCLEARED, listener: () -> Unit): Unit /* this */

    /**
     * Issued when exception was thrown and unhandled.
     */
    fun once(
        event: SessionEvent.RUNTIME_EXCEPTIONTHROWN,
        listener: (message: InspectorNotification<node.inspector.runtime.ExceptionThrownEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when unhandled exception was revoked.
     */
    fun once(
        event: SessionEvent.RUNTIME_EXCEPTIONREVOKED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExceptionRevokedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when console API was called.
     */
    fun once(
        event: SessionEvent.RUNTIME_CONSOLEAPICALLED,
        listener: (message: InspectorNotification<node.inspector.runtime.ConsoleAPICalledEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when object should be inspected (for example, as a result of inspect() command line API call).
     */
    fun once(
        event: SessionEvent.RUNTIME_INSPECTREQUESTED,
        listener: (message: InspectorNotification<node.inspector.runtime.InspectRequestedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when virtual machine parses script. This event is also fired for all known and uncollected scripts upon enabling debugger.
     */
    fun once(
        event: SessionEvent.DEBUGGER_SCRIPTPARSED,
        listener: (message: InspectorNotification<node.inspector.debugger.ScriptParsedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when virtual machine fails to parse the script.
     */
    fun once(
        event: SessionEvent.DEBUGGER_SCRIPTFAILEDTOPARSE,
        listener: (message: InspectorNotification<node.inspector.debugger.ScriptFailedToParseEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when breakpoint is resolved to an actual script and location.
     */
    fun once(
        event: SessionEvent.DEBUGGER_BREAKPOINTRESOLVED,
        listener: (message: InspectorNotification<node.inspector.debugger.BreakpointResolvedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when the virtual machine stopped on breakpoint or exception or any other stop criteria.
     */
    fun once(
        event: SessionEvent.DEBUGGER_PAUSED,
        listener: (message: InspectorNotification<node.inspector.debugger.PausedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when the virtual machine resumed execution.
     */
    fun once(event: SessionEvent.DEBUGGER_RESUMED, listener: () -> Unit): Unit /* this */

    /**
     * Issued when new console message is added.
     */
    fun once(
        event: SessionEvent.CONSOLE_MESSAGEADDED,
        listener: (message: InspectorNotification<node.inspector.console.MessageAddedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Sent when new profile recording is started using console.profile() call.
     */
    fun once(
        event: SessionEvent.PROFILER_CONSOLEPROFILESTARTED,
        listener: (message: InspectorNotification<node.inspector.profiler.ConsoleProfileStartedEventDataType>) -> Unit,
    ): Unit /* this */

    fun once(
        event: SessionEvent.PROFILER_CONSOLEPROFILEFINISHED,
        listener: (message: InspectorNotification<node.inspector.profiler.ConsoleProfileFinishedEventDataType>) -> Unit,
    ): Unit /* this */

    fun once(
        event: SessionEvent.HEAPPROFILER_ADDHEAPSNAPSHOTCHUNK,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.AddHeapSnapshotChunkEventDataType>) -> Unit,
    ): Unit /* this */

    fun once(event: SessionEvent.HEAPPROFILER_RESETPROFILES, listener: () -> Unit): Unit /* this */
    fun once(
        event: SessionEvent.HEAPPROFILER_REPORTHEAPSNAPSHOTPROGRESS,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.ReportHeapSnapshotProgressEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * If heap objects tracking has been started then backend regularly sends a current value for last seen object id and corresponding timestamp. If the were changes in the heap since last event then one or more heapStatsUpdate events will be sent before a new lastSeenObjectId event.
     */
    fun once(
        event: SessionEvent.HEAPPROFILER_LASTSEENOBJECTID,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.LastSeenObjectIdEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * If heap objects tracking has been started then backend may send update for one or more fragments
     */
    fun once(
        event: SessionEvent.HEAPPROFILER_HEAPSTATSUPDATE,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.HeapStatsUpdateEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Contains an bucket of collected trace events.
     */
    fun once(
        event: SessionEvent.NODETRACING_DATACOLLECTED,
        listener: (message: InspectorNotification<node.inspector.nodetracing.DataCollectedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Signals that tracing is stopped and there is no trace buffers pending flush, all data were
     * delivered via dataCollected events.
     */
    fun once(event: SessionEvent.NODETRACING_TRACINGCOMPLETE, listener: () -> Unit): Unit /* this */

    /**
     * Issued when attached to a worker.
     */
    fun once(
        event: SessionEvent.NODEWORKER_ATTACHEDTOWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.AttachedToWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when detached from the worker.
     */
    fun once(
        event: SessionEvent.NODEWORKER_DETACHEDFROMWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.DetachedFromWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Notifies about a new protocol message received from the session
     * (session ID is provided in attachedToWorker notification).
     */
    fun once(
        event: SessionEvent.NODEWORKER_RECEIVEDMESSAGEFROMWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.ReceivedMessageFromWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * This event is fired instead of `Runtime.executionContextDestroyed` when
     * enabled.
     * It is fired when the Node process finished all code execution and is
     * waiting for all frontends to disconnect.
     */
    fun once(event: SessionEvent.NODERUNTIME_WAITINGFORDISCONNECT, listener: () -> Unit): Unit /* this */
    fun prependListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    /**
     * Emitted when any notification from the V8 Inspector is received.
     */
    fun prependListener(
        event: SessionEvent.INSPECTORNOTIFICATION,
        listener: (message: InspectorNotification<Any>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when new execution context is created.
     */
    fun prependListener(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTCREATED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExecutionContextCreatedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when execution context is destroyed.
     */
    fun prependListener(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTDESTROYED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExecutionContextDestroyedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when all executionContexts were cleared in browser
     */
    fun prependListener(event: SessionEvent.RUNTIME_EXECUTIONCONTEXTSCLEARED, listener: () -> Unit): Unit /* this */

    /**
     * Issued when exception was thrown and unhandled.
     */
    fun prependListener(
        event: SessionEvent.RUNTIME_EXCEPTIONTHROWN,
        listener: (message: InspectorNotification<node.inspector.runtime.ExceptionThrownEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when unhandled exception was revoked.
     */
    fun prependListener(
        event: SessionEvent.RUNTIME_EXCEPTIONREVOKED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExceptionRevokedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when console API was called.
     */
    fun prependListener(
        event: SessionEvent.RUNTIME_CONSOLEAPICALLED,
        listener: (message: InspectorNotification<node.inspector.runtime.ConsoleAPICalledEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when object should be inspected (for example, as a result of inspect() command line API call).
     */
    fun prependListener(
        event: SessionEvent.RUNTIME_INSPECTREQUESTED,
        listener: (message: InspectorNotification<node.inspector.runtime.InspectRequestedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when virtual machine parses script. This event is also fired for all known and uncollected scripts upon enabling debugger.
     */
    fun prependListener(
        event: SessionEvent.DEBUGGER_SCRIPTPARSED,
        listener: (message: InspectorNotification<node.inspector.debugger.ScriptParsedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when virtual machine fails to parse the script.
     */
    fun prependListener(
        event: SessionEvent.DEBUGGER_SCRIPTFAILEDTOPARSE,
        listener: (message: InspectorNotification<node.inspector.debugger.ScriptFailedToParseEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when breakpoint is resolved to an actual script and location.
     */
    fun prependListener(
        event: SessionEvent.DEBUGGER_BREAKPOINTRESOLVED,
        listener: (message: InspectorNotification<node.inspector.debugger.BreakpointResolvedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when the virtual machine stopped on breakpoint or exception or any other stop criteria.
     */
    fun prependListener(
        event: SessionEvent.DEBUGGER_PAUSED,
        listener: (message: InspectorNotification<node.inspector.debugger.PausedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when the virtual machine resumed execution.
     */
    fun prependListener(event: SessionEvent.DEBUGGER_RESUMED, listener: () -> Unit): Unit /* this */

    /**
     * Issued when new console message is added.
     */
    fun prependListener(
        event: SessionEvent.CONSOLE_MESSAGEADDED,
        listener: (message: InspectorNotification<node.inspector.console.MessageAddedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Sent when new profile recording is started using console.profile() call.
     */
    fun prependListener(
        event: SessionEvent.PROFILER_CONSOLEPROFILESTARTED,
        listener: (message: InspectorNotification<node.inspector.profiler.ConsoleProfileStartedEventDataType>) -> Unit,
    ): Unit /* this */

    fun prependListener(
        event: SessionEvent.PROFILER_CONSOLEPROFILEFINISHED,
        listener: (message: InspectorNotification<node.inspector.profiler.ConsoleProfileFinishedEventDataType>) -> Unit,
    ): Unit /* this */

    fun prependListener(
        event: SessionEvent.HEAPPROFILER_ADDHEAPSNAPSHOTCHUNK,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.AddHeapSnapshotChunkEventDataType>) -> Unit,
    ): Unit /* this */

    fun prependListener(event: SessionEvent.HEAPPROFILER_RESETPROFILES, listener: () -> Unit): Unit /* this */
    fun prependListener(
        event: SessionEvent.HEAPPROFILER_REPORTHEAPSNAPSHOTPROGRESS,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.ReportHeapSnapshotProgressEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * If heap objects tracking has been started then backend regularly sends a current value for last seen object id and corresponding timestamp. If the were changes in the heap since last event then one or more heapStatsUpdate events will be sent before a new lastSeenObjectId event.
     */
    fun prependListener(
        event: SessionEvent.HEAPPROFILER_LASTSEENOBJECTID,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.LastSeenObjectIdEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * If heap objects tracking has been started then backend may send update for one or more fragments
     */
    fun prependListener(
        event: SessionEvent.HEAPPROFILER_HEAPSTATSUPDATE,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.HeapStatsUpdateEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Contains an bucket of collected trace events.
     */
    fun prependListener(
        event: SessionEvent.NODETRACING_DATACOLLECTED,
        listener: (message: InspectorNotification<node.inspector.nodetracing.DataCollectedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Signals that tracing is stopped and there is no trace buffers pending flush, all data were
     * delivered via dataCollected events.
     */
    fun prependListener(event: SessionEvent.NODETRACING_TRACINGCOMPLETE, listener: () -> Unit): Unit /* this */

    /**
     * Issued when attached to a worker.
     */
    fun prependListener(
        event: SessionEvent.NODEWORKER_ATTACHEDTOWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.AttachedToWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when detached from the worker.
     */
    fun prependListener(
        event: SessionEvent.NODEWORKER_DETACHEDFROMWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.DetachedFromWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Notifies about a new protocol message received from the session
     * (session ID is provided in attachedToWorker notification).
     */
    fun prependListener(
        event: SessionEvent.NODEWORKER_RECEIVEDMESSAGEFROMWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.ReceivedMessageFromWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * This event is fired instead of `Runtime.executionContextDestroyed` when
     * enabled.
     * It is fired when the Node process finished all code execution and is
     * waiting for all frontends to disconnect.
     */
    fun prependListener(event: SessionEvent.NODERUNTIME_WAITINGFORDISCONNECT, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    /**
     * Emitted when any notification from the V8 Inspector is received.
     */
    fun prependOnceListener(
        event: SessionEvent.INSPECTORNOTIFICATION,
        listener: (message: InspectorNotification<Any>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when new execution context is created.
     */
    fun prependOnceListener(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTCREATED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExecutionContextCreatedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when execution context is destroyed.
     */
    fun prependOnceListener(
        event: SessionEvent.RUNTIME_EXECUTIONCONTEXTDESTROYED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExecutionContextDestroyedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when all executionContexts were cleared in browser
     */
    fun prependOnceListener(event: SessionEvent.RUNTIME_EXECUTIONCONTEXTSCLEARED, listener: () -> Unit): Unit /* this */

    /**
     * Issued when exception was thrown and unhandled.
     */
    fun prependOnceListener(
        event: SessionEvent.RUNTIME_EXCEPTIONTHROWN,
        listener: (message: InspectorNotification<node.inspector.runtime.ExceptionThrownEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when unhandled exception was revoked.
     */
    fun prependOnceListener(
        event: SessionEvent.RUNTIME_EXCEPTIONREVOKED,
        listener: (message: InspectorNotification<node.inspector.runtime.ExceptionRevokedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when console API was called.
     */
    fun prependOnceListener(
        event: SessionEvent.RUNTIME_CONSOLEAPICALLED,
        listener: (message: InspectorNotification<node.inspector.runtime.ConsoleAPICalledEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when object should be inspected (for example, as a result of inspect() command line API call).
     */
    fun prependOnceListener(
        event: SessionEvent.RUNTIME_INSPECTREQUESTED,
        listener: (message: InspectorNotification<node.inspector.runtime.InspectRequestedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when virtual machine parses script. This event is also fired for all known and uncollected scripts upon enabling debugger.
     */
    fun prependOnceListener(
        event: SessionEvent.DEBUGGER_SCRIPTPARSED,
        listener: (message: InspectorNotification<node.inspector.debugger.ScriptParsedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when virtual machine fails to parse the script.
     */
    fun prependOnceListener(
        event: SessionEvent.DEBUGGER_SCRIPTFAILEDTOPARSE,
        listener: (message: InspectorNotification<node.inspector.debugger.ScriptFailedToParseEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when breakpoint is resolved to an actual script and location.
     */
    fun prependOnceListener(
        event: SessionEvent.DEBUGGER_BREAKPOINTRESOLVED,
        listener: (message: InspectorNotification<node.inspector.debugger.BreakpointResolvedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when the virtual machine stopped on breakpoint or exception or any other stop criteria.
     */
    fun prependOnceListener(
        event: SessionEvent.DEBUGGER_PAUSED,
        listener: (message: InspectorNotification<node.inspector.debugger.PausedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Fired when the virtual machine resumed execution.
     */
    fun prependOnceListener(event: SessionEvent.DEBUGGER_RESUMED, listener: () -> Unit): Unit /* this */

    /**
     * Issued when new console message is added.
     */
    fun prependOnceListener(
        event: SessionEvent.CONSOLE_MESSAGEADDED,
        listener: (message: InspectorNotification<node.inspector.console.MessageAddedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Sent when new profile recording is started using console.profile() call.
     */
    fun prependOnceListener(
        event: SessionEvent.PROFILER_CONSOLEPROFILESTARTED,
        listener: (message: InspectorNotification<node.inspector.profiler.ConsoleProfileStartedEventDataType>) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(
        event: SessionEvent.PROFILER_CONSOLEPROFILEFINISHED,
        listener: (message: InspectorNotification<node.inspector.profiler.ConsoleProfileFinishedEventDataType>) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(
        event: SessionEvent.HEAPPROFILER_ADDHEAPSNAPSHOTCHUNK,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.AddHeapSnapshotChunkEventDataType>) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(event: SessionEvent.HEAPPROFILER_RESETPROFILES, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(
        event: SessionEvent.HEAPPROFILER_REPORTHEAPSNAPSHOTPROGRESS,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.ReportHeapSnapshotProgressEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * If heap objects tracking has been started then backend regularly sends a current value for last seen object id and corresponding timestamp. If the were changes in the heap since last event then one or more heapStatsUpdate events will be sent before a new lastSeenObjectId event.
     */
    fun prependOnceListener(
        event: SessionEvent.HEAPPROFILER_LASTSEENOBJECTID,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.LastSeenObjectIdEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * If heap objects tracking has been started then backend may send update for one or more fragments
     */
    fun prependOnceListener(
        event: SessionEvent.HEAPPROFILER_HEAPSTATSUPDATE,
        listener: (message: InspectorNotification<node.inspector.heapprofiler.HeapStatsUpdateEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Contains an bucket of collected trace events.
     */
    fun prependOnceListener(
        event: SessionEvent.NODETRACING_DATACOLLECTED,
        listener: (message: InspectorNotification<node.inspector.nodetracing.DataCollectedEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Signals that tracing is stopped and there is no trace buffers pending flush, all data were
     * delivered via dataCollected events.
     */
    fun prependOnceListener(event: SessionEvent.NODETRACING_TRACINGCOMPLETE, listener: () -> Unit): Unit /* this */

    /**
     * Issued when attached to a worker.
     */
    fun prependOnceListener(
        event: SessionEvent.NODEWORKER_ATTACHEDTOWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.AttachedToWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Issued when detached from the worker.
     */
    fun prependOnceListener(
        event: SessionEvent.NODEWORKER_DETACHEDFROMWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.DetachedFromWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * Notifies about a new protocol message received from the session
     * (session ID is provided in attachedToWorker notification).
     */
    fun prependOnceListener(
        event: SessionEvent.NODEWORKER_RECEIVEDMESSAGEFROMWORKER,
        listener: (message: InspectorNotification<node.inspector.nodeworker.ReceivedMessageFromWorkerEventDataType>) -> Unit,
    ): Unit /* this */

    /**
     * This event is fired instead of `Runtime.executionContextDestroyed` when
     * enabled.
     * It is fired when the Node process finished all code execution and is
     * waiting for all frontends to disconnect.
     */
    fun prependOnceListener(event: SessionEvent.NODERUNTIME_WAITINGFORDISCONNECT, listener: () -> Unit): Unit /* this */
}
