// Generated by Karakum - do not modify it manually!


package node.inspector.runtime


/**
 * Detailed information about exception (or error) that was thrown during script compilation or execution.
 */

sealed external interface ExceptionDetails {
    /**
     * Exception id.
     */
    var exceptionId: Double

    /**
     * Exception text, which should be used together with exception object when available.
     */
    var text: String

    /**
     * Line number of the exception location (0-based).
     */
    var lineNumber: Double

    /**
     * Column number of the exception location (0-based).
     */
    var columnNumber: Double

    /**
     * Script ID of the exception location.
     */
    var scriptId: ScriptId?

    /**
     * URL of the exception location, to be used when the script was not reported.
     */
    var url: String?

    /**
     * JavaScript stack trace if available.
     */
    var stackTrace: StackTrace?

    /**
     * Exception object if available.
     */
    var exception: RemoteObject?

    /**
     * Identifier of the context where exception happened.
     */
    var executionContextId: ExecutionContextId?
}
