// Generated by Karakum - do not modify it manually!

@file:JsModule("node:readline/promises")

package node.readline

/**
 * The `readlinePromises.createInterface()` method creates a new `readlinePromises.Interface`instance.
 *
 * ```js
 * const readlinePromises = require('node:readline/promises');
 * const rl = readlinePromises.createInterface({
 *   input: process.stdin,
 *   output: process.stdout,
 * });
 * ```
 *
 * Once the `readlinePromises.Interface` instance is created, the most common case
 * is to listen for the `'line'` event:
 *
 * ```js
 * rl.on('line', (line) => {
 *   console.log(`Received: ${line}`);
 * });
 * ```
 *
 * If `terminal` is `true` for this instance then the `output` stream will get
 * the best compatibility if it defines an `output.columns` property and emits
 * a `'resize'` event on the `output` if or when the columns ever change
 * (`process.stdout` does this automatically when it is a TTY).
 * @since v17.0.0
 */
external fun createInterface(
    input: node.ReadableStream,
    output: node.WritableStream = definedExternally,
    completer: Completer = definedExternally,
    terminal: Boolean = definedExternally,
): Interface

external fun createInterface(
    input: node.ReadableStream,
    output: node.WritableStream = definedExternally,
    completer: AsyncCompleter = definedExternally,
    terminal: Boolean = definedExternally,
): Interface

external fun createInterface(options: ReadLineOptions): Interface
