// Generated by Karakum - do not modify it manually!

@file:JsModule("node:repl")

package node.repl

import node.vm.Context
import node.readline._Interface as Interface

/**
 * Instances of `repl.REPLServer` are created using the {@link start} method
 * or directly using the JavaScript `new` keyword.
 *
 * ```js
 * const repl = require('node:repl');
 *
 * const options = { useColors: true };
 *
 * const firstInstance = repl.start(options);
 * const secondInstance = new repl.REPLServer(options);
 * ```
 * @since v0.1.91
 */

external class REPLServer : Interface {
    /**
     * The `vm.Context` provided to the `eval` function to be used for JavaScript
     * evaluation.
     */
    val context: Context

    /**
     * @deprecated since v14.3.0 - Use `input` instead.
     */
    val inputStream: node.ReadableStream

    /**
     * @deprecated since v14.3.0 - Use `output` instead.
     */
    val outputStream: node.WritableStream

    /**
     * The `Readable` stream from which REPL input will be read.
     */
    val input: node.ReadableStream

    /**
     * The `Writable` stream to which REPL output will be written.
     */
    val output: node.WritableStream

    /**
     * The commands registered via `replServer.defineCommand()`.
     */
    val commands: node.ReadOnlyDict<REPLCommand>

    /**
     * A value indicating whether the REPL is currently in "editor mode".
     *
     * @see https://nodejs.org/dist/latest-v20.x/docs/api/repl.html#repl_commands_and_special_keys
     */
    val editorMode: Boolean

    /**
     * A value indicating whether the `_` variable has been assigned.
     *
     * @see https://nodejs.org/dist/latest-v20.x/docs/api/repl.html#repl_assignment_of_the_underscore_variable
     */
    val underscoreAssigned: Boolean

    /**
     * The last evaluation result from the REPL (assigned to the `_` variable inside of the REPL).
     *
     * @see https://nodejs.org/dist/latest-v20.x/docs/api/repl.html#repl_assignment_of_the_underscore_variable
     */
    val last: Any?

    /**
     * A value indicating whether the `_error` variable has been assigned.
     *
     * @since v9.8.0
     * @see https://nodejs.org/dist/latest-v20.x/docs/api/repl.html#repl_assignment_of_the_underscore_variable
     */
    val underscoreErrAssigned: Boolean

    /**
     * The last error raised inside the REPL (assigned to the `_error` variable inside of the REPL).
     *
     * @since v9.8.0
     * @see https://nodejs.org/dist/latest-v20.x/docs/api/repl.html#repl_assignment_of_the_underscore_variable
     */
    val lastError: Any?

    /**
     * Specified in the REPL options, this is the function to be used when evaluating each
     * given line of input. If not specified in the REPL options, this is an async wrapper
     * for the JavaScript `eval()` function.
     */
    val eval: REPLEval

    /**
     * Specified in the REPL options, this is a value indicating whether the default
     * `writer` function should include ANSI color styling to REPL output.
     */
    val useColors: Boolean

    /**
     * Specified in the REPL options, this is a value indicating whether the default `eval`
     * function will use the JavaScript `global` as the context as opposed to creating a new
     * separate context for the REPL instance.
     */
    val useGlobal: Boolean

    /**
     * Specified in the REPL options, this is a value indicating whether the default `writer`
     * function should output the result of a command if it evaluates to `undefined`.
     */
    val ignoreUndefined: Boolean

    /**
     * Specified in the REPL options, this is the function to invoke to format the output of
     * each command before writing to `outputStream`. If not specified in the REPL options,
     * this will be a wrapper for `util.inspect`.
     */
    val writer: REPLWriter

    /**
     * Specified in the REPL options, this is the function to use for custom Tab auto-completion.
     */
    val completer: Any /* Completer | AsyncCompleter */

    /**
     * Specified in the REPL options, this is a flag that specifies whether the default `eval`
     * function should execute all JavaScript commands in strict mode or default (sloppy) mode.
     * Possible values are:
     * - `repl.REPL_MODE_SLOPPY` - evaluates expressions in sloppy mode.
     * - `repl.REPL_MODE_STRICT` - evaluates expressions in strict mode. This is equivalent to
     *    prefacing every repl statement with `'use strict'`.
     */
    val replMode: Any /* typeof REPL_MODE_SLOPPY | typeof REPL_MODE_STRICT */

    /**
     * The `replServer.defineCommand()` method is used to add new `.`\-prefixed commands
     * to the REPL instance. Such commands are invoked by typing a `.` followed by the`keyword`. The `cmd` is either a `Function` or an `Object` with the following
     * properties:
     *
     * The following example shows two new commands added to the REPL instance:
     *
     * ```js
     * const repl = require('node:repl');
     *
     * const replServer = repl.start({ prompt: '> ' });
     * replServer.defineCommand('sayhello', {
     *   help: 'Say hello',
     *   action(name) {
     *     this.clearBufferedCommand();
     *     console.log(`Hello, ${name}!`);
     *     this.displayPrompt();
     *   },
     * });
     * replServer.defineCommand('saybye', function saybye() {
     *   console.log('Goodbye!');
     *   this.close();
     * });
     * ```
     *
     * The new commands can then be used from within the REPL instance:
     *
     * ```console
     * > .sayhello Node.js User
     * Hello, Node.js User!
     * > .saybye
     * Goodbye!
     * ```
     * @since v0.3.0
     * @param keyword The command keyword (_without_ a leading `.` character).
     * @param cmd The function to invoke when the command is processed.
     */
    fun defineCommand(keyword: String, cmd: REPLCommandAction): Unit

    fun defineCommand(keyword: String, cmd: REPLCommand): Unit

    /**
     * The `replServer.displayPrompt()` method readies the REPL instance for input
     * from the user, printing the configured `prompt` to a new line in the `output`and resuming the `input` to accept new input.
     *
     * When multi-line input is being entered, an ellipsis is printed rather than the
     * 'prompt'.
     *
     * When `preserveCursor` is `true`, the cursor placement will not be reset to `0`.
     *
     * The `replServer.displayPrompt` method is primarily intended to be called from
     * within the action function for commands registered using the`replServer.defineCommand()` method.
     * @since v0.1.91
     */
    fun displayPrompt(preserveCursor: Boolean = definedExternally): Unit

    /**
     * The `replServer.clearBufferedCommand()` method clears any command that has been
     * buffered but not yet executed. This method is primarily intended to be
     * called from within the action function for commands registered using the`replServer.defineCommand()` method.
     * @since v9.0.0
     */
    fun clearBufferedCommand(): Unit

    /**
     * Initializes a history log file for the REPL instance. When executing the
     * Node.js binary and using the command-line REPL, a history file is initialized
     * by default. However, this is not the case when creating a REPL
     * programmatically. Use this method to initialize a history log file when working
     * with REPL instances programmatically.
     * @since v11.10.0
     * @param historyPath the path to the history file
     * @param callback called when history writes are ready or upon error
     */
    fun setupHistory(path: String, callback: (err: Throwable /* JsError */?, repl: Unit /* this */) -> Unit): Unit

    /**
     * events.EventEmitter
     * 1. close - inherited from `readline.Interface`
     * 2. line - inherited from `readline.Interface`
     * 3. pause - inherited from `readline.Interface`
     * 4. resume - inherited from `readline.Interface`
     * 5. SIGCONT - inherited from `readline.Interface`
     * 6. SIGINT - inherited from `readline.Interface`
     * 7. SIGTSTP - inherited from `readline.Interface`
     * 8. exit
     * 9. reset
     */
    override fun addListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */
    fun addListener(event: REPLServerEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun addListener(event: REPLServerEvent.LINE, listener: (input: String) -> Unit): Unit /* this */
    fun addListener(event: REPLServerEvent.PAUSE, listener: () -> Unit): Unit /* this */
    fun addListener(event: REPLServerEvent.RESUME, listener: () -> Unit): Unit /* this */
    fun addListener(event: REPLServerEvent.SIGCONT, listener: () -> Unit): Unit /* this */
    fun addListener(event: REPLServerEvent.SIGINT, listener: () -> Unit): Unit /* this */
    fun addListener(event: REPLServerEvent.SIGTSTP, listener: () -> Unit): Unit /* this */
    fun addListener(event: REPLServerEvent.EXIT, listener: () -> Unit): Unit /* this */
    fun addListener(event: REPLServerEvent.RESET, listener: (context: Context) -> Unit): Unit /* this */
    override fun emit(event: String, vararg args: Any?): Boolean

    override fun emit(event: js.symbol.Symbol, vararg args: Any?): Boolean
    fun emit(event: REPLServerEvent.CLOSE): Boolean
    fun emit(event: REPLServerEvent.LINE, input: String): Boolean
    fun emit(event: REPLServerEvent.PAUSE): Boolean
    fun emit(event: REPLServerEvent.RESUME): Boolean
    fun emit(event: REPLServerEvent.SIGCONT): Boolean
    fun emit(event: REPLServerEvent.SIGINT): Boolean
    fun emit(event: REPLServerEvent.SIGTSTP): Boolean
    fun emit(event: REPLServerEvent.EXIT): Boolean
    fun emit(event: REPLServerEvent.RESET, context: Context): Boolean
    override fun on(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */
    fun on(event: REPLServerEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun on(event: REPLServerEvent.LINE, listener: (input: String) -> Unit): Unit /* this */
    fun on(event: REPLServerEvent.PAUSE, listener: () -> Unit): Unit /* this */
    fun on(event: REPLServerEvent.RESUME, listener: () -> Unit): Unit /* this */
    fun on(event: REPLServerEvent.SIGCONT, listener: () -> Unit): Unit /* this */
    fun on(event: REPLServerEvent.SIGINT, listener: () -> Unit): Unit /* this */
    fun on(event: REPLServerEvent.SIGTSTP, listener: () -> Unit): Unit /* this */
    fun on(event: REPLServerEvent.EXIT, listener: () -> Unit): Unit /* this */
    fun on(event: REPLServerEvent.RESET, listener: (context: Context) -> Unit): Unit /* this */
    override fun once(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */
    fun once(event: REPLServerEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun once(event: REPLServerEvent.LINE, listener: (input: String) -> Unit): Unit /* this */
    fun once(event: REPLServerEvent.PAUSE, listener: () -> Unit): Unit /* this */
    fun once(event: REPLServerEvent.RESUME, listener: () -> Unit): Unit /* this */
    fun once(event: REPLServerEvent.SIGCONT, listener: () -> Unit): Unit /* this */
    fun once(event: REPLServerEvent.SIGINT, listener: () -> Unit): Unit /* this */
    fun once(event: REPLServerEvent.SIGTSTP, listener: () -> Unit): Unit /* this */
    fun once(event: REPLServerEvent.EXIT, listener: () -> Unit): Unit /* this */
    fun once(event: REPLServerEvent.RESET, listener: (context: Context) -> Unit): Unit /* this */
    override fun prependListener(
        event: String,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    fun prependListener(event: REPLServerEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun prependListener(event: REPLServerEvent.LINE, listener: (input: String) -> Unit): Unit /* this */
    fun prependListener(event: REPLServerEvent.PAUSE, listener: () -> Unit): Unit /* this */
    fun prependListener(event: REPLServerEvent.RESUME, listener: () -> Unit): Unit /* this */
    fun prependListener(event: REPLServerEvent.SIGCONT, listener: () -> Unit): Unit /* this */
    fun prependListener(event: REPLServerEvent.SIGINT, listener: () -> Unit): Unit /* this */
    fun prependListener(event: REPLServerEvent.SIGTSTP, listener: () -> Unit): Unit /* this */
    fun prependListener(event: REPLServerEvent.EXIT, listener: () -> Unit): Unit /* this */
    fun prependListener(event: REPLServerEvent.RESET, listener: (context: Context) -> Unit): Unit /* this */
    override fun prependOnceListener(
        event: String,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    fun prependOnceListener(event: REPLServerEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(event: REPLServerEvent.LINE, listener: (input: String) -> Unit): Unit /* this */
    fun prependOnceListener(event: REPLServerEvent.PAUSE, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(event: REPLServerEvent.RESUME, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(event: REPLServerEvent.SIGCONT, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(event: REPLServerEvent.SIGINT, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(event: REPLServerEvent.SIGTSTP, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(event: REPLServerEvent.EXIT, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(event: REPLServerEvent.RESET, listener: (context: Context) -> Unit): Unit /* this */
}
