// Generated by Karakum - do not modify it manually!

@file:JsModule("node:stream")

package node.stream

import js.iterable.AsyncIterable
import js.iterable.AsyncIterableIterator
import js.promise.Promise
import js.typedarrays.Uint8Array
import node.ReadableStreamPipeOptions
import node.WritableStream

/**
 * @since v0.9.4
 */

open external class Readable : Stream, node.ReadableStream {
    constructor (opts: ReadableOptions = definedExternally)

    /**
     * Returns whether the stream was destroyed or errored before emitting `'end'`.
     * @since v16.8.0
     * @experimental
     */
    val readableAborted: Boolean

    /**
     * Is `true` if it is safe to call `readable.read()`, which means
     * the stream has not been destroyed or emitted `'error'` or `'end'`.
     * @since v11.4.0
     */
    override var readable: Boolean

    /**
     * Returns whether `'data'` has been emitted.
     * @since v16.7.0, v14.18.0
     * @experimental
     */
    val readableDidRead: Boolean

    /**
     * Getter for the property `encoding` of a given `Readable` stream. The `encoding`property can be set using the `readable.setEncoding()` method.
     * @since v12.7.0
     */
    val readableEncoding: node.buffer.BufferEncoding?

    /**
     * Becomes `true` when `'end'` event is emitted.
     * @since v12.9.0
     */
    val readableEnded: Boolean

    /**
     * This property reflects the current state of a `Readable` stream as described
     * in the `Three states` section.
     * @since v9.4.0
     */
    val readableFlowing: Boolean?

    /**
     * Returns the value of `highWaterMark` passed when creating this `Readable`.
     * @since v9.3.0
     */
    val readableHighWaterMark: Double

    /**
     * This property contains the number of bytes (or objects) in the queue
     * ready to be read. The value provides introspection data regarding
     * the status of the `highWaterMark`.
     * @since v9.4.0
     */
    val readableLength: Double

    /**
     * Getter for the property `objectMode` of a given `Readable` stream.
     * @since v12.3.0
     */
    val readableObjectMode: Boolean

    /**
     * Is `true` after `readable.destroy()` has been called.
     * @since v8.0.0
     */
    open var destroyed: Boolean

    /**
     * Is `true` after `'close'` has been emitted.
     * @since v18.0.0
     */
    open val closed: Boolean

    /**
     * Returns error if the stream has been destroyed with an error.
     * @since v18.0.0
     */
    open val errored: Throwable /* JsError */?

    open fun _construct(callback: (error: Throwable /* JsError */? /* use undefined for default */) -> Unit): Unit

    fun _read(size: Number): Unit

    /**
     * The `readable.read()` method reads data out of the internal buffer and
     * returns it. If no data is available to be read, `null` is returned. By default,
     * the data is returned as a `Buffer` object unless an encoding has been
     * specified using the `readable.setEncoding()` method or the stream is operating
     * in object mode.
     *
     * The optional `size` argument specifies a specific number of bytes to read. If`size` bytes are not available to be read, `null` will be returned _unless_the stream has ended, in which
     * case all of the data remaining in the internal
     * buffer will be returned.
     *
     * If the `size` argument is not specified, all of the data contained in the
     * internal buffer will be returned.
     *
     * The `size` argument must be less than or equal to 1 GiB.
     *
     * The `readable.read()` method should only be called on `Readable` streams
     * operating in paused mode. In flowing mode, `readable.read()` is called
     * automatically until the internal buffer is fully drained.
     *
     * ```js
     * const readable = getReadableStreamSomehow();
     *
     * // 'readable' may be triggered multiple times as data is buffered in
     * readable.on('readable', () => {
     *   let chunk;
     *   console.log('Stream is readable (new data received in buffer)');
     *   // Use a loop to make sure we read all currently available data
     *   while (null !== (chunk = readable.read())) {
     *     console.log(`Read ${chunk.length} bytes of data...`);
     *   }
     * });
     *
     * // 'end' will be triggered once when there is no more data available
     * readable.on('end', () => {
     *   console.log('Reached end of stream.');
     * });
     * ```
     *
     * Each call to `readable.read()` returns a chunk of data, or `null`. The chunks
     * are not concatenated. A `while` loop is necessary to consume all data
     * currently in the buffer. When reading a large file `.read()` may return `null`,
     * having consumed all buffered content so far, but there is still more data to
     * come not yet buffered. In this case a new `'readable'` event will be emitted
     * when there is more data in the buffer. Finally the `'end'` event will be
     * emitted when there is no more data to come.
     *
     * Therefore to read a file's whole contents from a `readable`, it is necessary
     * to collect chunks across multiple `'readable'` events:
     *
     * ```js
     * const chunks = [];
     *
     * readable.on('readable', () => {
     *   let chunk;
     *   while (null !== (chunk = readable.read())) {
     *     chunks.push(chunk);
     *   }
     * });
     *
     * readable.on('end', () => {
     *   const content = chunks.join('');
     * });
     * ```
     *
     * A `Readable` stream in object mode will always return a single item from
     * a call to `readable.read(size)`, regardless of the value of the`size` argument.
     *
     * If the `readable.read()` method returns a chunk of data, a `'data'` event will
     * also be emitted.
     *
     * Calling {@link read} after the `'end'` event has
     * been emitted will return `null`. No runtime error will be raised.
     * @since v0.9.4
     * @param size Optional argument to specify how much data to read.
     */

    @JsName("read")
    open fun readOrNull(size: Number = definedExternally): Any?


    /**
     * The `readable.setEncoding()` method sets the character encoding for
     * data read from the `Readable` stream.
     *
     * By default, no encoding is assigned and stream data will be returned as`Buffer` objects. Setting an encoding causes the stream data
     * to be returned as strings of the specified encoding rather than as `Buffer`objects. For instance, calling `readable.setEncoding('utf8')` will cause the
     * output data to be interpreted as UTF-8 data, and passed as strings. Calling`readable.setEncoding('hex')` will cause the data to be encoded in hexadecimal
     * string format.
     *
     * The `Readable` stream will properly handle multi-byte characters delivered
     * through the stream that would otherwise become improperly decoded if simply
     * pulled from the stream as `Buffer` objects.
     *
     * ```js
     * const readable = getReadableStreamSomehow();
     * readable.setEncoding('utf8');
     * readable.on('data', (chunk) => {
     *   assert.equal(typeof chunk, 'string');
     *   console.log('Got %d characters of string data:', chunk.length);
     * });
     * ```
     * @since v0.9.4
     * @param encoding The encoding to use.
     */
    override fun setEncoding(encoding: node.buffer.BufferEncoding): Unit /* this */

    /**
     * The `readable.pause()` method will cause a stream in flowing mode to stop
     * emitting `'data'` events, switching out of flowing mode. Any data that
     * becomes available will remain in the internal buffer.
     *
     * ```js
     * const readable = getReadableStreamSomehow();
     * readable.on('data', (chunk) => {
     *   console.log(`Received ${chunk.length} bytes of data.`);
     *   readable.pause();
     *   console.log('There will be no additional data for 1 second.');
     *   setTimeout(() => {
     *     console.log('Now data will start flowing again.');
     *     readable.resume();
     *   }, 1000);
     * });
     * ```
     *
     * The `readable.pause()` method has no effect if there is a `'readable'`event listener.
     * @since v0.9.4
     */
    override fun pause(): Unit /* this */

    /**
     * The `readable.resume()` method causes an explicitly paused `Readable` stream to
     * resume emitting `'data'` events, switching the stream into flowing mode.
     *
     * The `readable.resume()` method can be used to fully consume the data from a
     * stream without actually processing any of that data:
     *
     * ```js
     * getReadableStreamSomehow()
     *   .resume()
     *   .on('end', () => {
     *     console.log('Reached the end, but did not read anything.');
     *   });
     * ```
     *
     * The `readable.resume()` method has no effect if there is a `'readable'`event listener.
     * @since v0.9.4
     */
    override fun resume(): Unit /* this */

    /**
     * The `readable.isPaused()` method returns the current operating state of the`Readable`. This is used primarily by the mechanism that underlies the`readable.pipe()` method. In most
     * typical cases, there will be no reason to
     * use this method directly.
     *
     * ```js
     * const readable = new stream.Readable();
     *
     * readable.isPaused(); // === false
     * readable.pause();
     * readable.isPaused(); // === true
     * readable.resume();
     * readable.isPaused(); // === false
     * ```
     * @since v0.11.14
     */
    override fun isPaused(): Boolean

    /**
     * The `readable.unpipe()` method detaches a `Writable` stream previously attached
     * using the {@link pipe} method.
     *
     * If the `destination` is not specified, then _all_ pipes are detached.
     *
     * If the `destination` is specified, but no pipe is set up for it, then
     * the method does nothing.
     *
     * ```js
     * const fs = require('node:fs');
     * const readable = getReadableStreamSomehow();
     * const writable = fs.createWriteStream('file.txt');
     * // All the data from readable goes into 'file.txt',
     * // but only for the first second.
     * readable.pipe(writable);
     * setTimeout(() => {
     *   console.log('Stop writing to file.txt.');
     *   readable.unpipe(writable);
     *   console.log('Manually close the file stream.');
     *   writable.end();
     * }, 1000);
     * ```
     * @since v0.9.4
     * @param destination Optional specific stream to unpipe
     */
    override fun unpipe(destination: WritableStream): Unit /* this */

    /**
     * Passing `chunk` as `null` signals the end of the stream (EOF) and behaves the
     * same as `readable.push(null)`, after which no more data can be written. The EOF
     * signal is put at the end of the buffer and any buffered data will still be
     * flushed.
     *
     * The `readable.unshift()` method pushes a chunk of data back into the internal
     * buffer. This is useful in certain situations where a stream is being consumed by
     * code that needs to "un-consume" some amount of data that it has optimistically
     * pulled out of the source, so that the data can be passed on to some other party.
     *
     * The `stream.unshift(chunk)` method cannot be called after the `'end'` event
     * has been emitted or a runtime error will be thrown.
     *
     * Developers using `stream.unshift()` often should consider switching to
     * use of a `Transform` stream instead. See the `API for stream implementers` section for more information.
     *
     * ```js
     * // Pull off a header delimited by \n\n.
     * // Use unshift() if we get too much.
     * // Call the callback with (error, header, stream).
     * const { StringDecoder } = require('node:string_decoder');
     * function parseHeader(stream, callback) {
     *   stream.on('error', callback);
     *   stream.on('readable', onReadable);
     *   const decoder = new StringDecoder('utf8');
     *   let header = '';
     *   function onReadable() {
     *     let chunk;
     *     while (null !== (chunk = stream.read())) {
     *       const str = decoder.write(chunk);
     *       if (str.includes('\n\n')) {
     *         // Found the header boundary.
     *         const split = str.split(/\n\n/);
     *         header += split.shift();
     *         const remaining = split.join('\n\n');
     *         const buf = Buffer.from(remaining, 'utf8');
     *         stream.removeListener('error', callback);
     *         // Remove the 'readable' listener before unshifting.
     *         stream.removeListener('readable', onReadable);
     *         if (buf.length)
     *           stream.unshift(buf);
     *         // Now the body of the message can be read from the stream.
     *         callback(null, header, stream);
     *         return;
     *       }
     *       // Still reading the header.
     *       header += str;
     *     }
     *   }
     * }
     * ```
     *
     * Unlike {@link push}, `stream.unshift(chunk)` will not
     * end the reading process by resetting the internal reading state of the stream.
     * This can cause unexpected results if `readable.unshift()` is called during a
     * read (i.e. from within a {@link _read} implementation on a
     * custom stream). Following the call to `readable.unshift()` with an immediate {@link push} will reset the reading state appropriately,
     * however it is best to simply avoid calling `readable.unshift()` while in the
     * process of performing a read.
     * @since v0.9.11
     * @param chunk Chunk of data to unshift onto the read queue. For streams not operating in object mode, `chunk` must be a string, `Buffer`, `Uint8Array`, or `null`. For object mode
     * streams, `chunk` may be any JavaScript value.
     * @param encoding Encoding of string chunks. Must be a valid `Buffer` encoding, such as `'utf8'` or `'ascii'`.
     */
    fun unshift(chunk: Any?, encoding: node.buffer.BufferEncoding = definedExternally): Unit

    /**
     * Prior to Node.js 0.10, streams did not implement the entire `node:stream`module API as it is currently defined. (See `Compatibility` for more
     * information.)
     *
     * When using an older Node.js library that emits `'data'` events and has a {@link pause} method that is advisory only, the`readable.wrap()` method can be used to create a `Readable`
     * stream that uses
     * the old stream as its data source.
     *
     * It will rarely be necessary to use `readable.wrap()` but the method has been
     * provided as a convenience for interacting with older Node.js applications and
     * libraries.
     *
     * ```js
     * const { OldReader } = require('./old-api-module.js');
     * const { Readable } = require('node:stream');
     * const oreader = new OldReader();
     * const myReader = new Readable().wrap(oreader);
     *
     * myReader.on('readable', () => {
     *   myReader.read(); // etc.
     * });
     * ```
     * @since v0.9.4
     * @param stream An "old style" readable stream
     */
    override fun wrap(stream: node.ReadableStream): Unit /* this */

    fun push(chunk: Any?, encoding: node.buffer.BufferEncoding = definedExternally): Boolean

    /**
     * The iterator created by this method gives users the option to cancel the destruction
     * of the stream if the `for await...of` loop is exited by `return`, `break`, or `throw`,
     * or if the iterator should destroy the stream if the stream emitted an error during iteration.
     * @since v16.3.0
     * @param options.destroyOnReturn When set to `false`, calling `return` on the async iterator,
     * or exiting a `for await...of` iteration using a `break`, `return`, or `throw` will not destroy the stream.
     * **Default: `true`**.
     */
    fun iterator(options: ReadableBaseIteratorOptions = definedExternally): AsyncIterableIterator<Any?>

    /**
     * This method allows mapping over the stream. The *fn* function will be called for every chunk in the stream.
     * If the *fn* function returns a promise - that promise will be `await`ed before being passed to the result stream.
     * @since v17.4.0, v16.14.0
     * @param fn a function to map over every chunk in the stream. Async or not.
     * @returns a stream mapped with the function *fn*.
     */
    fun map(
        fn: (data: Any?, options: ArrayOptions? /* use undefined for default */) -> Any?,
        options: ArrayOptions = definedExternally,
    ): Readable

    /**
     * This method allows filtering the stream. For each chunk in the stream the *fn* function will be called
     * and if it returns a truthy value, the chunk will be passed to the result stream.
     * If the *fn* function returns a promise - that promise will be `await`ed.
     * @since v17.4.0, v16.14.0
     * @param fn a function to filter chunks from the stream. Async or not.
     * @returns a stream filtered with the predicate *fn*.
     */
    fun filter(
        fn: (data: Any?, options: ArrayOptions? /* use undefined for default */) -> js.promise.PromiseResult<Boolean>,
        options: ArrayOptions = definedExternally,
    ): Readable

    /**
     * This method allows iterating a stream. For each chunk in the stream the *fn* function will be called.
     * If the *fn* function returns a promise - that promise will be `await`ed.
     *
     * This method is different from `for await...of` loops in that it can optionally process chunks concurrently.
     * In addition, a `forEach` iteration can only be stopped by having passed a `signal` option
     * and aborting the related AbortController while `for await...of` can be stopped with `break` or `return`.
     * In either case the stream will be destroyed.
     *
     * This method is different from listening to the `'data'` event in that it uses the `readable` event
     * in the underlying machinary and can limit the number of concurrent *fn* calls.
     * @since v17.5.0
     * @param fn a function to call on each chunk of the stream. Async or not.
     * @returns a promise for when the stream has finished.
     */
    fun forEach(
        fn: (data: Any?, options: ArrayOptions? /* use undefined for default */) -> js.promise.PromiseResult<Unit>,
        options: ArrayOptions = definedExternally,
    ): Promise<Unit>

    /**
     * This method allows easily obtaining the contents of a stream.
     *
     * As this method reads the entire stream into memory, it negates the benefits of streams. It's intended
     * for interoperability and convenience, not as the primary way to consume streams.
     * @since v17.5.0
     * @returns a promise containing an array with the contents of the stream.
     */
    fun toArray(options: ArrayOptions = definedExternally): Promise<js.array.ReadonlyArray<Any?>>

    /**
     * This method is similar to `Array.prototype.some` and calls *fn* on each chunk in the stream
     * until the awaited return value is `true` (or any truthy value). Once an *fn* call on a chunk
     * `await`ed return value is truthy, the stream is destroyed and the promise is fulfilled with `true`.
     * If none of the *fn* calls on the chunks return a truthy value, the promise is fulfilled with `false`.
     * @since v17.5.0
     * @param fn a function to call on each chunk of the stream. Async or not.
     * @returns a promise evaluating to `true` if *fn* returned a truthy value for at least one of the chunks.
     */
    fun some(
        fn: (data: Any?, options: ArrayOptions? /* use undefined for default */) -> js.promise.PromiseResult<Boolean>,
        options: ArrayOptions = definedExternally,
    ): Promise<Boolean>

    /**
     * This method is similar to `Array.prototype.find` and calls *fn* on each chunk in the stream
     * to find a chunk with a truthy value for *fn*. Once an *fn* call's awaited return value is truthy,
     * the stream is destroyed and the promise is fulfilled with value for which *fn* returned a truthy value.
     * If all of the *fn* calls on the chunks return a falsy value, the promise is fulfilled with `undefined`.
     * @since v17.5.0
     * @param fn a function to call on each chunk of the stream. Async or not.
     * @returns a promise evaluating to the first chunk for which *fn* evaluated with a truthy value,
     * or `undefined` if no element was found.
     */
    fun <T> find(
        fn: (data: Any?, options: ArrayOptions? /* use undefined for default */) -> Boolean, /* data is T */
        options: ArrayOptions = definedExternally,
    ): Promise<T?>

    fun find(
        fn: (data: Any?, options: ArrayOptions? /* use undefined for default */) -> js.promise.PromiseResult<Boolean>,
        options: ArrayOptions = definedExternally,
    ): Promise<Any?>

    /**
     * This method is similar to `Array.prototype.every` and calls *fn* on each chunk in the stream
     * to check if all awaited return values are truthy value for *fn*. Once an *fn* call on a chunk
     * `await`ed return value is falsy, the stream is destroyed and the promise is fulfilled with `false`.
     * If all of the *fn* calls on the chunks return a truthy value, the promise is fulfilled with `true`.
     * @since v17.5.0
     * @param fn a function to call on each chunk of the stream. Async or not.
     * @returns a promise evaluating to `true` if *fn* returned a truthy value for every one of the chunks.
     */
    fun every(
        fn: (data: Any?, options: ArrayOptions? /* use undefined for default */) -> js.promise.PromiseResult<Boolean>,
        options: ArrayOptions = definedExternally,
    ): Promise<Boolean>

    /**
     * This method returns a new stream by applying the given callback to each chunk of the stream
     * and then flattening the result.
     *
     * It is possible to return a stream or another iterable or async iterable from *fn* and the result streams
     * will be merged (flattened) into the returned stream.
     * @since v17.5.0
     * @param fn a function to map over every chunk in the stream. May be async. May be a stream or generator.
     * @returns a stream flat-mapped with the function *fn*.
     */
    fun flatMap(
        fn: (data: Any?, options: ArrayOptions? /* use undefined for default */) -> Any?,
        options: ArrayOptions = definedExternally,
    ): Readable

    /**
     * This method returns a new stream with the first *limit* chunks dropped from the start.
     * @since v17.5.0
     * @param limit the number of chunks to drop from the readable.
     * @returns a stream with *limit* chunks dropped from the start.
     */
    fun drop(limit: Number, options: ArrayOptions = definedExternally): Readable

    /**
     * This method returns a new stream with the first *limit* chunks.
     * @since v17.5.0
     * @param limit the number of chunks to take from the readable.
     * @returns a stream with *limit* chunks taken.
     */
    fun take(limit: Number, options: ArrayOptions = definedExternally): Readable

    /**
     * This method returns a new stream with chunks of the underlying stream paired with a counter
     * in the form `[index, chunk]`. The first index value is `0` and it increases by 1 for each chunk produced.
     * @since v17.5.0
     * @returns a stream of indexed pairs.
     */
    fun asIndexedPairs(options: ArrayOptions = definedExternally): Readable

    /**
     * This method calls *fn* on each chunk of the stream in order, passing it the result from the calculation
     * on the previous element. It returns a promise for the final value of the reduction.
     *
     * If no *initial* value is supplied the first chunk of the stream is used as the initial value.
     * If the stream is empty, the promise is rejected with a `TypeError` with the `ERR_INVALID_ARGS` code property.
     *
     * The reducer function iterates the stream element-by-element which means that there is no *concurrency* parameter
     * or parallelism. To perform a reduce concurrently, you can extract the async function to `readable.map` method.
     * @since v17.5.0
     * @param fn a reducer function to call over every chunk in the stream. Async or not.
     * @param initial the initial value to use in the reduction.
     * @returns a promise for the final value of the reduction.
     */
    fun <T /* default is Any? */> reduce(
        fn: (previous: Any?, data: Any?, options: ArrayOptions? /* use undefined for default */) -> T,
        initial: Nothing? = definedExternally,
        options: ArrayOptions = definedExternally,
    ): Promise<T>

    fun <T /* default is Any? */> reduce(
        fn: (previous: T, data: Any?, options: ArrayOptions? /* use undefined for default */) -> T,
        initial: T,
        options: ArrayOptions = definedExternally,
    ): Promise<T>

    open fun _destroy(
        error: Throwable /* JsError */?,
        callback: (error: Throwable /* JsError */? /* use undefined for default */) -> Unit,
    ): Unit

    /**
     * Destroy the stream. Optionally emit an `'error'` event, and emit a `'close'`event (unless `emitClose` is set to `false`). After this call, the readable
     * stream will release any internal resources and subsequent calls to `push()`will be ignored.
     *
     * Once `destroy()` has been called any further calls will be a no-op and no
     * further errors except from `_destroy()` may be emitted as `'error'`.
     *
     * Implementors should not override this method, but instead implement `readable._destroy()`.
     * @since v8.0.0
     * @param error Error which will be passed as payload in `'error'` event
     */
    open fun destroy(): Unit /* this */

    open fun destroy(error: Throwable /* JsError */): Unit /* this */

    /**
     * Event emitter
     * The defined events on documents including:
     * 1. close
     * 2. data
     * 3. end
     * 4. error
     * 5. pause
     * 6. readable
     * 7. resume
     */
    fun addListener(event: ReadableEvent.CLOSE, listener: () -> Unit): Unit /* this */

    fun addListener(event: ReadableEvent.DATA, listener: (chunk: Any?) -> Unit): Unit /* this */

    fun addListener(event: ReadableEvent.END, listener: () -> Unit): Unit /* this */

    fun addListener(event: ReadableEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */

    fun addListener(event: ReadableEvent.PAUSE, listener: () -> Unit): Unit /* this */

    fun addListener(event: ReadableEvent.READABLE, listener: () -> Unit): Unit /* this */

    fun addListener(event: ReadableEvent.RESUME, listener: () -> Unit): Unit /* this */

    open fun addListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    open fun addListener(
        event: js.symbol.Symbol,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    fun emit(event: ReadableEvent.CLOSE): Boolean

    fun emit(event: ReadableEvent.DATA, chunk: Any?): Boolean

    fun emit(event: ReadableEvent.END): Boolean

    fun emit(event: ReadableEvent.ERROR, err: Throwable /* JsError */): Boolean

    fun emit(event: ReadableEvent.PAUSE): Boolean

    fun emit(event: ReadableEvent.READABLE): Boolean

    fun emit(event: ReadableEvent.RESUME): Boolean

    open fun emit(event: String, vararg args: Any?): Boolean

    open fun emit(event: js.symbol.Symbol, vararg args: Any?): Boolean

    fun on(event: ReadableEvent.CLOSE, listener: () -> Unit): Unit /* this */

    fun on(event: ReadableEvent.DATA, listener: (chunk: Any?) -> Unit): Unit /* this */

    fun on(event: ReadableEvent.END, listener: () -> Unit): Unit /* this */

    fun on(event: ReadableEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */

    fun on(event: ReadableEvent.PAUSE, listener: () -> Unit): Unit /* this */

    fun on(event: ReadableEvent.READABLE, listener: () -> Unit): Unit /* this */

    fun on(event: ReadableEvent.RESUME, listener: () -> Unit): Unit /* this */

    open fun on(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    open fun on(event: js.symbol.Symbol, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    fun once(event: ReadableEvent.CLOSE, listener: () -> Unit): Unit /* this */

    fun once(event: ReadableEvent.DATA, listener: (chunk: Any?) -> Unit): Unit /* this */

    fun once(event: ReadableEvent.END, listener: () -> Unit): Unit /* this */

    fun once(event: ReadableEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */

    fun once(event: ReadableEvent.PAUSE, listener: () -> Unit): Unit /* this */

    fun once(event: ReadableEvent.READABLE, listener: () -> Unit): Unit /* this */

    fun once(event: ReadableEvent.RESUME, listener: () -> Unit): Unit /* this */

    open fun once(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    open fun once(event: js.symbol.Symbol, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    fun prependListener(event: ReadableEvent.CLOSE, listener: () -> Unit): Unit /* this */

    fun prependListener(event: ReadableEvent.DATA, listener: (chunk: Any?) -> Unit): Unit /* this */

    fun prependListener(event: ReadableEvent.END, listener: () -> Unit): Unit /* this */

    fun prependListener(event: ReadableEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */

    fun prependListener(event: ReadableEvent.PAUSE, listener: () -> Unit): Unit /* this */

    fun prependListener(event: ReadableEvent.READABLE, listener: () -> Unit): Unit /* this */

    fun prependListener(event: ReadableEvent.RESUME, listener: () -> Unit): Unit /* this */

    open fun prependListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    open fun prependListener(
        event: js.symbol.Symbol,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    fun prependOnceListener(event: ReadableEvent.CLOSE, listener: () -> Unit): Unit /* this */

    fun prependOnceListener(event: ReadableEvent.DATA, listener: (chunk: Any?) -> Unit): Unit /* this */

    fun prependOnceListener(event: ReadableEvent.END, listener: () -> Unit): Unit /* this */

    fun prependOnceListener(
        event: ReadableEvent.ERROR,
        listener: (err: Throwable /* JsError */) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(event: ReadableEvent.PAUSE, listener: () -> Unit): Unit /* this */

    fun prependOnceListener(event: ReadableEvent.READABLE, listener: () -> Unit): Unit /* this */

    fun prependOnceListener(event: ReadableEvent.RESUME, listener: () -> Unit): Unit /* this */

    open fun prependOnceListener(
        event: String,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    open fun prependOnceListener(
        event: js.symbol.Symbol,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    fun removeListener(event: ReadableEvent.CLOSE, listener: () -> Unit): Unit /* this */

    fun removeListener(event: ReadableEvent.DATA, listener: (chunk: Any?) -> Unit): Unit /* this */

    fun removeListener(event: ReadableEvent.END, listener: () -> Unit): Unit /* this */

    fun removeListener(event: ReadableEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */

    fun removeListener(event: ReadableEvent.PAUSE, listener: () -> Unit): Unit /* this */

    fun removeListener(event: ReadableEvent.READABLE, listener: () -> Unit): Unit /* this */

    fun removeListener(event: ReadableEvent.RESUME, listener: () -> Unit): Unit /* this */

    open fun removeListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    open fun removeListener(
        event: js.symbol.Symbol,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    /* [Symbol.asyncIterator](): AsyncIterableIterator<any>; */

    /**
     * Calls `readable.destroy()` with an `AbortError` and returns a promise that fulfills when the stream is finished.
     * @since v20.4.0
     */
    /* [Symbol.asyncDispose](): Promise<void>; */

    override fun read(size: Number): Any /* string | Buffer */

    override fun <T : WritableStream> pipe(destination: T, options: ReadableStreamPipeOptions): T

    override fun unshift(chunk: String, encoding: node.buffer.BufferEncoding): Unit

    override fun unshift(chunk: Uint8Array, encoding: node.buffer.BufferEncoding): Unit

    companion object {
        /**
         * A utility method for creating a `Readable` from a web `ReadableStream`.
         * @since v17.0.0
         * @experimental
         */
        fun fromWeb(
            readableStream: web.streams.ReadableStream<*>,
            options: ReadableOptions = definedExternally,
        ): Readable

        /**
         * A utility method for creating a web `ReadableStream` from a `Readable`.
         * @since v17.0.0
         * @experimental
         */
        fun toWeb(streamReadable: Readable): web.streams.ReadableStream<*>

        /**
         * A utility method for creating Readable Streams out of iterators.
         */
        fun from(iterable: js.iterable.JsIterable<Any?>, options: ReadableOptions = definedExternally): Readable

        fun from(iterable: AsyncIterable<Any?>, options: ReadableOptions = definedExternally): Readable

        /**
         * Returns whether the stream has been read from or cancelled.
         * @since v16.8.0
         */
        fun isDisturbed(stream: Readable): Boolean

        fun isDisturbed(stream: node.ReadableStream): Boolean
    }

}
