// Generated by Karakum - do not modify it manually!

@file:JsModule("node:test")

package node.test


/**
 * The `MockFunctionContext` class is used to inspect or manipulate the behavior of
 * mocks created via the `MockTracker` APIs.
 * @since v19.1.0, v18.13.0
 */

external class MockFunctionContext<F : Function<*>> {
    /**
     * A getter that returns a copy of the internal array used to track calls to the
     * mock. Each entry in the array is an object with the following properties.
     * @since v19.1.0, v18.13.0
     */
    val calls: Array<MockFunctionCall<F, *, *>>

    /**
     * This function returns the number of times that this mock has been invoked. This
     * function is more efficient than checking `ctx.calls.length` because `ctx.calls`is a getter that creates a copy of the internal call tracking array.
     * @since v19.1.0, v18.13.0
     * @return The number of times that this mock has been invoked.
     */
    fun callCount(): Double

    /**
     * This function is used to change the behavior of an existing mock.
     *
     * The following example creates a mock function using `t.mock.fn()`, calls the
     * mock function, and then changes the mock implementation to a different function.
     *
     * ```js
     * test('changes a mock behavior', (t) => {
     *   let cnt = 0;
     *
     *   function addOne() {
     *     cnt++;
     *     return cnt;
     *   }
     *
     *   function addTwo() {
     *     cnt += 2;
     *     return cnt;
     *   }
     *
     *   const fn = t.mock.fn(addOne);
     *
     *   assert.strictEqual(fn(), 1);
     *   fn.mock.mockImplementation(addTwo);
     *   assert.strictEqual(fn(), 3);
     *   assert.strictEqual(fn(), 5);
     * });
     * ```
     * @since v19.1.0, v18.13.0
     * @param implementation The function to be used as the mock's new implementation.
     */
    fun mockImplementation(implementation: Function<*>): Unit

    /**
     * This function is used to change the behavior of an existing mock for a single
     * invocation. Once invocation `onCall` has occurred, the mock will revert to
     * whatever behavior it would have used had `mockImplementationOnce()` not been
     * called.
     *
     * The following example creates a mock function using `t.mock.fn()`, calls the
     * mock function, changes the mock implementation to a different function for the
     * next invocation, and then resumes its previous behavior.
     *
     * ```js
     * test('changes a mock behavior once', (t) => {
     *   let cnt = 0;
     *
     *   function addOne() {
     *     cnt++;
     *     return cnt;
     *   }
     *
     *   function addTwo() {
     *     cnt += 2;
     *     return cnt;
     *   }
     *
     *   const fn = t.mock.fn(addOne);
     *
     *   assert.strictEqual(fn(), 1);
     *   fn.mock.mockImplementationOnce(addTwo);
     *   assert.strictEqual(fn(), 3);
     *   assert.strictEqual(fn(), 4);
     * });
     * ```
     * @since v19.1.0, v18.13.0
     * @param implementation The function to be used as the mock's implementation for the invocation number specified by `onCall`.
     * @param onCall The invocation number that will use `implementation`. If the specified invocation has already occurred then an exception is thrown.
     */
    fun mockImplementationOnce(implementation: Function<*>, onCall: Number = definedExternally): Unit

    /**
     * Resets the call history of the mock function.
     * @since v19.3.0, v18.13.0
     */
    fun resetCalls(): Unit

    /**
     * Resets the implementation of the mock function to its original behavior. The
     * mock can still be used after calling this function.
     * @since v19.1.0, v18.13.0
     */
    fun restore(): Unit
}
