// Generated by Karakum - do not modify it manually!


package node.test

import web.abort.AbortSignal


sealed external interface RunOptions {
    /**
     * If a number is provided, then that many files would run in parallel.
     * If truthy, it would run (number of cpu cores - 1) files in parallel.
     * If falsy, it would only run one file at a time.
     * If unspecified, subtests inherit this value from their parent.
     * @default true
     */
    var concurrency: Any? /* number | boolean | undefined */

    /**
     * An array containing the list of files to run.
     * If unspecified, the test runner execution model will be used.
     */
    var files: (Array<out String>)?

    /**
     * Allows aborting an in-progress test execution.
     * @default undefined
     */
    var signal: AbortSignal?

    /**
     * A number of milliseconds the test will fail after.
     * If unspecified, subtests inherit this value from their parent.
     * @default Infinity
     */
    var timeout: Double?

    /**
     * Sets inspector port of test child process.
     * If a nullish value is provided, each process gets its own port,
     * incremented from the primary's `process.debugPort`.
     */
    var inspectPort: Any? /* number | (() => number) | undefined */

    /**
     * That can be used to only run tests whose name matches the provided pattern.
     * Test name patterns are interpreted as JavaScript regular expressions.
     * For each test that is executed, any corresponding test hooks, such as `beforeEach()`, are also run.
     */
    var testNamePatterns: (Any /* string | RegExp | string[] | RegExp[] */)?

    /**
     * If truthy, the test context will only run tests that have the `only` option set
     */
    var only: Boolean?

    /**
     * A function that accepts the TestsStream instance and can be used to setup listeners before any tests are run.
     */
    var setup: ((root: Test) -> js.promise.PromiseResult<Unit>)?

    /**
     * Whether to run in watch mode or not.
     * @default false
     */
    var watch: Boolean?

    /**
     * Running tests in a specific shard.
     * @default undefined
     */
    var shard: TestShard?
}
