// Generated by Karakum - do not modify it manually!


package node.traceEvents


/**
 * The `Tracing` object is used to enable or disable tracing for sets of
 * categories. Instances are created using the
 * `trace_events.createTracing()` method.
 *
 * When created, the `Tracing` object is disabled. Calling the
 * `tracing.enable()` method adds the categories to the set of enabled trace
 * event categories. Calling `tracing.disable()` will remove the categories
 * from the set of enabled trace event categories.
 */

sealed external interface Tracing {
    /**
     * A comma-separated list of the trace event categories covered by this
     * `Tracing` object.
     */
    val categories: String

    /**
     * Disables this `Tracing` object.
     *
     * Only trace event categories _not_ covered by other enabled `Tracing`
     * objects and _not_ specified by the `--trace-event-categories` flag
     * will be disabled.
     */
    fun disable(): Unit

    /**
     * Enables this `Tracing` object for the set of categories covered by
     * the `Tracing` object.
     */
    fun enable(): Unit

    /**
     * `true` only if the `Tracing` object has been enabled.
     */
    val enabled: Boolean
}
