// Generated by Karakum - do not modify it manually!

@file:JsModule("node:url")

package node.url


/**
 * The `url.parse()` method takes a URL string, parses it, and returns a URL
 * object.
 *
 * A `TypeError` is thrown if `urlString` is not a string.
 *
 * A `URIError` is thrown if the `auth` property is present but cannot be decoded.
 *
 * `url.parse()` uses a lenient, non-standard algorithm for parsing URL
 * strings. It is prone to security issues such as [host name spoofing](https://hackerone.com/reports/678487) and incorrect handling of usernames and passwords. Do not use with untrusted
 * input. CVEs are not issued for `url.parse()` vulnerabilities. Use the `WHATWG URL` API instead.
 * @since v0.1.25
 * @deprecated Use the WHATWG URL API instead.
 * @param urlString The URL string to parse.
 * @param [parseQueryString=false] If `true`, the `query` property will always be set to an object returned by the {@link querystring} module's `parse()` method. If `false`, the `query` property
 * on the returned URL object will be an unparsed, undecoded string.
 * @param [slashesDenoteHost=false] If `true`, the first token after the literal string `//` and preceding the next `/` will be interpreted as the `host`. For instance, given `//foo/bar`, the
 * result would be `{host: 'foo', pathname: '/bar'}` rather than `{pathname: '//foo/bar'}`.
 */
external fun parse(urlString: String): UrlWithStringQuery


external fun parse(urlString: String, parseQueryString: Boolean, slashesDenoteHost: Boolean = definedExternally): Url
