// Generated by Karakum - do not modify it manually!

@file:JsModule("node:util")

package node.util


/**
 * Usage of `util.inherits()` is discouraged. Please use the ES6 `class` and`extends` keywords to get language level inheritance support. Also note
 * that the two styles are [semantically incompatible](https://github.com/nodejs/node/issues/4179).
 *
 * Inherit the prototype methods from one [constructor](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/constructor) into another. The
 * prototype of `constructor` will be set to a new object created from`superConstructor`.
 *
 * This mainly adds some input validation on top of`Object.setPrototypeOf(constructor.prototype, superConstructor.prototype)`.
 * As an additional convenience, `superConstructor` will be accessible
 * through the `constructor.super_` property.
 *
 * ```js
 * const util = require('node:util');
 * const EventEmitter = require('node:events');
 *
 * function MyStream() {
 *   EventEmitter.call(this);
 * }
 *
 * util.inherits(MyStream, EventEmitter);
 *
 * MyStream.prototype.write = function(data) {
 *   this.emit('data', data);
 * };
 *
 * const stream = new MyStream();
 *
 * console.log(stream instanceof EventEmitter); // true
 * console.log(MyStream.super_ === EventEmitter); // true
 *
 * stream.on('data', (data) => {
 *   console.log(`Received data: "${data}"`);
 * });
 * stream.write('It works!'); // Received data: "It works!"
 * ```
 *
 * ES6 example using `class` and `extends`:
 *
 * ```js
 * const EventEmitter = require('node:events');
 *
 * class MyStream extends EventEmitter {
 *   write(data) {
 *     this.emit('data', data);
 *   }
 * }
 *
 * const stream = new MyStream();
 *
 * stream.on('data', (data) => {
 *   console.log(`Received data: "${data}"`);
 * });
 * stream.write('With ES6');
 * ```
 * @since v0.3.0
 * @legacy Use ES2015 class syntax and `extends` keyword instead.
 */
external fun inherits(constructor: Any?, superConstructor: Any?): Unit
