// Generated by Karakum - do not modify it manually!

@file:JsModule("node:util/types")

package node.util.types


/**
 * Returns `true` if the value was returned by the constructor of a [built-in `Error` type](https://tc39.es/ecma262/#sec-error-objects).
 *
 * ```js
 * console.log(util.types.isNativeError(new Error()));  // true
 * console.log(util.types.isNativeError(new TypeError()));  // true
 * console.log(util.types.isNativeError(new RangeError()));  // true
 * ```
 *
 * Subclasses of the native error types are also native errors:
 *
 * ```js
 * class MyError extends Error {}
 * console.log(util.types.isNativeError(new MyError()));  // true
 * ```
 *
 * A value being `instanceof` a native error class is not equivalent to `isNativeError()`returning `true` for that value. `isNativeError()` returns `true` for errors
 * which come from a different [realm](https://tc39.es/ecma262/#realm) while `instanceof Error` returns `false`for these errors:
 *
 * ```js
 * const vm = require('node:vm');
 * const context = vm.createContext({});
 * const myError = vm.runInContext('new Error()', context);
 * console.log(util.types.isNativeError(myError)); // true
 * console.log(myError instanceof Error); // false
 * ```
 *
 * Conversely, `isNativeError()` returns `false` for all objects which were not
 * returned by the constructor of a native error. That includes values
 * which are `instanceof` native errors:
 *
 * ```js
 * const myError = { __proto__: Error.prototype };
 * console.log(util.types.isNativeError(myError)); // false
 * console.log(myError instanceof Error); // true
 * ```
 * @since v10.0.0
 */
external fun isNativeError(`object`: Any?): Boolean /* object is Error */
