// Generated by Karakum - do not modify it manually!


package node.v8


sealed external interface PromiseHooks {
    /**
     * The `init` hook must be a plain function. Providing an async function will throw as it would produce an infinite microtask loop.
     * @since v17.1.0, v16.14.0
     * @param init The {@link Init | `init` callback} to call when a promise is created.
     * @return Call to stop the hook.
     */
    var onInit: (init: Init) -> Function<*>

    /**
     * The `settled` hook must be a plain function. Providing an async function will throw as it would produce an infinite microtask loop.
     * @since v17.1.0, v16.14.0
     * @param settled The {@link Settled | `settled` callback} to call when a promise is created.
     * @return Call to stop the hook.
     */
    var onSettled: (settled: Settled) -> Function<*>

    /**
     * The `before` hook must be a plain function. Providing an async function will throw as it would produce an infinite microtask loop.
     * @since v17.1.0, v16.14.0
     * @param before The {@link Before | `before` callback} to call before a promise continuation executes.
     * @return Call to stop the hook.
     */
    var onBefore: (before: Before) -> Function<*>

    /**
     * The `after` hook must be a plain function. Providing an async function will throw as it would produce an infinite microtask loop.
     * @since v17.1.0, v16.14.0
     * @param after The {@link After | `after` callback} to call after a promise continuation executes.
     * @return Call to stop the hook.
     */
    var onAfter: (after: After) -> Function<*>

    /**
     * Registers functions to be called for different lifetime events of each promise.
     * The callbacks `init()`/`before()`/`after()`/`settled()` are called for the respective events during a promise's lifetime.
     * All callbacks are optional. For example, if only promise creation needs to be tracked, then only the init callback needs to be passed.
     * The hook callbacks must be plain functions. Providing async functions will throw as it would produce an infinite microtask loop.
     * @since v17.1.0, v16.14.0
     * @param callbacks The {@link HookCallbacks | Hook Callbacks} to register
     * @return Used for disabling hooks
     */
    var createHook: (callbacks: HookCallbacks) -> Function<*>
}
