// Generated by Karakum - do not modify it manually!

@file:JsModule("node:v8")

package node.v8

import js.buffer.ArrayBuffer

/**
 * @since v8.0.0
 */

open external class Serializer {
    /**
     * Writes out a header, which includes the serialization format version.
     */
    fun writeHeader(): Unit

    /**
     * Serializes a JavaScript value and adds the serialized representation to the
     * internal buffer.
     *
     * This throws an error if `value` cannot be serialized.
     */
    fun writeValue(`val`: Any?): Boolean

    /**
     * Returns the stored internal buffer. This serializer should not be used once
     * the buffer is released. Calling this method results in undefined behavior
     * if a previous write has failed.
     */
    fun releaseBuffer(): node.buffer.Buffer

    /**
     * Marks an `ArrayBuffer` as having its contents transferred out of band.
     * Pass the corresponding `ArrayBuffer` in the deserializing context to `deserializer.transferArrayBuffer()`.
     * @param id A 32-bit unsigned integer.
     * @param arrayBuffer An `ArrayBuffer` instance.
     */
    fun transferArrayBuffer(id: Number, arrayBuffer: ArrayBuffer): Unit

    /**
     * Write a raw 32-bit unsigned integer.
     * For use inside of a custom `serializer._writeHostObject()`.
     */
    fun writeUint32(value: Number): Unit

    /**
     * Write a raw 64-bit unsigned integer, split into high and low 32-bit parts.
     * For use inside of a custom `serializer._writeHostObject()`.
     */
    fun writeUint64(hi: Number, lo: Number): Unit

    /**
     * Write a JS `number` value.
     * For use inside of a custom `serializer._writeHostObject()`.
     */
    fun writeDouble(value: Number): Unit

    /**
     * Write raw bytes into the serializer's internal buffer. The deserializer
     * will require a way to compute the length of the buffer.
     * For use inside of a custom `serializer._writeHostObject()`.
     */
    fun writeRawBytes(buffer: js.typedarrays.TypedArray<*, *>): Unit
}
