// Generated by Karakum - do not modify it manually!

@file:JsModule("node:v8")

package node.v8

import node.stream.Readable

/**
 * Generates a snapshot of the current V8 heap and returns a Readable
 * Stream that may be used to read the JSON serialized representation.
 * This JSON stream format is intended to be used with tools such as
 * Chrome DevTools. The JSON schema is undocumented and specific to the
 * V8 engine. Therefore, the schema may change from one version of V8 to the next.
 *
 * Creating a heap snapshot requires memory about twice the size of the heap at
 * the time the snapshot is created. This results in the risk of OOM killers
 * terminating the process.
 *
 * Generating a snapshot is a synchronous operation which blocks the event loop
 * for a duration depending on the heap size.
 *
 * ```js
 * // Print heap snapshot to the console
 * const v8 = require('node:v8');
 * const stream = v8.getHeapSnapshot();
 * stream.pipe(process.stdout);
 * ```
 * @since v11.13.0
 * @return A Readable containing the V8 heap snapshot.
 */
external fun getHeapSnapshot(): Readable
