// Generated by Karakum - do not modify it manually!

@file:JsModule("node:v8")

package node.v8


/**
 * Returns statistics about the V8 heap spaces, i.e. the segments which make up
 * the V8 heap. Neither the ordering of heap spaces, nor the availability of a
 * heap space can be guaranteed as the statistics are provided via the
 * V8[`GetHeapSpaceStatistics`](https://v8docs.nodesource.com/node-13.2/d5/dda/classv8_1_1_isolate.html#ac673576f24fdc7a33378f8f57e1d13a4) function and may change from one V8 version to the
 * next.
 *
 * The value returned is an array of objects containing the following properties:
 *
 * ```json
 * [
 *   {
 *     "space_name": "new_space",
 *     "space_size": 2063872,
 *     "space_used_size": 951112,
 *     "space_available_size": 80824,
 *     "physical_space_size": 2063872
 *   },
 *   {
 *     "space_name": "old_space",
 *     "space_size": 3090560,
 *     "space_used_size": 2493792,
 *     "space_available_size": 0,
 *     "physical_space_size": 3090560
 *   },
 *   {
 *     "space_name": "code_space",
 *     "space_size": 1260160,
 *     "space_used_size": 644256,
 *     "space_available_size": 960,
 *     "physical_space_size": 1260160
 *   },
 *   {
 *     "space_name": "map_space",
 *     "space_size": 1094160,
 *     "space_used_size": 201608,
 *     "space_available_size": 0,
 *     "physical_space_size": 1094160
 *   },
 *   {
 *     "space_name": "large_object_space",
 *     "space_size": 0,
 *     "space_used_size": 0,
 *     "space_available_size": 1490980608,
 *     "physical_space_size": 0
 *   }
 * ]
 * ```
 * @since v6.0.0
 */
external fun getHeapSpaceStatistics(): js.array.ReadonlyArray<HeapSpaceInfo>
