// Generated by Karakum - do not modify it manually!

@file:JsModule("node:wasi")

package node.wasi


/**
 * The `WASI` class provides the WASI system call API and additional convenience
 * methods for working with WASI-based applications. Each `WASI` instance
 * represents a distinct environment.
 * @since v13.3.0, v12.16.0
 */

external class WASI {
    constructor (options: WASIOptions = definedExternally)

    /**
     * Attempt to begin execution of `instance` as a WASI command by invoking its`_start()` export. If `instance` does not contain a `_start()` export, or if`instance` contains an `_initialize()`
     * export, then an exception is thrown.
     *
     * `start()` requires that `instance` exports a [`WebAssembly.Memory`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WebAssembly/Memory) named`memory`. If
     * `instance` does not have a `memory` export an exception is thrown.
     *
     * If `start()` is called more than once, an exception is thrown.
     * @since v13.3.0, v12.16.0
     */
    fun start(instance: Any): Double// TODO: avoid DOM dependency until WASM moved to own lib.

    /**
     * Attempt to initialize `instance` as a WASI reactor by invoking its`_initialize()` export, if it is present. If `instance` contains a `_start()`export, then an exception is thrown.
     *
     * `initialize()` requires that `instance` exports a [`WebAssembly.Memory`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WebAssembly/Memory) named`memory`.
     * If `instance` does not have a `memory` export an exception is thrown.
     *
     * If `initialize()` is called more than once, an exception is thrown.
     * @since v14.6.0, v12.19.0
     */
    fun initialize(instance: Any): Unit// TODO: avoid DOM dependency until WASM moved to own lib.

    /**
     * `wasiImport` is an object that implements the WASI system call API. This object
     * should be passed as the `wasi_snapshot_preview1` import during the instantiation
     * of a [`WebAssembly.Instance`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WebAssembly/Instance).
     * @since v13.3.0, v12.16.0
     */
    val wasiImport: node.Dict<Any?>// TODO: Narrow to DOM types

}
