// Generated by Karakum - do not modify it manually!


package node.wasi


sealed external interface WASIOptions {
    /**
     * An array of strings that the WebAssembly application will
     * see as command line arguments. The first argument is the virtual path to the
     * WASI command itself.
     */
    var args: js.array.ReadonlyArray<String>?

    /**
     * An object similar to `process.env` that the WebAssembly
     * application will see as its environment.
     */
    var env: Any?

    /**
     * This object represents the WebAssembly application's
     * sandbox directory structure. The string keys of `preopens` are treated as
     * directories within the sandbox. The corresponding values in `preopens` are
     * the real paths to those directories on the host machine.
     */
    var preopens: node.Dict<String>?

    /**
     * By default, when WASI applications call `__wasi_proc_exit()`
     *  `wasi.start()` will return with the exit code specified rather than terminatng the process.
     * Setting this option to `false` will cause the Node.js process to exit with
     * the specified exit code instead.
     * @default true
     */
    var returnOnExit: Boolean?

    /**
     * The file descriptor used as standard input in the WebAssembly application.
     * @default 0
     */
    var stdin: Double?

    /**
     * The file descriptor used as standard output in the WebAssembly application.
     * @default 1
     */
    var stdout: Double?

    /**
     * The file descriptor used as standard error in the WebAssembly application.
     * @default 2
     */
    var stderr: Double?

    /**
     * The version of WASI requested.
     * Currently the only supported versions are `'unstable'` and `'preview1'`.
     * @since v20.0.0
     */
    var version: String
}
