(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'node:fs/promises', 'kotlinx-coroutines-core', 'node:stream/promises', 'node:test', 'node:vm'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('node:fs/promises'), require('kotlinx-coroutines-core'), require('node:stream/promises'), require('node:test'), require('node:vm'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-node'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-node'.");
    }
    if (typeof this['node:fs/promises'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-node'. Its dependency 'node:fs/promises' was not found. Please, check whether 'node:fs/promises' is loaded prior to 'kotlin-node'.");
    }
    if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-node'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'kotlin-node'.");
    }
    if (typeof this['node:stream/promises'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-node'. Its dependency 'node:stream/promises' was not found. Please, check whether 'node:stream/promises' is loaded prior to 'kotlin-node'.");
    }
    if (typeof this['node:test'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-node'. Its dependency 'node:test' was not found. Please, check whether 'node:test' is loaded prior to 'kotlin-node'.");
    }
    if (typeof this['node:vm'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-node'. Its dependency 'node:vm' was not found. Please, check whether 'node:vm' is loaded prior to 'kotlin-node'.");
    }
    root['kotlin-node'] = factory(typeof this['kotlin-node'] === 'undefined' ? {} : this['kotlin-node'], kotlin, this['node:fs/promises'], this['kotlinx-coroutines-core'], this['node:stream/promises'], this['node:test'], this['node:vm']);
  }
}(this, function (_, Kotlin, $module$node_fs_promises, $module$kotlinx_coroutines_core, $module$node_stream_promises, $module$node_test, $module$node_vm) {
  'use strict';
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var accessAsync = $module$node_fs_promises.access;
  var await_0 = $module$kotlinx_coroutines_core.kotlinx.coroutines.await_t11jrl$;
  var appendFileAsync = $module$node_fs_promises.appendFile;
  var chmodAsync = $module$node_fs_promises.chmod;
  var chownAsync = $module$node_fs_promises.chown;
  var copyFileAsync = $module$node_fs_promises.copyFile;
  var cpAsync = $module$node_fs_promises.cp;
  var lchmodAsync = $module$node_fs_promises.lchmod;
  var lchownAsync = $module$node_fs_promises.lchown;
  var linkAsync = $module$node_fs_promises.link;
  var lstatAsync = $module$node_fs_promises.lstat;
  var lutimesAsync = $module$node_fs_promises.lutimes;
  var mkdirAsync = $module$node_fs_promises.mkdir;
  var mkdtempAsync = $module$node_fs_promises.mkdtemp;
  var openAsync = $module$node_fs_promises.open;
  var opendirAsync = $module$node_fs_promises.opendir;
  var readFileAsync = $module$node_fs_promises.readFile;
  var readlinkAsync = $module$node_fs_promises.readlink;
  var realpathAsync = $module$node_fs_promises.realpath;
  var renameAsync = $module$node_fs_promises.rename;
  var rmAsync = $module$node_fs_promises.rm;
  var rmdirAsync = $module$node_fs_promises.rmdir;
  var statAsync = $module$node_fs_promises.stat;
  var symlinkAsync = $module$node_fs_promises.symlink;
  var truncateAsync = $module$node_fs_promises.truncate;
  var unlinkAsync = $module$node_fs_promises.unlink;
  var utimesAsync = $module$node_fs_promises.utimes;
  var writeFileAsync = $module$node_fs_promises.writeFile;
  var finishedAsync = $module$node_stream_promises.finished;
  var testAsync = $module$node_test.test;
  var measureMemoryAsync = $module$node_vm.measureMemory;
  var EventType = defineInlineFunction('kotlin-node.node.events.EventType_61zpoe$', function (value) {
    return value;
  });
  var EventType_0 = defineInlineFunction('kotlin-node.node.events.EventType_p87pry$', function (value) {
    return value;
  });
  function Coroutine$access(path_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
  }
  Coroutine$access.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$access.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$access.prototype.constructor = Coroutine$access;
  Coroutine$access.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(accessAsync(this.local$path), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function access(path_0, continuation_0, suspended) {
    var instance = new Coroutine$access(path_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$access_0(path_0, mode_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$mode = mode_0;
  }
  Coroutine$access_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$access_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$access_0.prototype.constructor = Coroutine$access_0;
  Coroutine$access_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(accessAsync(this.local$path, this.local$mode), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function access_0(path_0, mode_0, continuation_0, suspended) {
    var instance = new Coroutine$access_0(path_0, mode_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$appendFile(path_0, data_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$data = data_0;
  }
  Coroutine$appendFile.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$appendFile.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$appendFile.prototype.constructor = Coroutine$appendFile;
  Coroutine$appendFile.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(appendFileAsync(this.local$path, this.local$data), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function appendFile(path_0, data_0, continuation_0, suspended) {
    var instance = new Coroutine$appendFile(path_0, data_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$appendFile_0(path_0, data_0, options_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$data = data_0;
    this.local$options = options_0;
  }
  Coroutine$appendFile_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$appendFile_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$appendFile_0.prototype.constructor = Coroutine$appendFile_0;
  Coroutine$appendFile_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(appendFileAsync(this.local$path, this.local$data, this.local$options), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function appendFile_0(path_0, data_0, options_0, continuation_0, suspended) {
    var instance = new Coroutine$appendFile_0(path_0, data_0, options_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$chmod(path_0, mode_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$mode = mode_0;
  }
  Coroutine$chmod.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$chmod.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$chmod.prototype.constructor = Coroutine$chmod;
  Coroutine$chmod.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(chmodAsync(this.local$path, this.local$mode), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function chmod(path_0, mode_0, continuation_0, suspended) {
    var instance = new Coroutine$chmod(path_0, mode_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$chown(path_0, uid_0, gid_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$uid = uid_0;
    this.local$gid = gid_0;
  }
  Coroutine$chown.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$chown.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$chown.prototype.constructor = Coroutine$chown;
  Coroutine$chown.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(chownAsync(this.local$path, this.local$uid, this.local$gid), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function chown(path_0, uid_0, gid_0, continuation_0, suspended) {
    var instance = new Coroutine$chown(path_0, uid_0, gid_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$copyFile(src_0, dest_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$src = src_0;
    this.local$dest = dest_0;
  }
  Coroutine$copyFile.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$copyFile.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$copyFile.prototype.constructor = Coroutine$copyFile;
  Coroutine$copyFile.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(copyFileAsync(this.local$src, this.local$dest), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function copyFile(src_0, dest_0, continuation_0, suspended) {
    var instance = new Coroutine$copyFile(src_0, dest_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$copyFile_0(src_0, dest_0, mode_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$src = src_0;
    this.local$dest = dest_0;
    this.local$mode = mode_0;
  }
  Coroutine$copyFile_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$copyFile_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$copyFile_0.prototype.constructor = Coroutine$copyFile_0;
  Coroutine$copyFile_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(copyFileAsync(this.local$src, this.local$dest, this.local$mode), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function copyFile_0(src_0, dest_0, mode_0, continuation_0, suspended) {
    var instance = new Coroutine$copyFile_0(src_0, dest_0, mode_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$cp(source_0, destination_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$source = source_0;
    this.local$destination = destination_0;
  }
  Coroutine$cp.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$cp.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$cp.prototype.constructor = Coroutine$cp;
  Coroutine$cp.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(cpAsync(this.local$source, this.local$destination), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function cp(source_0, destination_0, continuation_0, suspended) {
    var instance = new Coroutine$cp(source_0, destination_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$cp_0(source_0, destination_0, opts_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$source = source_0;
    this.local$destination = destination_0;
    this.local$opts = opts_0;
  }
  Coroutine$cp_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$cp_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$cp_0.prototype.constructor = Coroutine$cp_0;
  Coroutine$cp_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(cpAsync(this.local$source, this.local$destination, this.local$opts), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function cp_0(source_0, destination_0, opts_0, continuation_0, suspended) {
    var instance = new Coroutine$cp_0(source_0, destination_0, opts_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$lchmod(path_0, mode_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$mode = mode_0;
  }
  Coroutine$lchmod.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$lchmod.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$lchmod.prototype.constructor = Coroutine$lchmod;
  Coroutine$lchmod.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(lchmodAsync(this.local$path, this.local$mode), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function lchmod(path_0, mode_0, continuation_0, suspended) {
    var instance = new Coroutine$lchmod(path_0, mode_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$lchown(path_0, uid_0, gid_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$uid = uid_0;
    this.local$gid = gid_0;
  }
  Coroutine$lchown.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$lchown.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$lchown.prototype.constructor = Coroutine$lchown;
  Coroutine$lchown.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(lchownAsync(this.local$path, this.local$uid, this.local$gid), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function lchown(path_0, uid_0, gid_0, continuation_0, suspended) {
    var instance = new Coroutine$lchown(path_0, uid_0, gid_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$link(existingPath_0, newPath_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$existingPath = existingPath_0;
    this.local$newPath = newPath_0;
  }
  Coroutine$link.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$link.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$link.prototype.constructor = Coroutine$link;
  Coroutine$link.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(linkAsync(this.local$existingPath, this.local$newPath), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function link(existingPath_0, newPath_0, continuation_0, suspended) {
    var instance = new Coroutine$link(existingPath_0, newPath_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function lstat(path, continuation) {
    return await_0(lstatAsync(path), continuation);
  }
  function lstat_0(path, opts, continuation) {
    return await_0(lstatAsync(path, opts), continuation);
  }
  function Coroutine$lutimes(path_0, atime_0, mtime_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$atime = atime_0;
    this.local$mtime = mtime_0;
  }
  Coroutine$lutimes.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$lutimes.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$lutimes.prototype.constructor = Coroutine$lutimes;
  Coroutine$lutimes.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(lutimesAsync(this.local$path, this.local$atime, this.local$mtime), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function lutimes(path_0, atime_0, mtime_0, continuation_0, suspended) {
    var instance = new Coroutine$lutimes(path_0, atime_0, mtime_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function mkdir(path, continuation) {
    return await_0(mkdirAsync(path), continuation);
  }
  function mkdir_0(path, options, continuation) {
    return await_0(mkdirAsync(path, options), continuation);
  }
  function mkdtemp(prefix, continuation) {
    return await_0(mkdtempAsync(prefix), continuation);
  }
  function mkdtemp_0(prefix, options, continuation) {
    return await_0(mkdtempAsync(prefix, options), continuation);
  }
  function mkdtemp_1(prefix, options, continuation) {
    return await_0(mkdtempAsync(prefix, options), continuation);
  }
  function open(path, continuation) {
    return await_0(openAsync(path), continuation);
  }
  function open_0(path, flags, continuation) {
    return await_0(openAsync(path, flags), continuation);
  }
  function open_1(path, flags, mode, continuation) {
    return await_0(openAsync(path, flags, mode), continuation);
  }
  function opendir(path, continuation) {
    return await_0(opendirAsync(path), continuation);
  }
  function opendir_0(path, options, continuation) {
    return await_0(opendirAsync(path, options), continuation);
  }
  function readFile(path, continuation) {
    return await_0(readFileAsync(path), continuation);
  }
  function readFile_0(path, options, continuation) {
    return await_0(readFileAsync(path, options), continuation);
  }
  function readFile_1(path, options, continuation) {
    return await_0(readFileAsync(path, options), continuation);
  }
  function readlink(path, continuation) {
    return await_0(readlinkAsync(path), continuation);
  }
  function readlink_0(path, options, continuation) {
    return await_0(readlinkAsync(path, options), continuation);
  }
  function readlink_1(path, options, continuation) {
    return await_0(readlinkAsync(path, options), continuation);
  }
  function realpath(path, continuation) {
    return await_0(realpathAsync(path), continuation);
  }
  function realpath_0(path, options, continuation) {
    return await_0(realpathAsync(path, options), continuation);
  }
  function realpath_1(path, options, continuation) {
    return await_0(realpathAsync(path, options), continuation);
  }
  function Coroutine$rename(oldPath_0, newPath_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$oldPath = oldPath_0;
    this.local$newPath = newPath_0;
  }
  Coroutine$rename.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$rename.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$rename.prototype.constructor = Coroutine$rename;
  Coroutine$rename.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(renameAsync(this.local$oldPath, this.local$newPath), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function rename(oldPath_0, newPath_0, continuation_0, suspended) {
    var instance = new Coroutine$rename(oldPath_0, newPath_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$rm(path_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
  }
  Coroutine$rm.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$rm.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$rm.prototype.constructor = Coroutine$rm;
  Coroutine$rm.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(rmAsync(this.local$path), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function rm(path_0, continuation_0, suspended) {
    var instance = new Coroutine$rm(path_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$rm_0(path_0, options_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$options = options_0;
  }
  Coroutine$rm_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$rm_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$rm_0.prototype.constructor = Coroutine$rm_0;
  Coroutine$rm_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(rmAsync(this.local$path, this.local$options), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function rm_0(path_0, options_0, continuation_0, suspended) {
    var instance = new Coroutine$rm_0(path_0, options_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$rmdir(path_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
  }
  Coroutine$rmdir.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$rmdir.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$rmdir.prototype.constructor = Coroutine$rmdir;
  Coroutine$rmdir.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(rmdirAsync(this.local$path), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function rmdir(path_0, continuation_0, suspended) {
    var instance = new Coroutine$rmdir(path_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$rmdir_0(path_0, options_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$options = options_0;
  }
  Coroutine$rmdir_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$rmdir_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$rmdir_0.prototype.constructor = Coroutine$rmdir_0;
  Coroutine$rmdir_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(rmdirAsync(this.local$path, this.local$options), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function rmdir_0(path_0, options_0, continuation_0, suspended) {
    var instance = new Coroutine$rmdir_0(path_0, options_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function stat(path, continuation) {
    return await_0(statAsync(path), continuation);
  }
  function stat_0(path, opts, continuation) {
    return await_0(statAsync(path, opts), continuation);
  }
  function Coroutine$symlink(target_0, path_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$target = target_0;
    this.local$path = path_0;
  }
  Coroutine$symlink.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$symlink.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$symlink.prototype.constructor = Coroutine$symlink;
  Coroutine$symlink.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(symlinkAsync(this.local$target, this.local$path), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function symlink(target_0, path_0, continuation_0, suspended) {
    var instance = new Coroutine$symlink(target_0, path_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$symlink_0(target_0, path_0, type_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$target = target_0;
    this.local$path = path_0;
    this.local$type = type_0;
  }
  Coroutine$symlink_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$symlink_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$symlink_0.prototype.constructor = Coroutine$symlink_0;
  Coroutine$symlink_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(symlinkAsync(this.local$target, this.local$path, this.local$type), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function symlink_0(target_0, path_0, type_0, continuation_0, suspended) {
    var instance = new Coroutine$symlink_0(target_0, path_0, type_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$truncate(path_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
  }
  Coroutine$truncate.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$truncate.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$truncate.prototype.constructor = Coroutine$truncate;
  Coroutine$truncate.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(truncateAsync(this.local$path), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function truncate(path_0, continuation_0, suspended) {
    var instance = new Coroutine$truncate(path_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$truncate_0(path_0, len_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$len = len_0;
  }
  Coroutine$truncate_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$truncate_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$truncate_0.prototype.constructor = Coroutine$truncate_0;
  Coroutine$truncate_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(truncateAsync(this.local$path, this.local$len), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function truncate_0(path_0, len_0, continuation_0, suspended) {
    var instance = new Coroutine$truncate_0(path_0, len_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$unlink(path_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
  }
  Coroutine$unlink.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$unlink.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unlink.prototype.constructor = Coroutine$unlink;
  Coroutine$unlink.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(unlinkAsync(this.local$path), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unlink(path_0, continuation_0, suspended) {
    var instance = new Coroutine$unlink(path_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$utimes(path_0, atime_0, mtime_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$path = path_0;
    this.local$atime = atime_0;
    this.local$mtime = mtime_0;
  }
  Coroutine$utimes.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$utimes.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$utimes.prototype.constructor = Coroutine$utimes;
  Coroutine$utimes.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(utimesAsync(this.local$path, this.local$atime, this.local$mtime), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function utimes(path_0, atime_0, mtime_0, continuation_0, suspended) {
    var instance = new Coroutine$utimes(path_0, atime_0, mtime_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$writeFile(file_0, data_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$file = file_0;
    this.local$data = data_0;
  }
  Coroutine$writeFile.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$writeFile.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$writeFile.prototype.constructor = Coroutine$writeFile;
  Coroutine$writeFile.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(writeFileAsync(this.local$file, this.local$data), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function writeFile(file_0, data_0, continuation_0, suspended) {
    var instance = new Coroutine$writeFile(file_0, data_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$writeFile_0(file_0, data_0, options_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$file = file_0;
    this.local$data = data_0;
    this.local$options = options_0;
  }
  Coroutine$writeFile_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$writeFile_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$writeFile_0.prototype.constructor = Coroutine$writeFile_0;
  Coroutine$writeFile_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(writeFileAsync(this.local$file, this.local$data, this.local$options), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function writeFile_0(file_0, data_0, options_0, continuation_0, suspended) {
    var instance = new Coroutine$writeFile_0(file_0, data_0, options_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$finished(stream_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$stream = stream_0;
  }
  Coroutine$finished.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$finished.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$finished.prototype.constructor = Coroutine$finished;
  Coroutine$finished.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(finishedAsync(this.local$stream), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function finished(stream_0, continuation_0, suspended) {
    var instance = new Coroutine$finished(stream_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$finished_0(stream_0, options_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$stream = stream_0;
    this.local$options = options_0;
  }
  Coroutine$finished_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$finished_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$finished_0.prototype.constructor = Coroutine$finished_0;
  Coroutine$finished_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(finishedAsync(this.local$stream, this.local$options), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function finished_0(stream_0, options_0, continuation_0, suspended) {
    var instance = new Coroutine$finished_0(stream_0, options_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$test(continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$test.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$test.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$test.prototype.constructor = Coroutine$test;
  Coroutine$test.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(testAsync(), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function test(continuation_0, suspended) {
    var instance = new Coroutine$test(continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$test_0(name_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$name = name_0;
  }
  Coroutine$test_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$test_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$test_0.prototype.constructor = Coroutine$test_0;
  Coroutine$test_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(testAsync(this.local$name), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function test_0(name_0, continuation_0, suspended) {
    var instance = new Coroutine$test_0(name_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$test_1(name_0, fn_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$name = name_0;
    this.local$fn = fn_0;
  }
  Coroutine$test_1.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$test_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$test_1.prototype.constructor = Coroutine$test_1;
  Coroutine$test_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(testAsync(this.local$name, this.local$fn), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function test_1(name_0, fn_0, continuation_0, suspended) {
    var instance = new Coroutine$test_1(name_0, fn_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$test_2(name_0, options_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$name = name_0;
    this.local$options = options_0;
  }
  Coroutine$test_2.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$test_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$test_2.prototype.constructor = Coroutine$test_2;
  Coroutine$test_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(testAsync(this.local$name, this.local$options), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function test_2(name_0, options_0, continuation_0, suspended) {
    var instance = new Coroutine$test_2(name_0, options_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$test_3(name_0, options_0, fn_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$name = name_0;
    this.local$options = options_0;
    this.local$fn = fn_0;
  }
  Coroutine$test_3.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$test_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$test_3.prototype.constructor = Coroutine$test_3;
  Coroutine$test_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(testAsync(this.local$name, this.local$options, this.local$fn), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function test_3(name_0, options_0, fn_0, continuation_0, suspended) {
    var instance = new Coroutine$test_3(name_0, options_0, fn_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$test_4(options_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$options = options_0;
  }
  Coroutine$test_4.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$test_4.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$test_4.prototype.constructor = Coroutine$test_4;
  Coroutine$test_4.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(testAsync(this.local$options), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function test_4(options_0, continuation_0, suspended) {
    var instance = new Coroutine$test_4(options_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$test_5(options_0, fn_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$options = options_0;
    this.local$fn = fn_0;
  }
  Coroutine$test_5.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$test_5.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$test_5.prototype.constructor = Coroutine$test_5;
  Coroutine$test_5.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(testAsync(this.local$options, this.local$fn), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function test_5(options_0, fn_0, continuation_0, suspended) {
    var instance = new Coroutine$test_5(options_0, fn_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$test_6(fn_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$fn = fn_0;
  }
  Coroutine$test_6.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$test_6.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$test_6.prototype.constructor = Coroutine$test_6;
  Coroutine$test_6.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(testAsync(this.local$fn), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function test_6(fn_0, continuation_0, suspended) {
    var instance = new Coroutine$test_6(fn_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function measureMemory(continuation) {
    return await_0(measureMemoryAsync(), continuation);
  }
  function measureMemory_0(options, continuation) {
    return await_0(measureMemoryAsync(options), continuation);
  }
  var package$node = _.node || (_.node = {});
  var package$events = package$node.events || (package$node.events = {});
  package$events.EventType_61zpoe$ = EventType;
  package$events.EventType_p87pry$ = EventType_0;
  var package$fs = package$node.fs || (package$node.fs = {});
  package$fs.access_61zpoe$ = access;
  package$fs.access_nhrjpk$ = access_0;
  package$fs.appendFile_bm4g0d$ = appendFile;
  package$fs.appendFile_tpobxn$ = appendFile_0;
  package$fs.chmod_bm4lxs$ = chmod;
  package$fs.chown_2w64eq$ = chown;
  package$fs.copyFile_puj7f4$ = copyFile;
  package$fs.copyFile_8uggh2$ = copyFile_0;
  package$fs.cp_wn2jw4$ = cp;
  package$fs.cp_el2ypg$ = cp_0;
  package$fs.lchmod_bm4lxs$ = lchmod;
  package$fs.lchown_2w64eq$ = lchown;
  package$fs.link_puj7f4$ = link;
  package$fs.lstat_61zpoe$ = lstat;
  package$fs.lstat_3ad3s7$ = lstat_0;
  package$fs.lutimes_dp5zb2$ = lutimes;
  package$fs.mkdir_61zpoe$ = mkdir;
  package$fs.mkdir_4w9ihe$ = mkdir_0;
  package$fs.mkdtemp_61zpoe$ = mkdtemp;
  package$fs.mkdtemp_ldbtd0$ = mkdtemp_0;
  package$fs.mkdtemp_thkstn$ = mkdtemp_1;
  package$fs.open_61zpoe$ = open;
  package$fs.open_bm4g0d$ = open_0;
  package$fs.open_a59h7l$ = open_1;
  package$fs.opendir_61zpoe$ = opendir;
  package$fs.opendir_r4vy5e$ = opendir_0;
  package$fs.readFile_61zpoe$ = readFile;
  package$fs.readFile_4w9ihe$ = readFile_0;
  package$fs.readFile_fclfr7$ = readFile_1;
  package$fs.readlink_61zpoe$ = readlink;
  package$fs.readlink_ldbtd0$ = readlink_0;
  package$fs.readlink_thkstn$ = readlink_1;
  package$fs.realpath_61zpoe$ = realpath;
  package$fs.realpath_ldbtd0$ = realpath_0;
  package$fs.realpath_thkstn$ = realpath_1;
  package$fs.rename_puj7f4$ = rename;
  package$fs.rm_61zpoe$ = rm;
  package$fs.rm_4b7zs0$ = rm_0;
  package$fs.rmdir_61zpoe$ = rmdir;
  package$fs.rmdir_oyv67l$ = rmdir_0;
  package$fs.stat_61zpoe$ = stat;
  package$fs.stat_3ad3s7$ = stat_0;
  package$fs.symlink_puj7f4$ = symlink;
  package$fs.symlink_buzeal$ = symlink_0;
  package$fs.truncate_61zpoe$ = truncate;
  package$fs.truncate_nhrjpk$ = truncate_0;
  package$fs.unlink_61zpoe$ = unlink;
  package$fs.utimes_dp5zb2$ = utimes;
  package$fs.writeFile_bm4g0d$ = writeFile;
  package$fs.writeFile_tpobxn$ = writeFile_0;
  var package$stream = package$node.stream || (package$node.stream = {});
  package$stream.finished_za3rmp$ = finished;
  package$stream.finished_aupsrh$ = finished_0;
  var package$test = package$node.test || (package$node.test = {});
  package$test.test = test;
  package$test.test_61zpoe$ = test_0;
  package$test.test_kcmsdy$ = test_1;
  package$test.test_u7d5bi$ = test_2;
  package$test.test_3fe2je$ = test_3;
  package$test.test_ckypus$ = test_4;
  package$test.test_mqcje4$ = test_5;
  package$test.test_305m90$ = test_6;
  var package$vm = package$node.vm || (package$node.vm = {});
  package$vm.measureMemory = measureMemory;
  package$vm.measureMemory_kb8t62$ = measureMemory_0;
  Kotlin.defineModule('kotlin-node', _);
  return _;
}));
