(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlin-web', 'kotlin-react-core', 'react', 'kotlin-js'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlin-web'), require('kotlin-react-core'), require('react'), require('kotlin-js'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-react-use'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-react-use'.");
    }
    if (typeof this['kotlin-web'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-react-use'. Its dependency 'kotlin-web' was not found. Please, check whether 'kotlin-web' is loaded prior to 'kotlin-react-use'.");
    }
    if (typeof this['kotlin-react-core'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-react-use'. Its dependency 'kotlin-react-core' was not found. Please, check whether 'kotlin-react-core' is loaded prior to 'kotlin-react-use'.");
    }
    if (typeof react === 'undefined') {
      throw new Error("Error loading module 'kotlin-react-use'. Its dependency 'react' was not found. Please, check whether 'react' is loaded prior to 'kotlin-react-use'.");
    }
    if (typeof this['kotlin-js'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-react-use'. Its dependency 'kotlin-js' was not found. Please, check whether 'kotlin-js' is loaded prior to 'kotlin-react-use'.");
    }
    root['kotlin-react-use'] = factory(typeof this['kotlin-react-use'] === 'undefined' ? {} : this['kotlin-react-use'], kotlin, this['kotlin-web'], this['kotlin-react-core'], react, this['kotlin-js']);
  }
}(this, function (_, Kotlin, $module$kotlin_web, $module$kotlin_react_core, $module$react, $module$kotlin_js) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Unit = Kotlin.kotlin.Unit;
  var addEventHandler = $module$kotlin_web.web.events.addEventHandler_nh7mzw$;
  var useEffect = $module$kotlin_react_core.react.useEffect_74bcxr$;
  var useRef = $module$kotlin_react_core.$$importsForInline$$.react.useRef;
  var useRef_0 = $module$react.useRef;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var useEffect_0 = $module$kotlin_react_core.react.useEffect_yy86ve$;
  var useEffectOnce = $module$kotlin_react_core.react.useEffectOnce_yy86ve$;
  var useReducer = $module$react.useReducer;
  function useEventListener$lambda$lambda(closure$latestHandler) {
    return function (it) {
      closure$latestHandler.current(it);
      return Unit;
    };
  }
  function useEventListener$lambda(closure$target, closure$type, closure$options, closure$latestHandler) {
    return function ($receiver) {
      if (closure$target == null) {
        return;
      }
      var block = addEventHandler(closure$target, closure$type, closure$options, useEventListener$lambda$lambda(closure$latestHandler));
      $receiver.push(block);
      return Unit;
    };
  }
  function useEventListener(target, type, options, handler) {
    if (options === void 0)
      options = undefined;
    var latestHandler = useLatest(handler);
    useEffect([target, type], useEventListener$lambda(target, type, options, latestHandler));
  }
  function useIsFirstRender() {
    var isFirst = useRef(true);
    if (isFirst.current) {
      isFirst.current = false;
      return true;
    }
    return isFirst.current;
  }
  function useLatest(value) {
    var ref = useRef_0(value);
    ref.current = value;
    return ref;
  }
  function LatestInstance() {
  }
  LatestInstance.prototype.getValue_d6mtq7$ = defineInlineFunction('kotlin-react-use.react.use.LatestInstance.getValue_d6mtq7$', function (thisRef, property) {
    return this.current;
  });
  LatestInstance.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LatestInstance',
    interfaces: []
  };
  function usePrevious$lambda(closure$value, closure$ref) {
    return function ($receiver) {
      closure$ref.current = closure$value;
      return Unit;
    };
  }
  function usePrevious(value) {
    var ref = useRef_0();
    useEffect_0(usePrevious$lambda(value, ref));
    return ref.current;
  }
  function useRenderCount() {
    var count = useRef(0);
    count.current = count.current + 1 | 0;
    return count.current;
  }
  function useUnmountEffect$lambda(closure$latestCallback) {
    return function ($receiver) {
      var block = closure$latestCallback.current;
      $receiver.push(block);
      return Unit;
    };
  }
  function useUnmountEffect(callback) {
    var latestCallback = useLatest(callback);
    useEffectOnce(useUnmountEffect$lambda(latestCallback));
  }
  function updateReducer$lambda(num, f) {
    return (num + 1 | 0) % 1000000 | 0;
  }
  var updateReducer;
  function useUpdate() {
    var update = useReducer(updateReducer, 0)[1];
    return update;
  }
  function useUpdateEffect$lambda(closure$isFirstRender, closure$effect) {
    return function ($receiver) {
      if (!closure$isFirstRender) {
        closure$effect($receiver);
      }
      return Unit;
    };
  }
  function useUpdateEffect(dependencies, effect) {
    var isFirstRender = useIsFirstRender();
    useEffect(dependencies.slice(), useUpdateEffect$lambda(isFirstRender, effect));
  }
  $$importsForInline$$['kotlin-react-use'] = _;
  $$importsForInline$$['kotlin-react-core'] = $module$kotlin_react_core;
  var package$react = _.react || (_.react = {});
  var package$use = package$react.use || (package$react.use = {});
  package$use.useEventListener_afxmfq$ = useEventListener;
  package$use.useIsFirstRender = useIsFirstRender;
  package$use.useLatest_issdgt$ = useLatest;
  package$use.LatestInstance = LatestInstance;
  package$use.usePrevious_issdgt$ = usePrevious;
  package$use.useRenderCount = useRenderCount;
  package$use.useUnmountEffect_o14v8n$ = useUnmountEffect;
  $$importsForInline$$['kotlin-js'] = $module$kotlin_js;
  package$use.useUpdate = useUpdate;
  package$use.useUpdateEffect_74bcxr$ = useUpdateEffect;
  updateReducer = updateReducer$lambda;
  Kotlin.defineModule('kotlin-react-use', _);
  return _;
}));
