(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlin-js', 'kotlinx-coroutines-core'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlin-js'), require('kotlinx-coroutines-core'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-web'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-web'.");
    }
    if (typeof this['kotlin-js'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-web'. Its dependency 'kotlin-js' was not found. Please, check whether 'kotlin-js' is loaded prior to 'kotlin-web'.");
    }
    if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-web'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'kotlin-web'.");
    }
    root['kotlin-web'] = factory(typeof this['kotlin-web'] === 'undefined' ? {} : this['kotlin-web'], kotlin, this['kotlin-js'], this['kotlinx-coroutines-core']);
  }
}(this, function (_, Kotlin, $module$kotlin_js, $module$kotlinx_coroutines_core) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var Unit = Kotlin.kotlin.Unit;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_dbl4no$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var IllegalStateException = Kotlin.kotlin.IllegalStateException;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var Result = Kotlin.kotlin.Result;
  var createFailure = Kotlin.kotlin.createFailure_tcv7n7$;
  var intercepted = Kotlin.kotlin.coroutines.intrinsics.intercepted_f9mg25$;
  var CancellableContinuationImpl_init = $module$kotlinx_coroutines_core.kotlinx.coroutines.CancellableContinuationImpl;
  FetchException.prototype = Object.create(IllegalStateException.prototype);
  FetchException.prototype.constructor = FetchException;
  var EventType = defineInlineFunction('kotlin-web.web.events.EventType_1k4oxk$', function (value) {
    return value;
  });
  var get_MESSAGE = defineInlineFunction('kotlin-web.web.events.get_MESSAGE_2qn269$', function ($receiver) {
    return 'message';
  });
  var get_MESSAGE_ERROR = defineInlineFunction('kotlin-web.web.events.get_MESSAGE_ERROR_2qn269$', function ($receiver) {
    return 'messageerror';
  });
  function AbortController_0() {
    return new AbortController();
  }
  function AbortSignal_0() {
    return new AbortSignal();
  }
  var get_ACTIVE = defineInlineFunction('kotlin-web.web.events.get_ACTIVE_lhep6m$', function ($receiver) {
    var $receiver_0 = {};
    $receiver_0.passive = false;
    return $receiver_0;
  });
  var get_CAPTURE = defineInlineFunction('kotlin-web.web.events.get_CAPTURE_lhep6m$', function ($receiver) {
    var $receiver_0 = {};
    $receiver_0.capture = true;
    return $receiver_0;
  });
  function addEventHandler($receiver, type, handler) {
    return addEventHandler_0($receiver, type, undefined, handler);
  }
  function addEventHandler$lambda(closure$type, closure$handler, closure$options, this$addEventHandler) {
    return function () {
      this$addEventHandler.removeEventListener(closure$type, closure$handler, closure$options);
      return Unit;
    };
  }
  function addEventHandler_0($receiver, type, options, handler) {
    $receiver.addEventListener(type, handler, options);
    return addEventHandler$lambda(type, handler, options, $receiver);
  }
  function FetchException(cause) {
    IllegalStateException_init(cause, this);
    this.name = 'FetchException';
  }
  FetchException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FetchException',
    interfaces: [IllegalStateException]
  };
  function suspendCancellableCoroutine$lambda(closure$block) {
    return function (uCont) {
      var cancellable = new CancellableContinuationImpl_init(intercepted(uCont), 1);
      cancellable.initCancellability();
      closure$block(cancellable);
      return cancellable.getResult();
    };
  }
  function fetch$lambda$lambda(closure$controller) {
    return function (it) {
      closure$controller.abort();
      return Unit;
    };
  }
  function fetch$lambda$lambda_0(closure$continuation) {
    return function (it) {
      closure$continuation.resumeWith_tl1gpc$(new Result(it));
      return Unit;
    };
  }
  function fetch$lambda$lambda_1(closure$continuation) {
    return function (it) {
      var $receiver = closure$continuation;
      var exception = new FetchException(it);
      $receiver.resumeWith_tl1gpc$(new Result(createFailure(exception)));
      return Unit;
    };
  }
  function fetch$lambda(closure$input) {
    return function (continuation) {
      var controller = AbortController_0();
      continuation.invokeOnCancellation_f05bi3$(fetch$lambda$lambda(controller));
      var tmp$ = closure$input;
      var $receiver = {};
      $receiver.signal = controller.signal;
      var request = new Request(tmp$, $receiver);
      fetch(request).then(fetch$lambda$lambda_0(continuation)).catch(fetch$lambda$lambda_1(continuation));
      return Unit;
    };
  }
  function Coroutine$fetch(input_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$input = input_0;
  }
  Coroutine$fetch.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$fetch.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$fetch.prototype.constructor = Coroutine$fetch;
  Coroutine$fetch.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = suspendCancellableCoroutine$lambda(fetch$lambda(this.local$input))(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.result_0;
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function fetch_0(input_0, continuation_0, suspended) {
    var instance = new Coroutine$fetch(input_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function fetch_1(input, init, continuation) {
    return fetch_0(new Request(input, init), continuation);
  }
  function fetch_2(input, continuation) {
    return fetch_0(new Request(input), continuation);
  }
  function fetch_3(input, init, continuation) {
    return fetch_0(new Request(input, init), continuation);
  }
  function fetch_4(input, continuation) {
    return fetch_0(new Request(input), continuation);
  }
  function fetch_5(input, init, continuation) {
    return fetch_0(new Request(input, init), continuation);
  }
  var package$web = _.web || (_.web = {});
  var package$events = package$web.events || (package$web.events = {});
  package$events.EventType_1k4oxk$ = EventType;
  $$importsForInline$$['kotlin-web'] = _;
  package$events.get_MESSAGE_2qn269$ = get_MESSAGE;
  package$events.get_MESSAGE_ERROR_2qn269$ = get_MESSAGE_ERROR;
  package$web.AbortController = AbortController_0;
  package$web.AbortSignal = AbortSignal_0;
  $$importsForInline$$['kotlin-js'] = $module$kotlin_js;
  package$events.get_ACTIVE_lhep6m$ = get_ACTIVE;
  package$events.get_CAPTURE_lhep6m$ = get_CAPTURE;
  package$events.addEventHandler_oqhw5q$ = addEventHandler;
  package$events.addEventHandler_i1dq36$ = addEventHandler_0;
  var package$http = package$web.http || (package$web.http = {});
  package$http.FetchException = FetchException;
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  package$http.fetch_6bzgwz$ = fetch_0;
  package$http.fetch_8hdcn8$ = fetch_1;
  package$http.fetch_61zpoe$ = fetch_2;
  package$http.fetch_svs0u9$ = fetch_3;
  package$http.fetch_1qmkp6$ = fetch_4;
  package$http.fetch_wno9fb$ = fetch_5;
  Kotlin.defineModule('kotlin-web', _);
  return _;
}));
