/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sbtidea.download;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionComparatorUtil {
    private static final Pattern WORDS_SPLITTER = Pattern.compile("\\d+|[^\\d]+");
    private static final VersionTokenType[] VALUES = VersionTokenType.values();
    public static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return VersionComparatorUtil.compare(string, string2);
        }
    };
    private static final Function<String, Integer> DEFAULT_TOKEN_PRIORITY_PROVIDER = string -> VersionTokenType.lookup(string).getPriority();

    private VersionComparatorUtil() {
    }

    public static String max(String string, String string2) {
        return VersionComparatorUtil.compare(string, string2) > 0 ? string : string2;
    }

    public static String min(String string, String string2) {
        return VersionComparatorUtil.compare(string, string2) < 0 ? string : string2;
    }

    private static List<String> splitVersionString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "()._-;:/, +~");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            Matcher matcher = WORDS_SPLITTER.matcher(stringTokenizer.nextToken());
            while (matcher.find()) {
                arrayList.add(matcher.group());
            }
        }
        return arrayList;
    }

    public static int compare(String string, String string2) {
        return VersionComparatorUtil.compare(string, string2, DEFAULT_TOKEN_PRIORITY_PROVIDER);
    }

    public static int compare(String string, String string2, Function<? super String, Integer> function) {
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toLowerCase(Locale.ENGLISH);
        List<String> list = VersionComparatorUtil.splitVersionString(string);
        List<String> list2 = VersionComparatorUtil.splitVersionString(string2);
        VersionComparatorUtil.padWithNulls(list, list2);
        for (int i = 0; i < list.size(); ++i) {
            String string3 = list.get(i);
            String string4 = list2.get(i);
            VersionTokenType versionTokenType = VersionTokenType.lookup(string3);
            int n = VersionComparatorUtil.comparePriorities(string3, string4, function);
            if (n != 0) {
                return n;
            }
            if (versionTokenType == VersionTokenType._WORD) {
                n = string3.compareTo(string4);
            } else if (versionTokenType == VersionTokenType._DIGITS) {
                n = VersionComparatorUtil.compareNumbers(string3, string4);
            }
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public static int comparePriorities(String string, String string2, Function<? super String, Integer> function) {
        int n = function.apply(string);
        int n2 = function.apply(string2);
        return Integer.signum(n - n2);
    }

    private static int compareNumbers(String string, String string2) {
        int n;
        while (string.length() > 0 && string2.length() > 0 && string.charAt(0) == '0' && string2.charAt(0) == '0') {
            string = string.substring(1);
            string2 = string2.substring(1);
        }
        if (string.length() > 0 && string.charAt(0) == '0') {
            return -1;
        }
        if (string2.length() > 0 && string2.charAt(0) == '0') {
            return 1;
        }
        int n2 = string.length();
        if (n2 > (n = string2.length())) {
            return 1;
        }
        if (n > n2) {
            return -1;
        }
        return string.compareTo(string2);
    }

    private static void padWithNulls(Collection<String> collection, Collection<String> collection2) {
        if (collection.size() != collection2.size()) {
            while (collection.size() < collection2.size()) {
                collection.add(null);
            }
            while (collection.size() > collection2.size()) {
                collection2.add(null);
            }
        }
    }

    public static enum VersionTokenType {
        SNAP(10),
        SNAPSHOT(10),
        M(20),
        EAP(25),
        PRE(25),
        PREVIEW(25),
        ALPHA(30),
        A(30),
        BETA(40),
        BETTA(40),
        B(40),
        RC(50),
        _WS(60),
        SP(70),
        REL(80),
        RELEASE(80),
        R(80),
        FINAL(80),
        _WORD(90),
        _DIGITS(100),
        BUNDLED(666);

        private final int myPriority;

        private VersionTokenType(int n2) {
            this.myPriority = n2;
        }

        public static VersionTokenType lookup(String string) {
            if (string == null) {
                return _WS;
            }
            if ((string = string.trim()).length() == 0) {
                return _WS;
            }
            for (VersionTokenType versionTokenType : VALUES) {
                String string2 = versionTokenType.name();
                if (string2.charAt(0) == '_' || !string2.equalsIgnoreCase(string)) continue;
                return versionTokenType;
            }
            if (string.matches("0+")) {
                return _WS;
            }
            if (string.matches("\\d+")) {
                return _DIGITS;
            }
            return _WORD;
        }

        public int getPriority() {
            return this.myPriority;
        }
    }
}

