/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sbtidea.download.idea;

import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.sbtidea.IntelliJPlatform;
import org.jetbrains.sbtidea.IntelliJPlatform$MPS$;
import org.jetbrains.sbtidea.PluginLogger$;
import org.jetbrains.sbtidea.download.FileDownloader;
import org.jetbrains.sbtidea.download.FileDownloader$;
import org.jetbrains.sbtidea.download.IdeaUpdater$;
import org.jetbrains.sbtidea.download.NioUtils;
import org.jetbrains.sbtidea.download.api.InstallContext;
import org.jetbrains.sbtidea.download.api.Installer;
import org.jetbrains.sbtidea.download.idea.IdeaDist;
import org.jetbrains.sbtidea.download.package;
import org.jetbrains.sbtidea.package$;
import sbt.IO$;
import sbt.jetbrains.ideaPlugin.apiAdapter;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u001b\t\t\u0012\nZ3b\t&\u001cH/\u00138ti\u0006dG.\u001a:\u000b\u0005\r!\u0011\u0001B5eK\u0006T!!\u0002\u0004\u0002\u0011\u0011|wO\u001c7pC\u0012T!a\u0002\u0005\u0002\u000fM\u0014G/\u001b3fC*\u0011\u0011BC\u0001\nU\u0016$(M]1j]NT\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rE\u0002\u00161ii\u0011A\u0006\u0006\u0003/\u0011\t1!\u00199j\u0013\tIbCA\u0005J]N$\u0018\r\u001c7feB\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\t\u0013\u0012,\u0017\rR5ti\"Aq\u0004\u0001B\u0001B\u0003%\u0001%A\u0005ck&dG-\u00138g_B\u0011\u0011e\f\b\u0003E5r!a\t\u0017\u000f\u0005\u0011ZcBA\u0013+\u001d\t1\u0013&D\u0001(\u0015\tAC\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u00059\"\u0011a\u00029bG.\fw-Z\u0005\u0003aE\u0012\u0011BQ;jY\u0012LeNZ8\u000b\u00059\"\u0001\"B\u001a\u0001\t\u0003!\u0014A\u0002\u001fj]&$h\b\u0006\u00026mA\u00111\u0004\u0001\u0005\u0006?I\u0002\r\u0001\t\u0005\u0006q\u0001!\t%O\u0001\fSNLen\u001d;bY2,G\r\u0006\u0002;\u0007R\u00111H\u0010\t\u0003\u001fqJ!!\u0010\t\u0003\u000f\t{w\u000e\\3b]\")qh\u000ea\u0002\u0001\u0006\u00191\r\u001e=\u0011\u0005U\t\u0015B\u0001\"\u0017\u00059Ien\u001d;bY2\u001cuN\u001c;fqRDQ\u0001R\u001cA\u0002i\t1!\u0019:u\u0011\u00151\u0005\u0001\"\u0011H\u0003I!wn\u001e8m_\u0006$\u0017I\u001c3J]N$\u0018\r\u001c7\u0015\u0005!kECA%M!\ty!*\u0003\u0002L!\t!QK\\5u\u0011\u0015yT\tq\u0001A\u0011\u0015!U\t1\u0001\u001b\u0011\u0015y\u0005\u0001\"\u0003Q\u0003\u0019!X\u000e\u001d#jeR\u0011\u0011k\u0017\t\u0003%fk\u0011a\u0015\u0006\u0003)V\u000bAAZ5mK*\u0011akV\u0001\u0004]&|'\"\u0001-\u0002\t)\fg/Y\u0005\u00035N\u0013A\u0001U1uQ\")qH\u0014a\u0002\u0001\"1Q\f\u0001C\u0001\u0005y\u000b\u0001\u0003Z8x]2|\u0017\rZ!si&4\u0017m\u0019;\u0015\u0005}\u000bGCA)a\u0011\u0015yD\fq\u0001A\u0011\u0015!E\f1\u0001\u001b\u0011\u0019\u0019\u0007\u0001\"\u0001\u0003I\u0006Y\u0011N\\:uC2dG)[:u)\t)w\r\u0006\u0002RM\")qH\u0019a\u0002\u0001\")\u0001N\u0019a\u0001#\u0006A\u0011M\u001d;jM\u0006\u001cG\u000fC\u0003k\u0001\u0011%1.A\bgSb\f5mY3tgJKw\r\u001b;t)\tIE\u000eC\u0003nS\u0002\u0007\u0011+A\u0004jI\u0016\fG)\u001b:")
public class IdeaDistInstaller
implements Installer<IdeaDist> {
    public final package.BuildInfo org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$buildInfo;

    @Override
    public boolean isInstalled(IdeaDist art, InstallContext ctx) {
        return IdeaUpdater$.MODULE$.isDumbIdea() || ctx.baseDirectory().toFile().exists() && Predef$.MODULE$.refArrayOps((Object[])ctx.baseDirectory().toFile().listFiles()).nonEmpty();
    }

    @Override
    public void downloadAndInstall(IdeaDist art, InstallContext ctx) {
        FileDownloader qual$1 = FileDownloader$.MODULE$.apply(ctx.baseDirectory().getParent());
        URL x$1 = art.dlUrl();
        boolean x$2 = qual$1.download$default$2();
        this.installDist(qual$1.download(x$1, x$2), ctx);
    }

    public Path org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$tmpDir(InstallContext ctx) {
        return ctx.baseDirectory().getParent().resolve(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "-TMP"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$buildInfo.edition().name(), this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$buildInfo.buildNumber()})));
    }

    public Path downloadArtifact(IdeaDist art, InstallContext ctx) {
        FileDownloader qual$2 = FileDownloader$.MODULE$.apply(ctx.baseDirectory().getParent());
        URL x$3 = art.dlUrl();
        boolean x$4 = qual$2.download$default$2();
        return qual$2.download(x$3, x$4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path installDist(Path artifact, InstallContext ctx) {
        PluginLogger$.MODULE$.info((Function0)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdeaDistInstaller $outer;
            private final InstallContext ctx$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Extracting ", " dist to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$buildInfo.edition().name(), this.$outer.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$tmpDir(this.ctx$1)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.ctx$1 = ctx$1;
            }
        });
        ctx.baseDirectory().toFile().getParentFile().mkdirs();
        NioUtils.delete(ctx.baseDirectory());
        NioUtils.delete(this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$tmpDir(ctx));
        Files.createDirectories(this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$tmpDir(ctx), new FileAttribute[0]);
        if (((Object)artifact.getFileName()).toString().endsWith(".zip")) {
            scala.collection.immutable.Set res = IO$.MODULE$.unzip(artifact.toFile(), this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$tmpDir(ctx).toFile(), IO$.MODULE$.unzip$default$3(), IO$.MODULE$.unzip$default$4());
            if (res.isEmpty()) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to unzip ", " - bad archive"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{artifact.toFile()})));
            }
        } else {
            if (!((Object)artifact.getFileName()).toString().endsWith(".tar.gz")) throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected dist archive format(not zip or gzip): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{artifact})));
            if (scala.sys.process.package$.MODULE$.stringToProcess(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tar xfz ", " -C ", " --strip 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{artifact, this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$tmpDir(ctx)}))).$bang() != 0) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to install ", " dist: tar command failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$buildInfo.edition().name()})));
            }
        }
        if (apiAdapter.PathExt$.MODULE$.exists$extension(package$.MODULE$.pathToPathExt(ctx.baseDirectory()))) {
            PluginLogger$.MODULE$.warn((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "IJ install directory already exists, removing...";
                }
            });
            NioUtils.delete(ctx.baseDirectory());
        }
        IntelliJPlatform intelliJPlatform = this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$buildInfo.edition();
        IntelliJPlatform$MPS$ intelliJPlatform$MPS$ = IntelliJPlatform$MPS$.MODULE$;
        IntelliJPlatform intelliJPlatform2 = intelliJPlatform;
        if (!(intelliJPlatform$MPS$ != null ? !intelliJPlatform$MPS$.equals(intelliJPlatform2) : intelliJPlatform2 != null) && Files.list(this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$tmpDir(ctx)).count() == 1L) {
            PluginLogger$.MODULE$.info((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "MPS detected: applying install dir quirks";
                }
            });
            Path actualDir = (Path)Files.list(this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$tmpDir(ctx)).iterator().next();
            Files.move(actualDir, ctx.baseDirectory(), new CopyOption[0]);
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$tmpDir(ctx)));
        } else {
            Path path = Files.move(this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$tmpDir(ctx), ctx.baseDirectory(), new CopyOption[0]);
        }
        this.fixAccessRights(ctx.baseDirectory());
        NioUtils.delete(artifact);
        PluginLogger$.MODULE$.info((Function0)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdeaDistInstaller $outer;
            private final InstallContext ctx$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Installed ", "(", ") to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$buildInfo.edition().name(), this.$outer.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$buildInfo, this.ctx$1.baseDirectory()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.ctx$1 = ctx$1;
            }
        });
        return ctx.baseDirectory();
    }

    private void fixAccessRights(Path ideaDir) {
        if (!System.getProperty("os.name").startsWith("Windows")) {
            Set<PosixFilePermission> execPerms = PosixFilePermissions.fromString("rwxrwxr-x");
            Path binDir = ideaDir.resolve("bin");
            try {
                Files.walk(binDir, new FileVisitOption[0]).forEach(new Consumer<Path>(this, execPerms){
                    private final Set execPerms$1;

                    public void accept(Path t) {
                        Files.setPosixFilePermissions(t, this.execPerms$1);
                    }
                    {
                        this.execPerms$1 = execPerms$1;
                    }
                });
            }
            catch (Exception exception) {
                PluginLogger$.MODULE$.warn((Function0)new Serializable(this, binDir, exception){
                    public static final long serialVersionUID = 0L;
                    private final Path binDir$1;
                    private final Exception e$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to fix access rights for ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.binDir$1, this.e$1.getMessage()}));
                    }
                    {
                        this.binDir$1 = binDir$1;
                        this.e$1 = e$1;
                    }
                });
            }
        }
    }

    public IdeaDistInstaller(package.BuildInfo buildInfo) {
        this.org$jetbrains$sbtidea$download$idea$IdeaDistInstaller$$buildInfo = buildInfo;
    }
}

