/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sbtidea.download.jbr;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.jetbrains.sbtidea.JbrInfo;
import org.jetbrains.sbtidea.PluginLogger$;
import org.jetbrains.sbtidea.download.FileDownloader;
import org.jetbrains.sbtidea.download.FileDownloader$;
import org.jetbrains.sbtidea.download.NioUtils;
import org.jetbrains.sbtidea.download.api.InstallContext;
import org.jetbrains.sbtidea.download.api.Installer;
import org.jetbrains.sbtidea.download.jbr.JbrArtifact;
import org.jetbrains.sbtidea.download.jbr.JbrInstaller$;
import org.jetbrains.sbtidea.package$;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.rauschig.jarchivelib.CompressionType;
import sbt.jetbrains.ideaPlugin.apiAdapter;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001b\ta!J\u0019:J]N$\u0018\r\u001c7fe*\u00111\u0001B\u0001\u0004U\n\u0014(BA\u0003\u0007\u0003!!wn\u001e8m_\u0006$'BA\u0004\t\u0003\u001d\u0019(\r^5eK\u0006T!!\u0003\u0006\u0002\u0013),GO\u0019:bS:\u001c(\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0004+aQR\"\u0001\f\u000b\u0005]!\u0011aA1qS&\u0011\u0011D\u0006\u0002\n\u0013:\u001cH/\u00197mKJ\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u0017)\u0013'/\u0011:uS\u001a\f7\r\u001e\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"a\u0007\u0001\t\u000b\r\u0002A\u0011\t\u0013\u0002\u0017%\u001c\u0018J\\:uC2dW\r\u001a\u000b\u0003K9\"\"AJ\u0015\u0011\u0005=9\u0013B\u0001\u0015\u0011\u0005\u001d\u0011un\u001c7fC:DQA\u000b\u0012A\u0004-\n1a\u0019;y!\t)B&\u0003\u0002.-\tq\u0011J\\:uC2d7i\u001c8uKb$\b\"B\u0018#\u0001\u0004Q\u0012aA1si\")\u0011\u0007\u0001C!e\u0005\u0011Bm\\<oY>\fG-\u00118e\u0013:\u001cH/\u00197m)\t\u0019\u0004\b\u0006\u00025oA\u0011q\"N\u0005\u0003mA\u0011A!\u00168ji\")!\u0006\ra\u0002W!)q\u0006\ra\u00015!)!\b\u0001C\u0005w\u0005I\u0011n]*b[\u0016T%M\u001d\u000b\u0003yy\"\"AJ\u001f\t\u000b)J\u00049A\u0016\t\u000b=J\u0004\u0019\u0001\u000e\t\r\u0001\u0003A\u0011\u0001\u0002B\u0003\u001dIgn\u001d;bY2$\"A\u0011#\u0015\u0005Q\u001a\u0005\"\u0002\u0016@\u0001\bY\u0003\"B#@\u0001\u00041\u0015\u0001\u00023jgR\u0004\"a\u0012(\u000e\u0003!S!!\u0013&\u0002\t\u0019LG.\u001a\u0006\u0003\u00172\u000b1A\\5p\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014%\u0003\tA\u000bG\u000f[\u0004\u0006#\nA\tAU\u0001\r\u0015\n\u0014\u0018J\\:uC2dWM\u001d\t\u00037M3Q!\u0001\u0002\t\u0002Q\u001b\"a\u0015\b\t\u000b}\u0019F\u0011\u0001,\u0015\u0003ICq\u0001W*C\u0002\u0013\u0005\u0011,\u0001\u0007K\u0005J{F)\u0013*`\u001d\u0006kU)F\u0001[!\tYf,D\u0001]\u0015\tiF*\u0001\u0003mC:<\u0017BA0]\u0005\u0019\u0019FO]5oO\"1\u0011m\u0015Q\u0001\ni\u000bQB\u0013\"S?\u0012K%k\u0018(B\u001b\u0016\u0003\u0003")
public class JbrInstaller
implements Installer<JbrArtifact> {
    public static String JBR_DIR_NAME() {
        return JbrInstaller$.MODULE$.JBR_DIR_NAME();
    }

    @Override
    public boolean isInstalled(JbrArtifact art, InstallContext ctx) {
        return apiAdapter.PathExt$.MODULE$.exists$extension(package$.MODULE$.pathToPathExt(apiAdapter.PathExt$.MODULE$.$div$extension(package$.MODULE$.pathToPathExt(ctx.baseDirectory()), JbrInstaller$.MODULE$.JBR_DIR_NAME()))) && this.isSameJbr(art, ctx);
    }

    @Override
    public void downloadAndInstall(JbrArtifact art, InstallContext ctx) {
        FileDownloader qual$1 = FileDownloader$.MODULE$.apply(ctx.downloadDirectory());
        URL x$1 = art.dlUrl();
        boolean x$2 = qual$1.download$default$2();
        Path file = qual$1.download(x$1, x$2);
        this.install(file, ctx);
    }

    private boolean isSameJbr(JbrArtifact art, InstallContext ctx) {
        boolean bl;
        Path releaseFile = apiAdapter.PathExt$.MODULE$.$div$extension(package$.MODULE$.pathToPathExt(apiAdapter.PathExt$.MODULE$.$div$extension(package$.MODULE$.pathToPathExt(ctx.baseDirectory()), JbrInstaller$.MODULE$.JBR_DIR_NAME())), "release");
        Properties props = new Properties();
        try {
            JbrInfo jbrInfo = art.caller().jbrInfo();
            org.jetbrains.sbtidea.packaging.artifact.package$.MODULE$.using((Function0)new Serializable(this, releaseFile){
                public static final long serialVersionUID = 0L;
                private final Path releaseFile$1;

                public final InputStream apply() {
                    return apiAdapter.PathExt$.MODULE$.inputStream$extension(package$.MODULE$.pathToPathExt(this.releaseFile$1));
                }
                {
                    this.releaseFile$1 = releaseFile$1;
                }
            }, (Function1)new Serializable(this, props){
                public static final long serialVersionUID = 0L;
                private final Properties props$1;

                public final void apply(InputStream x$1) {
                    this.props$1.load(x$1);
                }
                {
                    this.props$1 = props$1;
                }
            });
            bl = package$.MODULE$.Any2Option((Object)props.getProperty("IMPLEMENTOR_VERSION")).lift2Option().exists((Function1)new Serializable(this, jbrInfo){
                public static final long serialVersionUID = 0L;
                public final JbrInfo jbrInfo$1;

                /*
                 * WARNING - void declaration
                 */
                public final boolean apply(String value) {
                    void var2_2;
                    boolean sameJbr;
                    boolean bl = sameJbr = value.contains(this.jbrInfo$1.version().major().replace('_', '.')) && value.contains(this.jbrInfo$1.version().minor()) && value.contains(this.jbrInfo$1.kind().value().replace("jbr_", ""));
                    if (!sameJbr) {
                        PluginLogger$.MODULE$.info((Function0)new Serializable(this, value){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$isSameJbr$3 $outer;
                            private final String value$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New JBR is different from installed: ", " != ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.jbrInfo$1, this.value$1}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.value$1 = value$1;
                            }
                        });
                    }
                    return (boolean)var2_2;
                }
                {
                    this.jbrInfo$1 = jbrInfo$1;
                }
            });
        }
        catch (Exception exception) {
            PluginLogger$.MODULE$.warn((Function0)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to check locally installed JBR version(assuming true): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.getMessage()}));
                }
                {
                    this.e$1 = e$1;
                }
            });
            bl = true;
        }
        return bl;
    }

    public void install(Path dist, InstallContext ctx) {
        Archiver archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.TAR, (CompressionType)CompressionType.GZIP);
        Path tmpDir = Files.createTempDirectory(ctx.baseDirectory(), "jbr-extract", new FileAttribute[0]);
        PluginLogger$.MODULE$.info((Function0)new Serializable(this, tmpDir){
            public static final long serialVersionUID = 0L;
            private final Path tmpDir$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"extracting jbr to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmpDir$1}));
            }
            {
                this.tmpDir$1 = tmpDir$1;
            }
        });
        archiver.extract(dist.toFile(), tmpDir.toFile());
        Path installPath = apiAdapter.PathExt$.MODULE$.$div$extension(package$.MODULE$.pathToPathExt(ctx.baseDirectory()), JbrInstaller$.MODULE$.JBR_DIR_NAME());
        Seq children = apiAdapter.PathExt$.MODULE$.list$extension(package$.MODULE$.pathToPathExt(tmpDir));
        if (children.size() == 1) {
            NioUtils.delete(installPath);
            Files.move((Path)children.head(), installPath, new CopyOption[0]);
            NioUtils.delete(tmpDir);
            PluginLogger$.MODULE$.info((Function0)new Serializable(this, installPath){
                public static final long serialVersionUID = 0L;
                private final Path installPath$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"installed JBR into ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.installPath$1}));
                }
                {
                    this.installPath$1 = installPath$1;
                }
            });
        } else {
            PluginLogger$.MODULE$.error((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected JBR archive structure, expected single directory"})).s((Seq)Nil$.MODULE$);
                }
            });
        }
    }
}

