/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sbtidea.download.jbr;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Properties;
import org.jetbrains.sbtidea.AutoJbr;
import org.jetbrains.sbtidea.JBR;
import org.jetbrains.sbtidea.JbrInfo;
import org.jetbrains.sbtidea.JbrKind;
import org.jetbrains.sbtidea.JbrKind$;
import org.jetbrains.sbtidea.JbrPlatform;
import org.jetbrains.sbtidea.JbrVersion;
import org.jetbrains.sbtidea.JbrVersion$;
import org.jetbrains.sbtidea.Keys$;
import org.jetbrains.sbtidea.NoJbr$;
import org.jetbrains.sbtidea.download.api.Resolver;
import org.jetbrains.sbtidea.download.api.UnresolvedArtifact;
import org.jetbrains.sbtidea.download.jbr.JbrArtifact;
import org.jetbrains.sbtidea.download.jbr.JbrDependency;
import org.jetbrains.sbtidea.download.jbr.JbrResolver$;
import org.jetbrains.sbtidea.download.package;
import org.jetbrains.sbtidea.package$;
import sbt.jetbrains.ideaPlugin.apiAdapter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u00015\u00111B\u00132s%\u0016\u001cx\u000e\u001c<fe*\u00111\u0001B\u0001\u0004U\n\u0014(BA\u0003\u0007\u0003!!wn\u001e8m_\u0006$'BA\u0004\t\u0003\u001d\u0019(\r^5eK\u0006T!!\u0003\u0006\u0002\u0013),GO\u0019:bS:\u001c(\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0004+aQR\"\u0001\f\u000b\u0005]!\u0011aA1qS&\u0011\u0011D\u0006\u0002\t%\u0016\u001cx\u000e\u001c<feB\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u000e\u0015\n\u0014H)\u001a9f]\u0012,gnY=\t\u000b}\u0001A\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\u0005\t\u0003CA\u000e\u0001\u0011\u0015\u0019\u0003\u0001\"\u0011%\u0003\u001d\u0011Xm]8mm\u0016$\"!\n\u001b\u0011\u0007\u0019r\u0013G\u0004\u0002(Y9\u0011\u0001fK\u0007\u0002S)\u0011!\u0006D\u0001\u0007yI|w\u000e\u001e \n\u0003EI!!\f\t\u0002\u000fA\f7m[1hK&\u0011q\u0006\r\u0002\u0004'\u0016\f(BA\u0017\u0011!\tY\"'\u0003\u00024\u0005\tY!J\u0019:BeRLg-Y2u\u0011\u0015)$\u00051\u0001\u001b\u0003\r!W\r\u001d\u0005\u0006o\u0001!I\u0001O\u0001\u000eEVLG\u000e\u001a&ce\u0012cWK\u001d7\u0015\te\nu\t\u0014\t\u0003u}j\u0011a\u000f\u0006\u0003yu\n1A\\3u\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\u0007U\u0013F\nC\u0003Cm\u0001\u00071)\u0001\u0006kEJ4VM]:j_:\u0004\"\u0001R#\u000e\u0003\u0019I!A\u0012\u0004\u0003\u0015)\u0013'OV3sg&|g\u000eC\u0003Im\u0001\u0007\u0011*A\u0004kEJ\\\u0015N\u001c3\u0011\u0005\u0011S\u0015BA&\u0007\u0005\u001dQ%M]&j]\u0012DQ!\u0014\u001cA\u00029\u000b1B\u001b2s!2\fGOZ8s[B\u0011AiT\u0005\u0003!\u001a\u00111B\u00132s!2\fGOZ8s[\")!\u000b\u0001C\u0005'\u0006iq-\u001a;KEJ4VM]:j_:$\"\u0001V,\u0011\u0007=)6)\u0003\u0002W!\t1q\n\u001d;j_:DQ!N)A\u0002iAQ!\u0017\u0001\u0005\ni\u000b!bZ3u\u0015\n\u00148*\u001b8e)\rI5\f\u0019\u0005\u00069b\u0003\r!X\u0001\bU\n\u0014\u0018J\u001c4p!\t!e,\u0003\u0002`\r\t9!J\u0019:J]\u001a|\u0007\"B1Y\u0001\u0004\u0019\u0015a\u0002<feNLwN\u001c\u0005\u0006G\u0002!I\u0001Z\u0001\u000eI\u00164\u0017-\u001e7u\u0015\n\u0014hi\u001c:\u0015\u0005%+\u0007\"B1c\u0001\u0004\u0019\u0005BB4\u0001\t\u0003\u0011\u0001.\u0001\ffqR\u0014\u0018m\u0019;WKJ\u001c\u0018n\u001c8Ge>l\u0017\nZ3b)\tI\u0017\u000fE\u0002\u0010+*\u0004\"a\u001b8\u000f\u0005=a\u0017BA7\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000e\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055\u0004\u0002\"\u0002:g\u0001\u0004\u0019\u0018aE5eK\u0006Len\u001d;bY2\fG/[8o\t&\u0014\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\u00111\u0017\u000e\\3\u000b\u0005al\u0014a\u00018j_&\u0011!0\u001e\u0002\u0005!\u0006$\bnB\u0003}\u0005!\u0005Q0A\u0006KEJ\u0014Vm]8mm\u0016\u0014\bCA\u000e\u007f\r\u0015\t!\u0001#\u0001\u0000'\tqh\u0002\u0003\u0004 }\u0012\u0005\u00111\u0001\u000b\u0002{\"I\u0011q\u0001@C\u0002\u0013\u0005\u0011\u0011B\u0001\t\u0005\u0006\u001bViX+S\u0019V\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u001f\u0002\t1\fgnZ\u0005\u0004_\u0006=\u0001\u0002CA\f}\u0002\u0006I!a\u0003\u0002\u0013\t\u000b5+R0V%2\u0003\u0003")
public class JbrResolver
implements Resolver<JbrDependency> {
    public static String BASE_URL() {
        return JbrResolver$.MODULE$.BASE_URL();
    }

    @Override
    public Seq<JbrArtifact> resolve(JbrDependency dep) {
        Seq seq;
        JbrInfo jbrInfo = dep.jbrInfo();
        NoJbr$ noJbr$ = NoJbr$.MODULE$;
        JbrInfo jbrInfo2 = jbrInfo;
        if (!(noJbr$ != null ? !noJbr$.equals(jbrInfo2) : jbrInfo2 != null)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            Option maybeArtifact = this.getJbrVersion(dep).map((Function1)new Serializable(this, dep, jbrInfo){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JbrResolver $outer;
                private final JbrDependency dep$1;
                private final JbrInfo x1$1;

                public final JbrArtifact apply(JbrVersion version) {
                    JBR resolvedJbrInfo;
                    JbrKind kind = this.$outer.org$jetbrains$sbtidea$download$jbr$JbrResolver$$getJbrKind(this.x1$1, version);
                    JbrPlatform platform2 = this.x1$1.platform();
                    URL url = this.$outer.org$jetbrains$sbtidea$download$jbr$JbrResolver$$buildJbrDlUrl(version, kind, platform2);
                    JBR x$3 = resolvedJbrInfo = Keys$.MODULE$.JBR().apply(version, kind, platform2);
                    Path x$4 = this.dep$1.copy$default$1();
                    package.BuildInfo x$5 = this.dep$1.copy$default$2();
                    Seq<UnresolvedArtifact> x$6 = this.dep$1.copy$default$4();
                    return new JbrArtifact(this.dep$1.copy(x$4, x$5, x$3, x$6), url);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.dep$1 = dep$1;
                    this.x1$1 = x1$1;
                }
            });
            seq = Option$.MODULE$.option2Iterable(maybeArtifact).toSeq();
        }
        return seq;
    }

    public URL org$jetbrains$sbtidea$download$jbr$JbrResolver$$buildJbrDlUrl(JbrVersion jbrVersion, JbrKind jbrKind, JbrPlatform jbrPlatform) {
        String kind = jbrKind.value();
        JbrPlatform jbrPlatform2 = jbrPlatform;
        if (jbrPlatform2 != null) {
            Tuple2 tuple2;
            String platform2 = jbrPlatform2.os();
            String arch = jbrPlatform2.arch();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)platform2, (Object)arch);
            String platform3 = (String)tuple22._1();
            String arch2 = (String)tuple22._2();
            JbrVersion jbrVersion2 = jbrVersion;
            if (jbrVersion2 != null) {
                Tuple2 tuple23;
                String major = jbrVersion2.major();
                String minor = jbrVersion2.minor();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)major, (Object)minor);
                String major2 = (String)tuple24._1();
                String minor2 = (String)tuple24._2();
                return new URL(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "-", "-", "-", "-b", ".tar.gz"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JbrResolver$.MODULE$.BASE_URL(), kind, major2, platform3, arch2, minor2})));
            }
            throw new MatchError((Object)jbrVersion2);
        }
        throw new MatchError((Object)jbrPlatform2);
    }

    private Option<JbrVersion> getJbrVersion(JbrDependency dep) {
        Some some;
        JbrInfo jbrInfo = dep.jbrInfo();
        if (jbrInfo instanceof AutoJbr) {
            AutoJbr autoJbr = (AutoJbr)jbrInfo;
            Option<JbrVersion> explicitVersion = autoJbr.explicitVersion();
            some = explicitVersion.orElse((Function0)new Serializable(this, dep){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JbrResolver $outer;
                private final JbrDependency dep$2;

                public final Option<JbrVersion> apply() {
                    return this.$outer.extractVersionFromIdea(this.dep$2.ideaRoot()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JbrVersion apply(String fullVersion) {
                            return JbrVersion$.MODULE$.parse(fullVersion);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.dep$2 = dep$2;
                }
            });
        } else {
            some = new Some((Object)jbrInfo.version());
        }
        return some;
    }

    public JbrKind org$jetbrains$sbtidea$download$jbr$JbrResolver$$getJbrKind(JbrInfo jbrInfo, JbrVersion version) {
        JbrKind jbrKind;
        JbrInfo jbrInfo2 = jbrInfo;
        if (jbrInfo2 instanceof AutoJbr) {
            AutoJbr autoJbr = (AutoJbr)jbrInfo2;
            Option<JbrKind> explicitKind = autoJbr.explicitKind();
            jbrKind = (JbrKind)explicitKind.getOrElse((Function0)new Serializable(this, version){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JbrResolver $outer;
                private final JbrVersion version$1;

                public final JbrKind apply() {
                    return this.$outer.org$jetbrains$sbtidea$download$jbr$JbrResolver$$defaultJbrFor(this.version$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.version$1 = version$1;
                }
            });
        } else {
            jbrKind = jbrInfo2.kind();
        }
        return jbrKind;
    }

    public JbrKind org$jetbrains$sbtidea$download$jbr$JbrResolver$$defaultJbrFor(JbrVersion version) {
        return version.major().startsWith("11") ? JbrKind$.MODULE$.JBR_DCEVM() : JbrKind$.MODULE$.JBR_JCEF();
    }

    public Option<String> extractVersionFromIdea(Path ideaInstallationDir) {
        Path dependenciesFile = apiAdapter.PathExt$.MODULE$.$div$extension(package$.MODULE$.pathToPathExt(ideaInstallationDir), "dependencies.txt");
        Properties props = new Properties();
        org.jetbrains.sbtidea.packaging.artifact.package$.MODULE$.using((Function0)new Serializable(this, dependenciesFile){
            public static final long serialVersionUID = 0L;
            private final Path dependenciesFile$1;

            public final InputStream apply() {
                return apiAdapter.PathExt$.MODULE$.inputStream$extension(package$.MODULE$.pathToPathExt(this.dependenciesFile$1));
            }
            {
                this.dependenciesFile$1 = dependenciesFile$1;
            }
        }, (Function1)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final void apply(InputStream x$1) {
                this.props$1.load(x$1);
            }
            {
                this.props$1 = props$1;
            }
        });
        Option value1 = Option$.MODULE$.apply((Object)props.getProperty("runtimeBuild"));
        Option value2 = value1.orElse((Function0)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Option<String> apply() {
                return Option$.MODULE$.apply((Object)this.props$1.getProperty("jdkBuild"));
            }
            {
                this.props$1 = props$1;
            }
        });
        return value2;
    }
}

