/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sbtidea.download.plugin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import org.jetbrains.sbtidea.download.PluginXmlDetector;
import org.jetbrains.sbtidea.download.plugin.LocalPluginRegistry;
import org.jetbrains.sbtidea.download.plugin.LocalPluginRegistry$;
import org.jetbrains.sbtidea.download.plugin.PluginDescriptor;
import org.jetbrains.sbtidea.download.plugin.PluginDescriptor$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.Map;
import scala.collection.mutable.WeakHashMap;
import scala.package$;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class LocalPluginRegistry$ {
    public static final LocalPluginRegistry$ MODULE$;
    private final Map<Path, LocalPluginRegistry> instances;

    static {
        new LocalPluginRegistry$();
    }

    public <K, V> HashMap<K, V> HashMapExt(HashMap<K, V> hm) {
        return hm;
    }

    private Map<Path, LocalPluginRegistry> instances() {
        return this.instances;
    }

    public Either<String, Seq<PluginDescriptor>> extractDescriptorFromResources(Seq<Path> resourceDirs) {
        Tuple2 tuple2 = (Tuple2)((Stream)((Stream)resourceDirs.toStream().map((Function1)new anonfun.2(), Stream$.MODULE$.canBuildFrom())).filter((Function1)new anonfun.3()).map((Function1)new anonfun.4(), Stream$.MODULE$.canBuildFrom())).foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)Seq$.MODULE$.empty()), (Object)Seq$.MODULE$.empty()), (Function2)new anonfun.5());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq errors = (Seq)tuple2._1();
            Seq descriptors = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)errors, (Object)descriptors);
            Seq errors2 = (Seq)tuple23._1();
            Seq descriptors2 = (Seq)tuple23._2();
            return errors2.nonEmpty() ? package$.MODULE$.Left().apply((Object)errors2.mkString("\n")) : package$.MODULE$.Right().apply((Object)descriptors2);
        }
        throw new MatchError((Object)tuple2);
    }

    public Either<String, Seq<String>> extractPluginIdsFromResources(Seq<Path> resourceDirs) {
        return this.extractDescriptorFromResources(resourceDirs).right().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Seq<PluginDescriptor> descriptors) {
                return (Seq)((SeqLike)descriptors.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(PluginDescriptor x$6) {
                        return x$6.id();
                    }
                }, Seq$.MODULE$.canBuildFrom())).distinct();
            }
        });
    }

    public Either<String, String> extractInstalledPluginDescriptor(Path pluginRoot) {
        block5: {
            try {
                if (Files.isDirectory(pluginRoot, new LinkOption[0])) {
                    Path lib = pluginRoot.resolve("lib");
                    if (lib.toFile().exists()) {
                        PluginXmlDetector detector = new PluginXmlDetector();
                        Optional<Path> result = Files.list(lib).filter(detector).findFirst();
                        if (result.isPresent()) {
                            return package$.MODULE$.Right().apply((Object)detector.result());
                        }
                        break block5;
                    }
                    return package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Plugin root ", " has no lib directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pluginRoot})));
                }
                PluginXmlDetector detector = new PluginXmlDetector();
                if (!detector.test(pluginRoot)) break block5;
                return package$.MODULE$.Right().apply((Object)detector.result());
            }
            catch (Exception exception) {
                return package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error during detecting plugin.xml: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception})));
            }
        }
        return package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find plugin.xml in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pluginRoot})));
    }

    public Either<String, PluginDescriptor> extractPluginMetaData(Path pluginRoot) {
        Either<String, String> descriptor = this.extractInstalledPluginDescriptor(pluginRoot);
        return (Either)descriptor.fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Left<String, Nothing$> apply(String err) {
                return package$.MODULE$.Left().apply((Object)err);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Right<Nothing$, PluginDescriptor> apply(String data) {
                return package$.MODULE$.Right().apply((Object)PluginDescriptor$.MODULE$.load(data));
            }
        });
    }

    public LocalPluginRegistry instanceFor(Path ideaRoot) {
        return (LocalPluginRegistry)this.instances().apply((Object)ideaRoot);
    }

    private LocalPluginRegistry$() {
        MODULE$ = this;
        this.instances = new WeakHashMap().withDefault((Function1)new anonfun.1());
    }
}

