/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sbtidea.download.plugin;

import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.sbtidea.IntellijPlugin;
import org.jetbrains.sbtidea.PluginLogger$;
import org.jetbrains.sbtidea.download.FileDownloader;
import org.jetbrains.sbtidea.download.FileDownloader$;
import org.jetbrains.sbtidea.download.IdeaUpdater$;
import org.jetbrains.sbtidea.download.NioUtils;
import org.jetbrains.sbtidea.download.PluginXmlDetector;
import org.jetbrains.sbtidea.download.VersionComparatorUtil;
import org.jetbrains.sbtidea.download.api.InstallContext;
import org.jetbrains.sbtidea.download.api.Installer;
import org.jetbrains.sbtidea.download.package;
import org.jetbrains.sbtidea.download.package$;
import org.jetbrains.sbtidea.download.plugin.LocalPluginRegistry$;
import org.jetbrains.sbtidea.download.plugin.LocalPluginRegistryApi;
import org.jetbrains.sbtidea.download.plugin.PluginDescriptor;
import org.jetbrains.sbtidea.download.plugin.PluginDescriptor$;
import org.jetbrains.sbtidea.download.plugin.PluginRepoApi;
import org.jetbrains.sbtidea.download.plugin.RemotePluginArtifact;
import org.jetbrains.sbtidea.download.plugin.RepoPluginInstaller$;
import sbt.IO$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u00015\u00111CU3q_BcWoZ5o\u0013:\u001cH/\u00197mKJT!a\u0001\u0003\u0002\rAdWoZ5o\u0015\t)a!\u0001\u0005e_^tGn\\1e\u0015\t9\u0001\"A\u0004tERLG-Z1\u000b\u0005%Q\u0011!\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u00042!\u0006\r\u001b\u001b\u00051\"BA\f\u0005\u0003\r\t\u0007/[\u0005\u00033Y\u0011\u0011\"\u00138ti\u0006dG.\u001a:\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!\u0001\u0006*f[>$X\r\u00157vO&t\u0017I\u001d;jM\u0006\u001cG\u000f\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0003%\u0011W/\u001b7e\u0013:4w\u000e\u0005\u0002\"_9\u0011!%\f\b\u0003G1r!\u0001J\u0016\u000f\u0005\u0015RcB\u0001\u0014*\u001b\u00059#B\u0001\u0015\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!A\f\u0003\u0002\u000fA\f7m[1hK&\u0011\u0001'\r\u0002\n\u0005VLG\u000eZ%oM>T!A\f\u0003\t\u0011M\u0002!\u0011!Q\u0001\fQ\nAA]3q_B\u00111$N\u0005\u0003m\t\u0011Q\u0002\u00157vO&t'+\u001a9p\u0003BL\u0007\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b1B\u001d\u0002\u001b1|7-\u00197SK\u001eL7\u000f\u001e:z!\tY\"(\u0003\u0002<\u0005\t1Bj\\2bYBcWoZ5o%\u0016<\u0017n\u001d;ss\u0006\u0003\u0018\u000eC\u0003>\u0001\u0011\u0005a(\u0001\u0004=S:LGO\u0010\u000b\u0003\u007f\r#2\u0001Q!C!\tY\u0002\u0001C\u00034y\u0001\u000fA\u0007C\u00039y\u0001\u000f\u0011\bC\u0003 y\u0001\u0007\u0001\u0005C\u0003F\u0001\u0011\u0005c)A\u0006jg&s7\u000f^1mY\u0016$GCA$Q)\tA5\n\u0005\u0002\u0010\u0013&\u0011!\n\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015aE\tq\u0001N\u0003\r\u0019G\u000f\u001f\t\u0003+9K!a\u0014\f\u0003\u001d%s7\u000f^1mY\u000e{g\u000e^3yi\")\u0011\u000b\u0012a\u00015\u0005\u0019\u0011M\u001d;\t\u000bM\u0003A\u0011\t+\u0002%\u0011|wO\u001c7pC\u0012\fe\u000eZ%ogR\fG\u000e\u001c\u000b\u0003+j#\"AV-\u0011\u0005=9\u0016B\u0001-\u0011\u0005\u0011)f.\u001b;\t\u000b1\u0013\u00069A'\t\u000bE\u0013\u0006\u0019\u0001\u000e\t\rq\u0003A\u0011\u0001\u0002^\u0003EIgn\u001d;bY2LE-Z1QYV<\u0017N\u001c\u000b\u0004=*|GCA0j!\t\u0001w-D\u0001b\u0015\t\u00117-\u0001\u0003gS2,'B\u00013f\u0003\rq\u0017n\u001c\u0006\u0002M\u0006!!.\u0019<b\u0013\tA\u0017M\u0001\u0003QCRD\u0007\"\u0002'\\\u0001\bi\u0005\"B\u0002\\\u0001\u0004Y\u0007C\u00017n\u001b\u00051\u0011B\u00018\u0007\u00059Ie\u000e^3mY&T\u0007\u000b\\;hS:DQ\u0001].A\u0002}\u000b\u0001\"\u0019:uS\u001a\f7\r\u001e\u0005\u0007e\u0002!\tAA:\u00023%\u001c\u0018J\\:uC2dW\r\u001a)mk\u001eLg.\u00169U_\u0012\u000bG/\u001a\u000b\u0003iZ$\"\u0001S;\t\u000b1\u000b\b9A'\t\u000b\r\t\b\u0019A6\t\ra\u0004A\u0011\u0001\u0002z\u0003Y9W\r^'pe\u0016,\u0006\u000fV8ECR,g+\u001a:tS>tG#\u0002>\u0002\n\u0005M\u0001cA\b|{&\u0011A\u0010\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007y\f\u0019A\u0004\u0002\u0010\u007f&\u0019\u0011\u0011\u0001\t\u0002\rA\u0013X\rZ3g\u0013\u0011\t)!a\u0002\u0003\rM#(/\u001b8h\u0015\r\t\t\u0001\u0005\u0005\b\u0003\u00179\b\u0019AA\u0007\u0003)!Wm]2sSB$xN\u001d\t\u00047\u0005=\u0011bAA\t\u0005\t\u0001\u0002\u000b\\;hS:$Um]2sSB$xN\u001d\u0005\u0007\u0003+9\b\u0019\u0001>\u0002\u000f\rD\u0017M\u001c8fY\"A\u0011\u0011\u0004\u0001\u0005\u0002\t\tY\"\u0001\u000ejgBcWoZ5o\u0007>l\u0007/\u0019;jE2,w+\u001b;i\u0013\u0012,\u0017\r\u0006\u0003\u0002\u001e\u0005\u0005Bc\u0001%\u0002 !1A*a\u0006A\u00045C\u0001\"a\t\u0002\u0018\u0001\u0007\u0011QB\u0001\t[\u0016$\u0018\rZ1uC\"A\u0011q\u0005\u0001\u0005\u0002\t\tI#A\u0006jgBcWoZ5o\u0015\u0006\u0014Hc\u0001%\u0002,!1\u0001/!\nA\u0002}Cq!a\f\u0001\t\u0013\t\t$\u0001\u0006qYV<\u0017N\\:ESJ$2aXA\u001a\u0011\u0019a\u0015Q\u0006a\u0002\u001b\u001e9\u0011q\u0007\u0002\t\u0002\u0005e\u0012a\u0005*fa>\u0004F.^4j]&s7\u000f^1mY\u0016\u0014\bcA\u000e\u0002<\u00191\u0011A\u0001E\u0001\u0003{\u00192!a\u000f\u000f\u0011\u001di\u00141\bC\u0001\u0003\u0003\"\"!!\u000f\t\u0011\u0005\u0015\u00131\bC\u0001\u0003\u000f\n1cY8na\u0006\u0014X-\u00133fCZ+'o]5p]N$b!!\u0013\u0002P\u0005M\u0003cA\b\u0002L%\u0019\u0011Q\n\t\u0003\u0007%sG\u000fC\u0004\u0002R\u0005\r\u0003\u0019A?\u0002\u0003\u0005Dq!!\u0016\u0002D\u0001\u0007Q0A\u0001c\u0001")
public class RepoPluginInstaller
implements Installer<RemotePluginArtifact> {
    public final package.BuildInfo org$jetbrains$sbtidea$download$plugin$RepoPluginInstaller$$buildInfo;
    private final PluginRepoApi repo;
    private final LocalPluginRegistryApi localRegistry;

    public static int compareIdeaVersions(String string, String string2) {
        return RepoPluginInstaller$.MODULE$.compareIdeaVersions(string, string2);
    }

    @Override
    public boolean isInstalled(RemotePluginArtifact art, InstallContext ctx) {
        return !IdeaUpdater$.MODULE$.isDumbPlugins() && this.localRegistry.isPluginInstalled(art.caller().plugin()) && this.isInstalledPluginUpToDate(art.caller().plugin(), ctx);
    }

    @Override
    public void downloadAndInstall(RemotePluginArtifact art, InstallContext ctx) {
        FileDownloader qual$1 = FileDownloader$.MODULE$.apply(ctx.baseDirectory().getParent());
        URL x$2 = art.dlUrl();
        boolean x$3 = qual$1.download$default$2();
        Path dist = qual$1.download(x$2, x$3);
        this.installIdeaPlugin(art.caller().plugin(), dist, ctx);
    }

    public Path installIdeaPlugin(IntellijPlugin plugin, Path artifact, InstallContext ctx) {
        Path path;
        if (this.isPluginJar(artifact)) {
            Path targetJar = this.pluginsDir(ctx).resolve(artifact.getFileName());
            Files.move(artifact, targetJar, new CopyOption[0]);
            PluginLogger$.MODULE$.info((Function0)new Serializable(this, plugin, targetJar){
                public static final long serialVersionUID = 0L;
                private final IntellijPlugin plugin$2;
                private final Path targetJar$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Installed plugin '", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.plugin$2, this.targetJar$1}));
                }
                {
                    this.plugin$2 = plugin$2;
                    this.targetJar$1 = targetJar$1;
                }
            });
            path = targetJar;
        } else {
            Path extractDir = Files.createTempDirectory(ctx.baseDirectory(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "-plugin"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$jetbrains$sbtidea$download$plugin$RepoPluginInstaller$$buildInfo.edition().name(), this.org$jetbrains$sbtidea$download$plugin$RepoPluginInstaller$$buildInfo.buildNumber()})), new FileAttribute[0]);
            PluginLogger$.MODULE$.info((Function0)new Serializable(this, plugin, extractDir){
                public static final long serialVersionUID = 0L;
                private final IntellijPlugin plugin$2;
                private final Path extractDir$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Extracting plugin '", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.plugin$2, this.extractDir$1}));
                }
                {
                    this.plugin$2 = plugin$2;
                    this.extractDir$1 = extractDir$1;
                }
            });
            IO$.MODULE$.unzip(artifact.toFile(), extractDir.toFile(), IO$.MODULE$.unzip$default$3(), IO$.MODULE$.unzip$default$4());
            Predef$.MODULE$.assert(Files.list(extractDir).count() == 1L, (Function0)new Serializable(this, extractDir){
                public static final long serialVersionUID = 0L;
                private final Path extractDir$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected only single plugin folder in extracted archive, got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.extractDir$1.toFile().list()).mkString()}));
                }
                {
                    this.extractDir$1 = extractDir$1;
                }
            });
            Path tmpPluginDir = Files.list(extractDir).findFirst().get();
            Path installDir = this.pluginsDir(ctx).resolve(tmpPluginDir.getFileName());
            NioUtils.delete(installDir);
            Files.move(tmpPluginDir, installDir, new CopyOption[0]);
            NioUtils.delete(tmpPluginDir.getParent());
            PluginLogger$.MODULE$.info((Function0)new Serializable(this, plugin, installDir){
                public static final long serialVersionUID = 0L;
                private final IntellijPlugin plugin$2;
                private final Path installDir$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Installed plugin '", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.plugin$2, this.installDir$1}));
                }
                {
                    this.plugin$2 = plugin$2;
                    this.installDir$1 = installDir$1;
                }
            });
            path = installDir;
        }
        Path installedPluginRoot = path;
        this.localRegistry.markPluginInstalled(plugin, installedPluginRoot);
        return installedPluginRoot;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean isInstalledPluginUpToDate(IntellijPlugin plugin, InstallContext ctx) {
        block11: {
            Path pluginRoot = this.localRegistry.getInstalledPluginRoot(plugin);
            Either<String, String> descriptor = LocalPluginRegistry$.MODULE$.extractInstalledPluginDescriptor(pluginRoot);
            Either<String, String> either = descriptor;
            if (either instanceof Left) {
                Left left = (Left)either;
                String error = (String)left.a();
                PluginLogger$.MODULE$.warn((Function0)new Serializable(this, plugin, error){
                    public static final long serialVersionUID = 0L;
                    private final IntellijPlugin plugin$1;
                    private final String error$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to extract descriptor from plugin ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.plugin$1, this.error$1}));
                    }
                    {
                        this.plugin$1 = plugin$1;
                        this.error$1 = error$1;
                    }
                });
                PluginLogger$.MODULE$.info((Function0)new Serializable(this, plugin){
                    public static final long serialVersionUID = 0L;
                    private final IntellijPlugin plugin$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Up-to-date check failed, assuming plugin ", " is out of date"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.plugin$1}));
                    }
                    {
                        this.plugin$1 = plugin$1;
                    }
                });
                return false;
            }
            if (!(either instanceof Right)) {
                throw new MatchError(either);
            }
            Right right = (Right)either;
            String data = (String)right.b();
            PluginDescriptor descriptor2 = PluginDescriptor$.MODULE$.load(data);
            if (!this.isPluginCompatibleWithIdea(descriptor2, ctx)) {
                void var11_10;
                PluginLogger$.MODULE$.warn((Function0)new Serializable(this, plugin, (PluginDescriptor)var11_10){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RepoPluginInstaller $outer;
                    private final IntellijPlugin plugin$1;
                    private final PluginDescriptor descriptor$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Plugin ", " is incompatible with current ideaVersion(", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.plugin$1, this.$outer.org$jetbrains$sbtidea$download$plugin$RepoPluginInstaller$$buildInfo.buildNumber(), this.descriptor$1}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.plugin$1 = plugin$1;
                        this.descriptor$1 = descriptor$1;
                    }
                });
                return false;
            }
            boolean bl = false;
            IntellijPlugin.Id id = null;
            IntellijPlugin intellijPlugin = plugin;
            if (intellijPlugin instanceof IntellijPlugin.Id) {
                bl = true;
                id = (IntellijPlugin.Id)intellijPlugin;
                Option<String> option = id.version();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String version = (String)some.x();
                    String string = descriptor2.version();
                    String string2 = version;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        PluginLogger$.MODULE$.info((Function0)new Serializable(this, plugin, descriptor2, version){
                            public static final long serialVersionUID = 0L;
                            private final IntellijPlugin plugin$1;
                            private final PluginDescriptor descriptor$1;
                            private final String version$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Locally installed plugin ", " has different version: ", " != ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.plugin$1, this.descriptor$1.version(), this.version$1}));
                            }
                            {
                                this.plugin$1 = plugin$1;
                                this.descriptor$1 = descriptor$1;
                                this.version$1 = version$1;
                            }
                        });
                        return false;
                    }
                }
            }
            if (bl) {
                Option<String> option = id.version();
                Option<String> channel = id.channel();
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                    Option<String> option3 = this.getMoreUpToDateVersion(descriptor2, channel);
                    None$ none$2 = None$.MODULE$;
                    Option<String> option4 = option3;
                    if (!(none$2 != null ? !none$2.equals(option4) : option4 != null)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        break block11;
                    } else {
                        if (option3 instanceof Some) {
                            Some some = (Some)option3;
                            String newVersion = (String)some.x();
                            PluginLogger$.MODULE$.warn((Function0)new Serializable(this, plugin, descriptor2, newVersion){
                                public static final long serialVersionUID = 0L;
                                private final IntellijPlugin plugin$1;
                                private final PluginDescriptor descriptor$1;
                                private final String newVersion$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Newer version of plugin ", " is available: ", " -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.plugin$1, this.descriptor$1.version(), this.newVersion$1}));
                                }
                                {
                                    this.plugin$1 = plugin$1;
                                    this.descriptor$1 = descriptor$1;
                                    this.newVersion$1 = newVersion$1;
                                }
                            });
                            return false;
                        }
                        throw new MatchError(option3);
                    }
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<String> getMoreUpToDateVersion(PluginDescriptor descriptor, Option<String> channel) {
        Either<Throwable, String> either = this.repo.getLatestPluginVersion(this.org$jetbrains$sbtidea$download$plugin$RepoPluginInstaller$$buildInfo, descriptor.id(), channel);
        if (either instanceof Right) {
            Right right = (Right)either;
            String version = (String)right.b();
            if (VersionComparatorUtil.compare(descriptor.version(), version) < 0) {
                return new Some((Object)version);
            }
        }
        if (!(either instanceof Left)) return None$.MODULE$;
        Left left = (Left)either;
        Throwable error = (Throwable)left.a();
        PluginLogger$.MODULE$.warn((Function0)new Serializable(this, descriptor, error){
            public static final long serialVersionUID = 0L;
            private final PluginDescriptor descriptor$2;
            private final Throwable error$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to fetch latest plugin ", " version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.descriptor$2.id(), this.error$2}));
            }
            {
                this.descriptor$2 = descriptor$2;
                this.error$2 = error$2;
            }
        });
        return None$.MODULE$;
    }

    public boolean isPluginCompatibleWithIdea(PluginDescriptor metadata, InstallContext ctx) {
        String lower = metadata.sinceBuild().replaceAll("^.+-", "");
        String upper = metadata.untilBuild().replaceAll("^.+-", "");
        boolean lowerValid = RepoPluginInstaller$.MODULE$.compareIdeaVersions(lower, package$.MODULE$.BuildInfoOps(this.org$jetbrains$sbtidea$download$plugin$RepoPluginInstaller$$buildInfo).getActualIdeaBuild(ctx.baseDirectory())) <= 0;
        boolean upperValid = RepoPluginInstaller$.MODULE$.compareIdeaVersions(upper, package$.MODULE$.BuildInfoOps(this.org$jetbrains$sbtidea$download$plugin$RepoPluginInstaller$$buildInfo).getActualIdeaBuild(ctx.baseDirectory())) >= 0;
        return lowerValid && upperValid;
    }

    public boolean isPluginJar(Path artifact) {
        PluginXmlDetector detector = new PluginXmlDetector();
        return detector.test(artifact);
    }

    private Path pluginsDir(InstallContext ctx) {
        return ctx.baseDirectory().resolve("plugins");
    }

    public RepoPluginInstaller(package.BuildInfo buildInfo, PluginRepoApi repo, LocalPluginRegistryApi localRegistry) {
        this.org$jetbrains$sbtidea$download$plugin$RepoPluginInstaller$$buildInfo = buildInfo;
        this.repo = repo;
        this.localRegistry = localRegistry;
    }
}

