/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sbtidea.runIdea;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.jetbrains.sbtidea.package$;
import org.jetbrains.sbtidea.runIdea.IntellijAwareRunner$;
import org.jetbrains.sbtidea.runIdea.JRE;
import sbt.jetbrains.ideaPlugin.apiAdapter;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4Q!\u0001\u0002\u0002\u0002-\u00111#\u00138uK2d\u0017N[!xCJ,'+\u001e8oKJT!a\u0001\u0003\u0002\u000fI,h.\u00133fC*\u0011QAB\u0001\bg\n$\u0018\u000eZ3b\u0015\t9\u0001\"A\u0005kKR\u0014'/Y5og*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0016S:$X\r\u001c7jU\n\u000b7/\u001a#je\u0016\u001cGo\u001c:z!\t)B$D\u0001\u0017\u0015\t9\u0002$\u0001\u0003gS2,'BA\r\u001b\u0003\rq\u0017n\u001c\u0006\u00027\u0005!!.\u0019<b\u0013\tibC\u0001\u0003QCRD\u0007\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u0011\tdwnY6j]\u001e\u0004\"!D\u0011\n\u0005\tr!a\u0002\"p_2,\u0017M\u001c\u0005\u0006I\u0001!\t!J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019B\u0013\u0006\u0005\u0002(\u00015\t!\u0001C\u0003\u0014G\u0001\u0007A\u0003C\u0003 G\u0001\u0007\u0001\u0005C\u0003,\u0001\u0011EA&\u0001\beKR,7\r\u001e'pG\u0006d'JU#\u0016\u00035\u0002\"a\n\u0018\n\u0005=\u0012!a\u0001&S\u000b\")\u0011\u0007\u0001C\u0005e\u0005yq-\u001a;NC*|'OV3sg&|g.F\u00014!\tiA'\u0003\u00026\u001d\t\u0019\u0011J\u001c;\t\u000b]\u0002A\u0011\u0003\u001d\u0002#\u001d,GOS1wC\u0016CXmY;uC\ndW\r\u0006\u0002\u0015s!)!H\u000ea\u0001[\u0005\u0019!N]3\t\u000bq\u0002A\u0011C\u001f\u0002!\t,\u0018\u000e\u001c3Gk2d7i\\7nC:$W#\u0001 \u0011\u0007}\u0012E)D\u0001A\u0015\t\t%$\u0001\u0003vi&d\u0017BA\"A\u0005\u0011a\u0015n\u001d;\u0011\u0005\u0015CeBA\u0007G\u0013\t9e\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$\u000f\u0011\u0015a\u0005A\"\u0005N\u00035\u0011W/\u001b7e\u0015\u00064\u0018-\u0011:hgV\ta\nE\u0002P/\u0012s!\u0001U+\u000f\u0005E#V\"\u0001*\u000b\u0005MS\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\t1f\"A\u0004qC\u000e\\\u0017mZ3\n\u0005aK&aA*fc*\u0011aK\u0004\u0005\u00067\u0002!\t\u0001X\u0001\u0004eVtG#A\u001a\b\u000by\u0013\u0001\u0012A0\u0002'%sG/\u001a7mS*\fu/\u0019:f%Vtg.\u001a:\u0011\u0005\u001d\u0002g!B\u0001\u0003\u0011\u0003\t7C\u00011\r\u0011\u0015!\u0003\r\"\u0001d)\u0005y\u0006\"B3a\t\u00031\u0017!D4fi\n+h\u000e\u001a7fI*\u0013V\t\u0006\u0002hUB\u0019Q\u0002[\u0017\n\u0005%t!AB(qi&|g\u000eC\u0003\u0014I\u0002\u0007A\u0003C\u0003mA\u0012%Q.A\tfqR\u0014\u0018m\u0019;K\u0005J3VM]:j_:$\"A\\8\u0011\u00075A7\u0007C\u0003qW\u0002\u0007A#\u0001\u0003i_6,\u0007")
public abstract class IntellijAwareRunner {
    private final Path intellijBaseDirectory;
    private final boolean blocking;

    public static Option<JRE> getBundledJRE(Path path) {
        return IntellijAwareRunner$.MODULE$.getBundledJRE(path);
    }

    public JRE detectLocalJRE() {
        Path localHome = Paths.get(System.getProperties().getProperty("java.home"), new String[0]);
        int localVersion = this.getMajorVersion();
        return new JRE(localHome, localVersion);
    }

    private int getMajorVersion() {
        int n;
        try {
            Method runtime_version = Runtime.class.getMethod("version", new Class[0]);
            Object version = runtime_version.invoke(null, new Object[0]);
            Method version_major = runtime_version.getReturnType().getMethod("feature", new Class[0]);
            n = BoxesRunTime.unboxToInt((Object)version_major.invoke(version, new Object[0]));
        }
        catch (Exception exception) {
            String versionString = System.getProperty("java.specification.version");
            n = new StringOps(Predef$.MODULE$.augmentString(versionString.substring(2))).toInt();
        }
        return n;
    }

    public Path getJavaExecutable(JRE jre) {
        Path path;
        Path path2 = path = System.getProperty("os.name").startsWith("Win") ? apiAdapter.PathExt$.MODULE$.$div$extension(package$.MODULE$.pathToPathExt(apiAdapter.PathExt$.MODULE$.$div$extension(package$.MODULE$.pathToPathExt(jre.root()), "bin")), "java.exe") : apiAdapter.PathExt$.MODULE$.$div$extension(package$.MODULE$.pathToPathExt(apiAdapter.PathExt$.MODULE$.$div$extension(package$.MODULE$.pathToPathExt(jre.root()), "bin")), "java");
        if (path.toFile().exists()) {
            return path;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to locate java executable from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jre})));
    }

    public List<String> buildFullCommand() {
        Option<JRE> bundledJre = IntellijAwareRunner$.MODULE$.getBundledJRE(this.intellijBaseDirectory);
        JRE jre = (JRE)bundledJre.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IntellijAwareRunner $outer;

            public final JRE apply() {
                return this.$outer.detectLocalJRE();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Path javaExe = this.getJavaExecutable(jre);
        Seq<String> args = this.buildJavaArgs();
        String string = ((Object)javaExe.toAbsolutePath()).toString();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)args.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).asJava();
    }

    public abstract Seq<String> buildJavaArgs();

    public int run() {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Process process = processBuilder.command(this.buildFullCommand()).inheritIO().start();
        return this.blocking ? process.waitFor() : 0;
    }

    public IntellijAwareRunner(Path intellijBaseDirectory, boolean blocking) {
        this.intellijBaseDirectory = intellijBaseDirectory;
        this.blocking = blocking;
    }
}

