/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sbtidea.tasks;

import java.io.File;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.List;
import org.jetbrains.sbtidea.Keys$;
import org.jetbrains.sbtidea.PluginSigningOptions;
import org.jetbrains.sbtidea.packaging.PackagingKeys$;
import org.jetbrains.sbtidea.tasks.SbtIdeaTask;
import org.jetbrains.zip.signer.signer.PublicKeyUtils;
import org.jetbrains.zip.signer.signer.SignerInfo;
import org.jetbrains.zip.signer.signer.SignerInfoLoader;
import org.jetbrains.zip.signer.signing.DefaultSignatureProvider;
import org.jetbrains.zip.signer.signing.SignatureProvider;
import org.jetbrains.zip.signer.signing.ZipSigner;
import sbt.AList$;
import sbt.Def$;
import sbt.Init;
import sbt.Task;
import sbt.package$;
import sbt.std.FullInstance$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;

public final class SignPluginArtifactTask$
implements SbtIdeaTask<File> {
    public static final SignPluginArtifactTask$ MODULE$;
    private final String PLUGIN_SIGN_KEY;
    private final String PLUGIN_SIGN_KEY_PWD;
    private final String PLUGIN_SIGN_CERT;

    static {
        new SignPluginArtifactTask$();
    }

    public PluginSigningOptions defaultSignOptions() {
        return new PluginSigningOptions(false, (Option<File>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    @Override
    public Init.Initialize<Task<File>> createTask() {
        return (Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple2((Object)PackagingKeys$.MODULE$.packageArtifactZip(), (Object)Def$.MODULE$.toITask(Keys$.MODULE$.signPluginOptions())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(Tuple2<File, PluginSigningOptions> $p1) {
                File file = (File)$p1._1();
                PluginSigningOptions pluginSigningOptions = (PluginSigningOptions)$p1._2();
                PluginSigningOptions opts = SignPluginArtifactTask$.MODULE$.org$jetbrains$sbtidea$tasks$SignPluginArtifactTask$$getSigningOptions(pluginSigningOptions);
                File inputFile = file;
                File outputFile = package$.MODULE$.richFile(inputFile.getParentFile()).$div(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"signed-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.richFile(inputFile).name()})));
                return SignPluginArtifactTask$.MODULE$.doSignPlugin(opts, inputFile, outputFile);
            }
        }, AList$.MODULE$.tuple2());
    }

    public File doSignPlugin(PluginSigningOptions opts, File inputFile, File outputFile) {
        boolean bl;
        PluginSigningOptions pluginSigningOptions;
        block12: {
            File file;
            block11: {
                block10: {
                    pluginSigningOptions = opts;
                    if (pluginSigningOptions == null) break block10;
                    boolean bl2 = pluginSigningOptions.enabled();
                    Option<File> option = pluginSigningOptions.certFile();
                    Option<File> option2 = pluginSigningOptions.privateKeyFile();
                    Option<String> option3 = pluginSigningOptions.keyPassphrase();
                    if (!bl2 || !(option instanceof Some)) break block10;
                    Some some = (Some)option;
                    File certFile = (File)some.x();
                    if (!(option2 instanceof Some)) break block10;
                    Some some2 = (Some)option2;
                    File privateKeyFile = (File)some2.x();
                    if (!(option3 instanceof Some)) break block10;
                    Some some3 = (Some)option3;
                    String keyPassphrase = (String)some3.x();
                    SignerInfo info = SignerInfoLoader.INSTANCE.loadSignerInfoFromFiles(privateKeyFile, certFile, keyPassphrase.toCharArray());
                    file = this.sign$1(info.component1(), info.component2(), inputFile, outputFile);
                    break block11;
                }
                if (pluginSigningOptions == null) break block12;
                boolean bl3 = pluginSigningOptions.enabled();
                Option<File> option = pluginSigningOptions.certFile();
                Option<File> option4 = pluginSigningOptions.privateKeyFile();
                Option<String> option5 = pluginSigningOptions.keyPassphrase();
                if (!bl3 || !(option instanceof Some)) break block12;
                Some some = (Some)option;
                File certFile = (File)some.x();
                if (!(option4 instanceof Some)) break block12;
                Some some4 = (Some)option4;
                File privateKeyFile = (File)some4.x();
                None$ none$ = None$.MODULE$;
                Option<String> option6 = option5;
                if (none$ != null ? !none$.equals(option6) : option6 != null) break block12;
                SignerInfo info = SignerInfoLoader.INSTANCE.loadSignerInfoFromFiles(privateKeyFile, certFile);
                file = this.sign$1(info.component1(), info.component2(), inputFile, outputFile);
            }
            return file;
        }
        if (pluginSigningOptions != null) {
            boolean bl4 = pluginSigningOptions.enabled();
            Option<File> option = pluginSigningOptions.certFile();
            Option<File> option7 = pluginSigningOptions.privateKeyFile();
            if (bl4) {
                None$ none$ = None$.MODULE$;
                Option<File> option8 = option;
                if (!(none$ != null ? !none$.equals(option8) : option8 != null) && option7 instanceof Some) {
                    throw new IllegalArgumentException("Certificate chain file doesn't exist");
                }
            }
        }
        if (pluginSigningOptions != null) {
            boolean bl5 = pluginSigningOptions.enabled();
            Option<File> option = pluginSigningOptions.certFile();
            Option<File> option9 = pluginSigningOptions.privateKeyFile();
            if (bl5 && option instanceof Some) {
                None$ none$ = None$.MODULE$;
                Option<File> option10 = option9;
                if (!(none$ != null ? !none$.equals(option10) : option10 != null)) {
                    throw new IllegalArgumentException("Private key file doesn't exist");
                }
            }
        }
        if (pluginSigningOptions != null && !(bl = pluginSigningOptions.enabled())) {
            throw new IllegalStateException("Plugin signing disabled in options");
        }
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported plugin signing: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pluginSigningOptions})));
    }

    public String org$jetbrains$sbtidea$tasks$SignPluginArtifactTask$$envOrError(String name, boolean optional) {
        return (String)scala.sys.package$.MODULE$.env().getOrElse((Object)name, (Function0)new Serializable(name, optional){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final boolean optional$1;

            public final String apply() {
                if (this.optional$1) {
                    return null;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Required env ", " was not provided"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
            }
            {
                this.name$1 = name$1;
                this.optional$1 = optional$1;
            }
        });
    }

    public boolean org$jetbrains$sbtidea$tasks$SignPluginArtifactTask$$envOrError$default$2() {
        return false;
    }

    public PluginSigningOptions org$jetbrains$sbtidea$tasks$SignPluginArtifactTask$$getSigningOptions(PluginSigningOptions optsFromSbt) {
        Option actualCert = optsFromSbt.certFile().orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Some<File> apply() {
                return new Some((Object)new File(SignPluginArtifactTask$.MODULE$.org$jetbrains$sbtidea$tasks$SignPluginArtifactTask$$envOrError("PLUGIN_SIGN_CERT", SignPluginArtifactTask$.MODULE$.org$jetbrains$sbtidea$tasks$SignPluginArtifactTask$$envOrError$default$2())));
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return x$1.exists();
            }
        });
        Option actualKey = optsFromSbt.privateKeyFile().orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Some<File> apply() {
                return new Some((Object)new File(SignPluginArtifactTask$.MODULE$.org$jetbrains$sbtidea$tasks$SignPluginArtifactTask$$envOrError("PLUGIN_SIGN_KEY", SignPluginArtifactTask$.MODULE$.org$jetbrains$sbtidea$tasks$SignPluginArtifactTask$$envOrError$default$2())));
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$2) {
                return x$2.exists();
            }
        });
        Option actualPass = optsFromSbt.keyPassphrase().orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return Option$.MODULE$.apply((Object)SignPluginArtifactTask$.MODULE$.org$jetbrains$sbtidea$tasks$SignPluginArtifactTask$$envOrError("PLUGIN_SIGN_KEY_PWD", true));
            }
        });
        Option x$3 = actualCert;
        Option x$4 = actualKey;
        Option x$5 = actualPass;
        boolean x$6 = optsFromSbt.copy$default$1();
        return optsFromSbt.copy(x$6, (Option<File>)x$3, (Option<File>)x$4, (Option<String>)x$5);
    }

    private final String PLUGIN_SIGN_KEY() {
        return "PLUGIN_SIGN_KEY";
    }

    private final String PLUGIN_SIGN_KEY_PWD() {
        return "PLUGIN_SIGN_KEY_PWD";
    }

    private final String PLUGIN_SIGN_CERT() {
        return "PLUGIN_SIGN_CERT";
    }

    private final File sign$1(List certs, PrivateKey key, File inputFile$1, File outputFile$1) {
        DefaultSignatureProvider signatureProvider = new DefaultSignatureProvider(PublicKeyUtils.INSTANCE.getSuggestedSignatureAlgorithm(((Certificate)certs.get(0)).getPublicKey()), key);
        ZipSigner.sign((File)inputFile$1, (File)outputFile$1, (List)certs, (SignatureProvider)signatureProvider);
        return outputFile$1;
    }

    private SignPluginArtifactTask$() {
        MODULE$ = this;
    }
}

