/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sbt.extractors;

import java.io.File;
import java.io.Serializable;
import org.jetbrains.sbt.Options;
import org.jetbrains.sbt.SbtStateOps;
import org.jetbrains.sbt.StructureKeys$;
import org.jetbrains.sbt.TaskOps;
import org.jetbrains.sbt.extractors.DependenciesExtractor;
import org.jetbrains.sbt.extractors.DependenciesExtractor$ProjectDependency$;
import org.jetbrains.sbt.extractors.package$;
import org.jetbrains.sbt.structure.Configuration;
import org.jetbrains.sbt.structure.Configuration$;
import org.jetbrains.sbt.structure.DependencyData;
import sbt.Classpaths$;
import sbt.Def$;
import sbt.Keys$;
import sbt.ProjectRef;
import sbt.Reference;
import sbt.Result;
import sbt.Scope;
import sbt.SettingKey;
import sbt.State;
import sbt.Task;
import sbt.TaskKey;
import sbt.internal.BuildDependencies;
import sbt.internal.BuildStructure;
import sbt.internal.util.AList$;
import sbt.internal.util.Attributed;
import sbt.internal.util.Init;
import sbt.internal.util.Settings;
import sbt.jetbrains.PluginCompat$;
import sbt.std.FullInstance$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple9;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class DependenciesExtractor$
implements SbtStateOps,
TaskOps {
    public static DependenciesExtractor$ MODULE$;

    static {
        new DependenciesExtractor$();
    }

    @Override
    public <T> TaskOps.enrich.u0020Task<T> enrich$u0020Task(Task<T> task) {
        return TaskOps.enrich$u0020Task$(this, task);
    }

    @Override
    public <T> TaskOps.any.u0020to.u0020Task<T> any$u0020to$u0020Task(T value) {
        return TaskOps.any$u0020to$u0020Task$(this, value);
    }

    @Override
    public State applySettings(State state, Seq<Init.Setting<?>> globalSettings, Seq<Init.Setting<?>> projectSettings) {
        return SbtStateOps.applySettings$(this, state, globalSettings, projectSettings);
    }

    @Override
    public BuildStructure structure(State state) {
        return SbtStateOps.structure$(this, state);
    }

    @Override
    public <T> SbtStateOps.SettingKeyOps<T> SettingKeyOps(SettingKey<T> key) {
        return SbtStateOps.SettingKeyOps$(this, key);
    }

    @Override
    public <T> SbtStateOps.TaskKeyOps<T> TaskKeyOps(TaskKey<T> key) {
        return SbtStateOps.TaskKeyOps$(this, key);
    }

    public Init.Initialize<Task<DependencyData>> taskDef() {
        return FullInstance$.MODULE$.flatten((Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple9(StructureKeys$.MODULE$.acceptedProjects(), (Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.buildDependencies()), (Object)Def$.MODULE$.toITask(StructureKeys$.MODULE$.sourceConfigurations()), (Object)Def$.MODULE$.toITask(StructureKeys$.MODULE$.testConfigurations()), (Object)Def$.MODULE$.toITask(StructureKeys$.MODULE$.dependencyConfigurations()), (Object)Def$.MODULE$.toITask(StructureKeys$.MODULE$.sbtStructureOpts()), (Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.thisProjectRef()), (Object)Keys$.MODULE$.settingsData(), (Object)Keys$.MODULE$.state()), (Function1 & Serializable & scala.Serializable)$p$macro$11 -> {
            State state;
            Seq seq = (Seq)$p$macro$11._1();
            BuildDependencies buildDependencies = (BuildDependencies)$p$macro$11._2();
            Seq seq2 = (Seq)$p$macro$11._3();
            Seq seq3 = (Seq)$p$macro$11._4();
            Seq seq4 = (Seq)$p$macro$11._5();
            Options options = (Options)$p$macro$11._6();
            ProjectRef projectRef = (ProjectRef)$p$macro$11._7();
            Settings settings = (Settings)$p$macro$11._8();
            State state2 = state = (State)$p$macro$11._9();
            Settings settings2 = settings;
            ProjectRef projectRef2 = projectRef;
            Options options2 = options;
            Seq dependencyConfigurations = seq4;
            Seq testConfigurations = seq3;
            Seq sourceConfigurations = seq2;
            BuildDependencies buildDependencies2 = buildDependencies;
            Task unmanagedClasspathTask = MODULE$.TaskKeyOps((TaskKey)PluginCompat$.MODULE$.sbtSlashSyntaxRichReference((Reference)projectRef2).$div(Keys$.MODULE$.unmanagedClasspath())).forAllConfigurations(state2, (Seq<sbt.librarymanagement.Configuration>)dependencyConfigurations);
            Task externalDependencyClasspathTask = MODULE$.enrich$u0020Task(sbt.package$.MODULE$.singleInputTask(sbt.package$.MODULE$.singleInputTask(MODULE$.TaskKeyOps((TaskKey)PluginCompat$.MODULE$.sbtSlashSyntaxRichReference((Reference)projectRef2).$div(Keys$.MODULE$.externalDependencyClasspath())).forAllConfigurations(state2, (Seq<sbt.librarymanagement.Configuration>)dependencyConfigurations)).result()).map((Function1 & Serializable & scala.Serializable)result -> PluginCompat$.MODULE$.throwExceptionIfUpdateFailed((Result<Map<sbt.librarymanagement.Configuration, Seq<Attributed<File>>>>)result))).onlyIf((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> options2.download());
            Task classpathConfigurationTask = MODULE$.TaskKeyOps((TaskKey)PluginCompat$.MODULE$.sbtSlashSyntaxRichReference((Reference)projectRef2).$div(Keys$.MODULE$.classpathConfiguration())).forAllConfigurations(state2, (Seq<sbt.librarymanagement.Configuration>)dependencyConfigurations);
            Seq allAcceptedProjects = seq;
            Map projectToSourceConfigurations = DependenciesExtractor$.getProjectToConfigurations$1(StructureKeys$.MODULE$.sourceConfigurations(), state2, allAcceptedProjects);
            Map projectToTestConfigurations = DependenciesExtractor$.getProjectToConfigurations$1(StructureKeys$.MODULE$.testConfigurations(), state2, allAcceptedProjects);
            Map projectToConfigurations = ((TraversableOnce)allAcceptedProjects.map((Function1 & Serializable & scala.Serializable)proj -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(proj), (Object)new DependenciesExtractor.ProjectConfigurations((Seq<String>)((Seq)projectToSourceConfigurations.apply(proj)), (Seq<String>)((Seq)projectToTestConfigurations.apply(proj)))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            return (Init.Initialize)FullInstance$.MODULE$.map((Object)Def$.MODULE$.valueStrict((Object)sbt.package$.MODULE$.singleInputTask(unmanagedClasspathTask).flatMap((Function1 & Serializable & scala.Serializable)unmanagedClasspath -> sbt.package$.MODULE$.singleInputTask(externalDependencyClasspathTask).flatMap((Function1 & Serializable & scala.Serializable)externalDependencyClasspathOpt -> sbt.package$.MODULE$.singleInputTask(classpathConfigurationTask).map((Function1 & Serializable & scala.Serializable)classpathConfiguration -> {
                Map<DependenciesExtractor.ProjectType, Seq<Configuration>> projectDependencies = options2.separateProdAndTestSources() ? MODULE$.getTransitiveDependenciesForProjectProdTestSources(projectRef2, (Map<ProjectRef, DependenciesExtractor.ProjectConfigurations>)projectToConfigurations, (Map<sbt.librarymanagement.Configuration, sbt.librarymanagement.Configuration>)classpathConfiguration, (Settings<Scope>)settings2, buildDependencies2) : MODULE$.getTransitiveDependenciesForProject(projectRef2, (Map<ProjectRef, DependenciesExtractor.ProjectConfigurations>)projectToConfigurations, (Map<sbt.librarymanagement.Configuration, sbt.librarymanagement.Configuration>)classpathConfiguration, (Settings<Scope>)settings2, buildDependencies2);
                DependenciesExtractor extractor = new DependenciesExtractor((Function1<sbt.librarymanagement.Configuration, Seq<Attributed<File>>>)(Function1 & Serializable & scala.Serializable)x$10 -> (Seq)unmanagedClasspath.getOrElse(x$10, (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), (Option<Function1<sbt.librarymanagement.Configuration, Seq<Attributed<File>>>>)externalDependencyClasspathOpt.map((Function1 & Serializable & scala.Serializable)it -> (Function1 & Serializable & scala.Serializable)x$11 -> (Seq)it.getOrElse(x$11, (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), (Seq<sbt.librarymanagement.Configuration>)dependencyConfigurations, (Seq<sbt.librarymanagement.Configuration>)testConfigurations, (Seq<sbt.librarymanagement.Configuration>)sourceConfigurations, options2.separateProdAndTestSources(), projectDependencies);
                return extractor.extract();
            })))), (Function1 & Serializable & scala.Serializable)$q$macro$1 -> $q$macro$1);
        }, AList$.MODULE$.tuple9()));
    }

    private Map<DependenciesExtractor.ProjectType, Seq<Configuration>> getTransitiveDependenciesForProject(ProjectRef projectRef, Map<ProjectRef, DependenciesExtractor.ProjectConfigurations> projectToConfigurations, Map<sbt.librarymanagement.Configuration, sbt.librarymanagement.Configuration> classPathConfiguration, Settings<Scope> settings, BuildDependencies buildDependencies) {
        Map<DependenciesExtractor.ProjectDependency, Seq<Configuration>> dependencyToConfigurations = this.retrieveTransitiveProjectToConfigsDependencies(projectRef, classPathConfiguration, settings, buildDependencies, projectToConfigurations);
        return this.mapDependenciesToProjectType(dependencyToConfigurations, (Function1<DependenciesExtractor.ProjectDependency, DependenciesExtractor.ProjectType>)(Function1 & Serializable & scala.Serializable)projectDependency -> new DependenciesExtractor.ProductionType(projectDependency.project()));
    }

    private Map<DependenciesExtractor.ProjectType, Seq<Configuration>> mapDependenciesToProjectType(Map<DependenciesExtractor.ProjectDependency, Seq<Configuration>> dependencyToConfigurations, Function1<DependenciesExtractor.ProjectDependency, DependenciesExtractor.ProjectType> projectDependencyMapping) {
        return (Map)dependencyToConfigurations.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Map acc = (Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    DependenciesExtractor.ProjectDependency projectDependency = (DependenciesExtractor.ProjectDependency)tuple22._1();
                    Seq configs = (Seq)tuple22._2();
                    DependenciesExtractor.ProjectType projectType = (DependenciesExtractor.ProjectType)projectDependencyMapping.apply((Object)projectDependency);
                    Seq existingConfigurations = (Seq)acc.getOrElse((Object)projectType, (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
                    return acc.updated((Object)projectType, ((SeqLike)existingConfigurations.$plus$plus((GenTraversableOnce)configs, Seq$.MODULE$.canBuildFrom())).distinct());
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Map<DependenciesExtractor.ProjectDependency, Seq<Configuration>> retrieveTransitiveProjectToConfigsDependencies(ProjectRef projectRef, Map<sbt.librarymanagement.Configuration, sbt.librarymanagement.Configuration> classPathConfiguration, Settings<Scope> settings, BuildDependencies buildDependencies, Map<ProjectRef, DependenciesExtractor.ProjectConfigurations> projectToConfigurations) {
        Map configToDependencies = (Map)classPathConfiguration.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                sbt.librarymanagement.Configuration selfConfig = (sbt.librarymanagement.Configuration)tuple2._1();
                sbt.librarymanagement.Configuration config = (sbt.librarymanagement.Configuration)tuple2._2();
                Seq<DependenciesExtractor.ProjectDependency> projectDependencies = MODULE$.retrieveTransitiveProjectDependencies(projectRef, config, settings, buildDependencies, projectToConfigurations);
                return new Tuple2((Object)new Configuration(selfConfig.name()), projectDependencies);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        return package$.MODULE$.invert(configToDependencies);
    }

    private Map<DependenciesExtractor.ProjectType, Seq<Configuration>> getTransitiveDependenciesForProjectProdTestSources(ProjectRef projectRef, Map<ProjectRef, DependenciesExtractor.ProjectConfigurations> projectToConfigurations, Map<sbt.librarymanagement.Configuration, sbt.librarymanagement.Configuration> classPathConfiguration, Settings<Scope> settings, BuildDependencies buildDependencies) {
        Map<DependenciesExtractor.ProjectDependency, Seq<Configuration>> dependencyToConfigurations = this.retrieveTransitiveProjectToConfigsDependencies(projectRef, classPathConfiguration, settings, buildDependencies, projectToConfigurations);
        Map<DependenciesExtractor.ProjectType, Seq<Configuration>> keysMappedToProjectType = this.mapDependenciesToProjectType(dependencyToConfigurations, (Function1<DependenciesExtractor.ProjectDependency, DependenciesExtractor.ProjectType>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            DependenciesExtractor.ProjectDependency projectDependency = x0$1;
            if (projectDependency != null) {
                Some some;
                DependenciesExtractor.ProjectConfigurations projectConfigurations;
                ProjectRef project = projectDependency.project();
                String configuration = projectDependency.configuration();
                Option option = projectToConfigurations.get((Object)project);
                if (option instanceof Some && (projectConfigurations = (DependenciesExtractor.ProjectConfigurations)(some = (Some)option).value()).test().contains((Object)configuration)) {
                    return new DependenciesExtractor.TestType(project);
                }
                return new DependenciesExtractor.ProductionType(project);
            }
            throw new MatchError((Object)projectDependency);
        });
        return keysMappedToProjectType.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new DependenciesExtractor.ProductionType(projectRef)), (Object)new .colon.colon((Object)Configuration$.MODULE$.Test(), (List)Nil$.MODULE$)));
    }

    private Seq<DependenciesExtractor.ProjectDependency> retrieveTransitiveProjectDependencies(ProjectRef projectRef, sbt.librarymanagement.Configuration config, Settings<Scope> settings, BuildDependencies buildDependencies, Map<ProjectRef, DependenciesExtractor.ProjectConfigurations> projectToConfigurations) {
        Seq allDependencies = Classpaths$.MODULE$.interSort(projectRef, config, settings, buildDependencies);
        Seq dependenciesWithoutProjectItself = (Seq)allDependencies.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DependenciesExtractor$.$anonfun$retrieveTransitiveProjectDependencies$1(projectRef, projectToConfigurations, x0$1)));
        return (Seq)dependenciesWithoutProjectItself.map((Function1 & Serializable & scala.Serializable)tuple -> DependenciesExtractor$ProjectDependency$.MODULE$.apply((Tuple2<ProjectRef, String>)tuple), Seq$.MODULE$.canBuildFrom());
    }

    private boolean isProjectDependencyInSourceConfiguration(ProjectRef project, String configuration, Map<ProjectRef, DependenciesExtractor.ProjectConfigurations> projectToConfigurations) {
        return ((SeqLike)projectToConfigurations.get((Object)project).fold((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$, (Function1 & Serializable & scala.Serializable)t -> (Seq)t.source().$plus$plus(t.test(), Seq$.MODULE$.canBuildFrom()))).contains((Object)configuration);
    }

    private static final Map getProjectToConfigurations$1(SettingKey key, State state$1, Seq allAcceptedProjects$1) {
        return MODULE$.SettingKeyOps(key).forAllProjects(state$1, (Seq<ProjectRef>)allAcceptedProjects$1).toMap(Predef$.MODULE$.$conforms()).mapValues((Function1 & Serializable & scala.Serializable)x$8 -> (Seq)x$8.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.name(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).withDefaultValue((Object)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$retrieveTransitiveProjectDependencies$1(ProjectRef projectRef$3, Map projectToConfigurations$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ProjectRef project = (ProjectRef)tuple2._1();
            String config = (String)tuple2._2();
            ProjectRef projectRef = project;
            ProjectRef projectRef2 = projectRef$3;
            return (projectRef == null ? projectRef2 != null : !projectRef.equals(projectRef2)) && MODULE$.isProjectDependencyInSourceConfiguration(project, config, (Map<ProjectRef, DependenciesExtractor.ProjectConfigurations>)projectToConfigurations$4);
        }
        throw new MatchError((Object)tuple2);
    }

    private DependenciesExtractor$() {
        MODULE$ = this;
        SbtStateOps.$init$(this);
        TaskOps.$init$(this);
    }
}

