/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sbt.extractors;

import java.io.File;
import java.io.Serializable;
import org.jetbrains.sbt.ModuleReportAdapter;
import org.jetbrains.sbt.ModulesOps;
import org.jetbrains.sbt.SbtStateOps;
import org.jetbrains.sbt.TaskOps;
import org.jetbrains.sbt.UpdateReportAdapter;
import org.jetbrains.sbt.extractors.RepositoryExtractor$;
import org.jetbrains.sbt.structure.ModuleData;
import org.jetbrains.sbt.structure.ModuleIdentifier;
import org.jetbrains.sbt.structure.RepositoryData;
import sbt.ProjectRef;
import sbt.SettingKey;
import sbt.State;
import sbt.Task;
import sbt.TaskKey;
import sbt.internal.BuildStructure;
import sbt.internal.util.Init;
import sbt.librarymanagement.Artifact;
import sbt.librarymanagement.ModuleID;
import sbt.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u000b\u0017\u0001}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005o!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\"\u0002,\u0001\t\u00039\u0006BB0\u0001\t\u00031\u0002\rC\u0003h\u0001\u0011%\u0001\u000eC\u0003n\u0001\u0011%a\u000eC\u0003r\u0001\u0011%!\u000fC\u0003t\u0001\u0011%A\u000fC\u0003x\u0001\u0011%\u0001\u0010C\u0004\u0002\b\u0001!I!!\u0003\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014\u001d9\u00111\u0005\f\t\u0002\u0005\u0015bAB\u000b\u0017\u0011\u0003\t9\u0003\u0003\u0004W!\u0011\u0005\u0011Q\u0007\u0005\b\u0003o\u0001B\u0011AA\u001d\u0011\u001d\ty\u0006\u0005C\u0005\u0003CBq!a\u0018\u0011\t\u0013\tiHA\nSKB|7/\u001b;pef,\u0005\u0010\u001e:bGR|'O\u0003\u0002\u00181\u0005QQ\r\u001f;sC\u000e$xN]:\u000b\u0005eQ\u0012aA:ci*\u00111\u0004H\u0001\nU\u0016$(M]1j]NT\u0011!H\u0001\u0004_J<7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\t\u0001$\u0003\u0002*1\tQQj\u001c3vY\u0016\u001cx\n]:\u0002\u0011A\u0014xN[3diN\u00042\u0001L\u00182\u001b\u0005i#B\u0001\u0018#\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003a5\u00121aU3r!\t\u0011D'D\u00014\u0015\u0005I\u0012BA\u001b4\u0005)\u0001&o\u001c6fGR\u0014VMZ\u0001\u000ekB$\u0017\r^3SKB|'\u000f^:\u0011\t\u0005B\u0014GO\u0005\u0003s\t\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005\u001dZ\u0014B\u0001\u001f\u0019\u0005M)\u0006\u000fZ1uKJ+\u0007o\u001c:u\u0003\u0012\f\u0007\u000f^3s\u0003a)\b\u000fZ1uK\u000ec\u0017m]:jM&,'o\u001d*fa>\u0014Ho\u001d\t\u0004C}:\u0014B\u0001!#\u0005\u0019y\u0005\u000f^5p]\u0006q1\r\\1tgB\fG\u000f\u001b+za\u0016\u001c\b\u0003B\u00119c\r\u00032\u0001R&O\u001d\t)\u0015\n\u0005\u0002GE5\tqI\u0003\u0002I=\u00051AH]8pizJ!A\u0013\u0012\u0002\rA\u0013X\rZ3g\u0013\taUJA\u0002TKRT!A\u0013\u0012\u0011\u0005\u0011{\u0015B\u0001)N\u0005\u0019\u0019FO]5oO\u0006Y\u0002O]8kK\u000e$Hk\\\"p]\u001aLw-\u001e:bi&|gn\u001d(b[\u0016\u0004B\u0001R*2+&\u0011A+\u0014\u0002\u0004\u001b\u0006\u0004\bc\u0001\u00170\u001d\u00061A(\u001b8jiz\"b\u0001\u0017.\\9vs\u0006CA-\u0001\u001b\u00051\u0002\"\u0002\u0016\u0007\u0001\u0004Y\u0003\"\u0002\u001c\u0007\u0001\u00049\u0004\"B\u001f\u0007\u0001\u0004q\u0004\"B!\u0007\u0001\u0004\u0011\u0005\"B)\u0007\u0001\u0004\u0011\u0016aB3yiJ\f7\r^\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011A\rG\u0001\ngR\u0014Xo\u0019;ve\u0016L!AZ2\u0003\u001dI+\u0007o\\:ji>\u0014\u0018\u0010R1uC\u0006\u0011\u0012\r\u001c7N_\u0012,H.Z:XSRDGi\\2t+\u0005I\u0007c\u0001\u00170UB\u0011qe[\u0005\u0003Yb\u00111#T8ek2,'+\u001a9peR\fE-\u00199uKJ\fQ\"\\8ek2,w+\u001b;i\t>\u001cGCA5p\u0011\u0015\u0001\u0018\u00021\u00012\u0003)\u0001(o\u001c6fGR\u0014VMZ\u0001\u0012C2d7\t\\1tgB\fG\u000f\u001b+za\u0016\u001cX#A\"\u0002C\u0019L\u00070T8ek2,7/\u00133t)>\u001cV\u000f\u001d9peR\u001cE.Y:tS\u001aLWM]:\u0015\u0005%,\b\"\u0002<\f\u0001\u0004I\u0017aB7pIVdWm]\u0001\u0019OJ|W\u000f\u001d\"z\u001b>$W\u000f\\3JI\u0016tG/\u001b4jKJ\u001cHcA=\u0002\u0006A!!0`@j\u001b\u0005Y(B\u0001?.\u0003\u001diW\u000f^1cY\u0016L!A`>\u0003\u001b1Kgn[3e\u0011\u0006\u001c\b.T1q!\r\u0011\u0017\u0011A\u0005\u0004\u0003\u0007\u0019'\u0001E'pIVdW-\u00133f]RLg-[3s\u0011\u00151H\u00021\u0001j\u0003Q9W\r^'pIVdWm\u001d$peB\u0013xN[3diR)\u0011.a\u0003\u0002\u000e!)\u0001/\u0004a\u0001c!1\u0011qB\u0007A\u0002]\na\"\u001e9eCR,'+\u001a9peR4e.\u0001\tde\u0016\fG/Z'pIVdW\rR1uCR1\u0011QCA\u000e\u0003?\u00012AYA\f\u0013\r\tIb\u0019\u0002\u000b\u001b>$W\u000f\\3ECR\f\u0007BBA\u000f\u001d\u0001\u0007q0\u0001\u0005n_\u0012,H.Z%e\u0011\u0019\t\tC\u0004a\u0001S\u0006iQn\u001c3vY\u0016\u0014V\r]8siN\f1CU3q_NLGo\u001c:z\u000bb$(/Y2u_J\u0004\"!\u0017\t\u0014\rA\u0001\u0013\u0011FA\u0018!\r9\u00131F\u0005\u0004\u0003[A\"aC*ciN#\u0018\r^3PaN\u00042aJA\u0019\u0013\r\t\u0019\u0004\u0007\u0002\b)\u0006\u001c8n\u00149t)\t\t)#A\u0004uCN\\G)\u001a4\u0016\u0005\u0005m\u0002CBA\u001f\u0003\u000f\n9F\u0004\u0003\u0002@\u0005\rcb\u0001$\u0002B%\t\u0011$C\u0002\u0002FM\n1\u0001R3g\u0013\u0011\tI%a\u0013\u0003\u0015%s\u0017\u000e^5bY&TX-\u0003\u0003\u0002N\u0005=#\u0001B%oSRTA!!\u0015\u0002T\u0005!Q\u000f^5m\u0015\r\t)fM\u0001\tS:$XM\u001d8bYB)!'!\u0017\u0002^%\u0019\u00111L\u001a\u0003\tQ\u000b7o\u001b\t\u0004C}\n\u0017!F3yiJ\f7\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012\u000bG/\u0019\u000b\t\u0003G\n)'a\u001c\u0002zA!!'!\u0017b\u0011\u001d\t9g\u0005a\u0001\u0003S\nQa\u001d;bi\u0016\u00042AMA6\u0013\r\tig\r\u0002\u0006'R\fG/\u001a\u0005\b\u0003c\u001a\u0002\u0019AA:\u0003\u001dy\u0007\u000f^5p]N\u00042aJA;\u0013\r\t9\b\u0007\u0002\b\u001fB$\u0018n\u001c8t\u0011\u0019\tYh\u0005a\u0001W\u0005\u0001\u0012mY2faR,G\r\u0015:pU\u0016\u001cGo\u001d\u000b\t\u0003G\ny(!!\u0002\u0004\"9\u0011q\r\u000bA\u0002\u0005%\u0004bBA9)\u0001\u0007\u00111\u000f\u0005\b\u0003w\"\u0002\u0019AAC!\u0015\t9)!$2\u001b\t\tIIC\u0002\u0002\f6\n\u0011\"[7nkR\f'\r\\3\n\u0007A\nI\t")
public class RepositoryExtractor
implements ModulesOps {
    private final Seq<ProjectRef> projects;
    private final Function1<ProjectRef, UpdateReportAdapter> updateReports;
    private final Option<Function1<ProjectRef, UpdateReportAdapter>> updateClassifiersReports;
    private final Function1<ProjectRef, Set<String>> classpathTypes;
    private final Map<ProjectRef, Seq<String>> projectToConfigurationsName;

    public static Init.Initialize<Task<Option<RepositoryData>>> taskDef() {
        return RepositoryExtractor$.MODULE$.taskDef();
    }

    public static <T> TaskOps.any.u0020to.u0020Task<T> any$u0020to$u0020Task(T t) {
        return RepositoryExtractor$.MODULE$.any$u0020to$u0020Task(t);
    }

    public static <T> TaskOps.enrich.u0020Task<T> enrich$u0020Task(Task<T> task) {
        return RepositoryExtractor$.MODULE$.enrich$u0020Task(task);
    }

    public static <T> SbtStateOps.TaskKeyOps<T> TaskKeyOps(TaskKey<T> taskKey) {
        return RepositoryExtractor$.MODULE$.TaskKeyOps(taskKey);
    }

    public static <T> SbtStateOps.SettingKeyOps<T> SettingKeyOps(SettingKey<T> settingKey) {
        return RepositoryExtractor$.MODULE$.SettingKeyOps(settingKey);
    }

    public static BuildStructure structure(State state) {
        return RepositoryExtractor$.MODULE$.structure(state);
    }

    public static State applySettings(State state, Seq<Init.Setting<?>> seq, Seq<Init.Setting<?>> seq2) {
        return RepositoryExtractor$.MODULE$.applySettings(state, seq, seq2);
    }

    @Override
    public String fuseClassifier(Artifact artifact) {
        return ModulesOps.fuseClassifier$(this, artifact);
    }

    @Override
    public Seq<ModuleIdentifier> createModuleIdentifiers(ModuleID moduleId, Seq<Artifact> artifacts2) {
        return ModulesOps.createModuleIdentifiers$(this, moduleId, artifacts2);
    }

    public RepositoryData extract() {
        Seq<ModuleReportAdapter> moduleReports = this.fixModulesIdsToSupportClassifiers(this.allModulesWithDocs());
        LinkedHashMap<ModuleIdentifier, Seq<ModuleReportAdapter>> modulesReportsByIdentifier = this.groupByModuleIdentifiers(moduleReports);
        Seq modulesData = (Seq)modulesReportsByIdentifier.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ModuleIdentifier a = (ModuleIdentifier)tuple2._1();
                Seq b = (Seq)tuple2._2();
                return this.createModuleData(a, (Seq<ModuleReportAdapter>)b);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return new RepositoryData((Seq<ModuleData>)modulesData);
    }

    private Seq<ModuleReportAdapter> allModulesWithDocs() {
        return (Seq)this.projects.flatMap((Function1 & Serializable & scala.Serializable)projectRef -> this.moduleWithDoc((ProjectRef)projectRef), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<ModuleReportAdapter> moduleWithDoc(ProjectRef projectRef) {
        Seq<ModuleReportAdapter> modulesWithoutDocs = this.getModulesForProject(projectRef, this.updateReports);
        Option modulesWithDocs = this.updateClassifiersReports.map((Function1 & Serializable & scala.Serializable)updateClassifiersReportsFn -> {
            Seq<ModuleReportAdapter> docModules = this.getModulesForProject(projectRef, (Function1<ProjectRef, UpdateReportAdapter>)updateClassifiersReportsFn);
            return (Seq)modulesWithoutDocs.map((Function1 & Serializable & scala.Serializable)report -> {
                Seq matchingDocs = (Seq)((TraversableLike)docModules.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RepositoryExtractor.$anonfun$moduleWithDoc$3(report, x$1)))).flatMap((Function1 & Serializable & scala.Serializable)r -> RepositoryExtractor.onlySourcesAndDocs$1(r.artifacts()), Seq$.MODULE$.canBuildFrom());
                return new ModuleReportAdapter(report.moduleId(), (Seq<Tuple2<Artifact, File>>)((Seq)report.artifacts().$plus$plus((GenTraversableOnce)matchingDocs, Seq$.MODULE$.canBuildFrom())));
            }, Seq$.MODULE$.canBuildFrom());
        });
        return (Seq)modulesWithDocs.getOrElse((Function0 & Serializable & scala.Serializable)() -> modulesWithoutDocs);
    }

    private Set<String> allClasspathTypes() {
        return (Set)((TraversableOnce)this.projects.map(this.classpathTypes, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> (Set)a.union((GenSet)b));
    }

    private Seq<ModuleReportAdapter> fixModulesIdsToSupportClassifiers(Seq<ModuleReportAdapter> modules) {
        return (Seq)modules.map((Function1 & Serializable & scala.Serializable)r -> r.copy(r.moduleId().artifacts((Seq)r.artifacts().map((Function1 & Serializable & scala.Serializable)x$2 -> (Artifact)x$2._1(), Seq$.MODULE$.canBuildFrom())), r.copy$default$2()), Seq$.MODULE$.canBuildFrom());
    }

    private LinkedHashMap<ModuleIdentifier, Seq<ModuleReportAdapter>> groupByModuleIdentifiers(Seq<ModuleReportAdapter> modules) {
        Seq modulesWithIds = (Seq)modules.flatMap((Function1 & Serializable & scala.Serializable)module -> (Seq)this.createModuleIdentifiers(module.moduleId(), (Seq<Artifact>)((Seq)module.artifacts().map((Function1 & Serializable & scala.Serializable)x$3 -> (Artifact)x$3._1(), Seq$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)id -> new Tuple2(module, id), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        LinkedHashMap result = LinkedHashMap$.MODULE$.empty();
        modulesWithIds.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RepositoryExtractor.$anonfun$groupByModuleIdentifiers$4(result, x0$1);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    private Seq<ModuleReportAdapter> getModulesForProject(ProjectRef projectRef, Function1<ProjectRef, UpdateReportAdapter> updateReportFn) {
        UpdateReportAdapter updateReportAdapter = (UpdateReportAdapter)updateReportFn.apply((Object)projectRef);
        return (Seq)((TraversableLike)((TraversableLike)this.projectToConfigurationsName.apply((Object)projectRef)).flatMap((Function1 & Serializable & scala.Serializable)configuration -> updateReportAdapter.modulesFrom((String)configuration), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RepositoryExtractor.$anonfun$getModulesForProject$2(x$4)));
    }

    private ModuleData createModuleData(ModuleIdentifier moduleId, Seq<ModuleReportAdapter> moduleReports) {
        Seq allArtifacts = (Seq)moduleReports.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.artifacts(), Seq$.MODULE$.canBuildFrom());
        return new ModuleData(moduleId, (Set<File>)this.artifacts$1(this.allClasspathTypes(), allArtifacts, moduleId), (Set<File>)this.artifacts$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{package$.MODULE$.Artifact().DocType()})), allArtifacts, moduleId), (Set<File>)this.artifacts$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{package$.MODULE$.Artifact().SourceType()})), allArtifacts, moduleId));
    }

    private static final Seq onlySourcesAndDocs$1(Seq artifacts2) {
        return (Seq)artifacts2.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Artifact, File>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                block2: {
                    File f;
                    Artifact a;
                    block3: {
                        A1 A1 = x1;
                        if (A1 == null) break block2;
                        a = (Artifact)A1._1();
                        f = (File)A1._2();
                        String string = a.type();
                        String string2 = package$.MODULE$.Artifact().DocType();
                        if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
                        String string3 = a.type();
                        String string4 = package$.MODULE$.Artifact().SourceType();
                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                    }
                    return (B1)new Tuple2((Object)a, (Object)f);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Artifact, File> x1) {
                block2: {
                    block3: {
                        Tuple2<Artifact, File> tuple2 = x1;
                        if (tuple2 == null) break block2;
                        Artifact a = (Artifact)tuple2._1();
                        String string = a.type();
                        String string2 = package$.MODULE$.Artifact().DocType();
                        if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
                        String string3 = a.type();
                        String string4 = package$.MODULE$.Artifact().SourceType();
                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                    }
                    return true;
                }
                return false;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$moduleWithDoc$3(ModuleReportAdapter report$1, ModuleReportAdapter x$1) {
        ModuleID moduleID = x$1.moduleId();
        ModuleID moduleID2 = report$1.moduleId();
        return !(moduleID != null ? !moduleID.equals(moduleID2) : moduleID2 != null);
    }

    public static final /* synthetic */ void $anonfun$groupByModuleIdentifiers$4(LinkedHashMap result$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ModuleReportAdapter adapter = (ModuleReportAdapter)tuple2._1();
            ModuleIdentifier identifier = (ModuleIdentifier)tuple2._2();
            Seq adapters = (Seq)result$1.getOrElse((Object)identifier, (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
            result$1.update((Object)identifier, adapters.$colon$plus((Object)adapter, Seq$.MODULE$.canBuildFrom()));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getModulesForProject$2(ModuleReportAdapter x$4) {
        return x$4.artifacts().nonEmpty();
    }

    private final Set artifacts$1(Set kinds, Seq allArtifacts$1, ModuleIdentifier moduleId$1) {
        return ((TraversableOnce)allArtifacts$1.collect((PartialFunction)new scala.Serializable(this, moduleId$1, kinds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoryExtractor $outer;
            private final ModuleIdentifier moduleId$1;
            private final Set kinds$1;

            public final <A1 extends Tuple2<Artifact, File>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Artifact a = (Artifact)A1._1();
                    File f = (File)A1._2();
                    String string = this.moduleId$1.classifier();
                    String string2 = this.$outer.fuseClassifier(a);
                    if (!(string != null ? !string.equals(string2) : string2 != null) && this.kinds$1.contains((Object)a.type())) {
                        return (B1)f;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Artifact, File> x1) {
                Tuple2<Artifact, File> tuple2 = x1;
                if (tuple2 != null) {
                    Artifact a = (Artifact)tuple2._1();
                    String string = this.moduleId$1.classifier();
                    String string2 = this.$outer.fuseClassifier(a);
                    if (!(string != null ? !string.equals(string2) : string2 != null) && this.kinds$1.contains((Object)a.type())) {
                        return true;
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.moduleId$1 = moduleId$1;
                this.kinds$1 = kinds$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public RepositoryExtractor(Seq<ProjectRef> projects, Function1<ProjectRef, UpdateReportAdapter> updateReports, Option<Function1<ProjectRef, UpdateReportAdapter>> updateClassifiersReports, Function1<ProjectRef, Set<String>> classpathTypes, Map<ProjectRef, Seq<String>> projectToConfigurationsName) {
        this.projects = projects;
        this.updateReports = updateReports;
        this.updateClassifiersReports = updateClassifiersReports;
        this.classpathTypes = classpathTypes;
        this.projectToConfigurationsName = projectToConfigurationsName;
        ModulesOps.$init$(this);
    }
}

