/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.zlmedia.restful;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.zlmedia.hook.AbstractHookOperations;
import org.jetlinks.zlmedia.hook.HookEvent;
import org.jetlinks.zlmedia.hook.HookResponse;
import org.jetlinks.zlmedia.restful.RestfulHookOperations;
import reactor.core.publisher.Mono;

class RestfulHookOperationsImpl
extends AbstractHookOperations
implements RestfulHookOperations {
    private final Map<String, Class<? extends HookEvent<?>>> pathMapping = new ConcurrentHashMap();
    protected final ObjectMapper mapper;

    RestfulHookOperationsImpl(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    protected void onListen(Class<? extends HookEvent<?>> type) {
        String name = type.getSimpleName();
        StringBuilder builder = new StringBuilder("on_");
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i != 0) {
                    builder.append('_');
                }
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        this.pathMapping.put(builder.toString(), type);
        this.pathMapping.put(name, type);
        this.pathMapping.put("on" + name, type);
    }

    @Override
    public Mono<HookResponse> fireEvent(String type, String payload) {
        Class<? extends HookEvent<?>> clazz;
        if (type.contains("/")) {
            type = type.substring(type.lastIndexOf(47) + 1);
        }
        if ((clazz = this.pathMapping.get(type)) == null) {
            return Mono.empty();
        }
        try {
            return this.fireEvent((HookEvent)this.mapper.readerFor(clazz).readValue(payload));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)e);
        }
    }
}

