/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.zlmedia.restful;

import org.jetlinks.zlmedia.proxy.FFMpegRequest;
import org.jetlinks.zlmedia.proxy.ProxyOperations;
import org.jetlinks.zlmedia.proxy.StreamProxyRequest;
import org.jetlinks.zlmedia.proxy.StreamPusherRequest;
import org.jetlinks.zlmedia.restful.RestfulClient;
import org.jetlinks.zlmedia.restful.RestfulResponse;
import org.jetlinks.zlmedia.restful.model.AddFFmpegSource;
import org.jetlinks.zlmedia.restful.model.AddStreamProxy;
import org.jetlinks.zlmedia.restful.model.AddStreamPusherProxy;
import org.jetlinks.zlmedia.restful.model.DelFFmpegSource;
import org.jetlinks.zlmedia.restful.model.DelStreamProxy;
import org.jetlinks.zlmedia.restful.model.DelStreamPusherProxy;
import org.jetlinks.zlmedia.restful.model.ProxyStreamResponse;
import reactor.core.publisher.Mono;

class RestfulProxyOperations
implements ProxyOperations {
    private final RestfulClient client;

    public Mono<String> addStreamProxy(StreamProxyRequest request) {
        request.validate();
        return this.client.request(new AddStreamProxy(request)).mapNotNull(resp -> (ProxyStreamResponse)resp.assertSuccess().getData()).map(ProxyStreamResponse::getKey);
    }

    public Mono<Void> delStreamProxy(String key) {
        return this.client.request(new DelStreamProxy(key)).doOnNext(RestfulResponse::assertSuccess).then();
    }

    public Mono<String> addStreamPusherProxy(StreamPusherRequest request) {
        return this.client.request(new AddStreamPusherProxy(request)).mapNotNull(resp -> (ProxyStreamResponse)resp.assertSuccess().getData()).map(ProxyStreamResponse::getKey);
    }

    public Mono<Void> delStreamPusherProxy(String key) {
        return this.client.request(new DelStreamPusherProxy(key)).doOnNext(RestfulResponse::assertSuccess).then();
    }

    public Mono<String> addFFMpegSource(FFMpegRequest request) {
        return this.client.request(new AddFFmpegSource(request)).mapNotNull(resp -> (ProxyStreamResponse)resp.assertSuccess().getData()).map(ProxyStreamResponse::getKey);
    }

    public Mono<Void> delFFMpegSource(String key) {
        return this.client.request(new DelFFmpegSource(key)).doOnNext(RestfulResponse::assertSuccess).then();
    }

    public RestfulProxyOperations(RestfulClient client) {
        this.client = client;
    }
}

