/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.zlmedia.restful;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import org.jetlinks.zlmedia.exception.ZLMediaException;
import org.jetlinks.zlmedia.record.GetMp4RecordRequest;
import org.jetlinks.zlmedia.record.RecordFileInfo;
import org.jetlinks.zlmedia.record.RecordOperations;
import org.jetlinks.zlmedia.record.RecordType;
import org.jetlinks.zlmedia.record.StartRecordRequest;
import org.jetlinks.zlmedia.restful.RestfulClient;
import org.jetlinks.zlmedia.restful.model.GetMp4RecordFile;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class RestfulRecordOperations
implements RecordOperations {
    private final RestfulClient client;

    public Mono<Void> startRecord(StartRecordRequest request) {
        return this.client.request("/index/api/startRecord", request, Void.class).then();
    }

    public Mono<Void> stopRecord(String app, RecordType type, String stream) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app", app);
        param.put("type", type.ordinal());
        param.put("stream", stream);
        return this.client.request("/index/api/stopRecord", param, Void.class).then();
    }

    public Mono<Boolean> isRecording(String app, RecordType type, String stream) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app", app);
        param.put("type", type.ordinal());
        param.put("stream", stream);
        return this.client.request("/index/api/isRecording", param, HashMap.class).mapNotNull(map -> Boolean.TRUE.equals(map.getOrDefault("status", false)));
    }

    public Flux<ByteBuf> getSnapshot(String url) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("url", url);
        param.put("timeout_sec", 20);
        param.put("expire_sec", 5);
        return ((WebClient.RequestBodySpec)this.client.http.post().uri("/index/api/getSnap", new Object[0])).bodyValue(param).exchangeToFlux(response -> {
            if (response.statusCode().is2xxSuccessful()) {
                return response.bodyToFlux(ByteBuf.class);
            }
            return response.bodyToMono(String.class).flatMap(s -> Mono.error((Throwable)new ZLMediaException(s))).flux();
        });
    }

    public Flux<RecordFileInfo> getMp4RecordFile(GetMp4RecordRequest request) {
        return this.client.request(new GetMp4RecordFile(request)).mapNotNull(response -> (RecordFileInfo)response.assertSuccess().getData()).flux();
    }

    public RestfulRecordOperations(RestfulClient client) {
        this.client = client;
    }
}

