/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.zlmedia.restful;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetlinks.zlmedia.ZLMediaOperations;
import org.jetlinks.zlmedia.hook.HookOperations;
import org.jetlinks.zlmedia.media.MediaOperations;
import org.jetlinks.zlmedia.proxy.ProxyOperations;
import org.jetlinks.zlmedia.record.RecordOperations;
import org.jetlinks.zlmedia.restful.RestfulClient;
import org.jetlinks.zlmedia.restful.RestfulHookOperationsImpl;
import org.jetlinks.zlmedia.restful.RestfulMediaOperations;
import org.jetlinks.zlmedia.restful.RestfulProxyOperations;
import org.jetlinks.zlmedia.restful.RestfulRecordOperations;
import org.jetlinks.zlmedia.restful.RestfulRtpOperations;
import org.jetlinks.zlmedia.restful.ZLMediaConfigs;
import org.jetlinks.zlmedia.restful.model.GetServerConfig;
import org.jetlinks.zlmedia.restful.model.SetServerConfig;
import org.jetlinks.zlmedia.rtp.RtpOperations;
import org.jetlinks.zlmedia.state.StateOperations;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class RestfulZLMediaOperations
implements ZLMediaOperations,
StateOperations {
    private final RestfulClient client;
    private final HookOperations hookOperations;
    private final MediaOperations mediaOperations;
    private final RecordOperations recordOperations;
    private final RtpOperations rtpOperations;
    private final ProxyOperations proxyOperations;
    static NameTransformer SNAKE_CASE = new NameTransformer(){

        public String transform(String name) {
            return PropertyNamingStrategies.SNAKE_CASE.nameForField(null, null, name);
        }

        public String reverse(String transformed) {
            return transformed;
        }
    };

    public RestfulZLMediaOperations(WebClient client, ZLMediaConfigs configs, ObjectMapper mapper) {
        this.client = new RestfulClient(client, RestfulZLMediaOperations.createObjectMapper(mapper));
        this.hookOperations = new RestfulHookOperationsImpl(this.client.mapper);
        this.mediaOperations = new RestfulMediaOperations(this.client, configs);
        this.recordOperations = new RestfulRecordOperations(this.client);
        this.rtpOperations = new RestfulRtpOperations(this.client);
        this.proxyOperations = new RestfulProxyOperations(this.client);
    }

    static ObjectMapper createObjectMapper(ObjectMapper mapper) {
        mapper = mapper.copy();
        SimpleModule module = new SimpleModule();
        module.setSerializerModifier(new BeanSerializerModifier(){

            public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
                ArrayList<BeanPropertyWriter> propertyWriters = new ArrayList<BeanPropertyWriter>(beanProperties.size());
                for (BeanPropertyWriter beanProperty : beanProperties) {
                    propertyWriters.add(beanProperty.rename(SNAKE_CASE));
                }
                return propertyWriters;
            }
        });
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
                ArrayList<BeanPropertyDefinition> def = new ArrayList<BeanPropertyDefinition>(propDefs);
                for (BeanPropertyDefinition propDef : propDefs) {
                    String newName = PropertyNamingStrategies.SNAKE_CASE.nameForField((MapperConfig)config, null, propDef.getName());
                    if (newName.equals(propDef.getName())) continue;
                    def.add(propDef.withName(new PropertyName(newName)));
                }
                return def;
            }
        });
        return mapper.setConfig(mapper.getSerializationConfig().without(SerializationFeature.FAIL_ON_EMPTY_BEANS)).setConfig(mapper.getDeserializationConfig().with(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL).without(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).registerModule((Module)module);
    }

    public MediaOperations opsForMedia() {
        return this.mediaOperations;
    }

    public RecordOperations opsForRecord() {
        return this.recordOperations;
    }

    public RtpOperations opsForRtp() {
        return this.rtpOperations;
    }

    public ProxyOperations opsForProxy() {
        return this.proxyOperations;
    }

    public HookOperations opsForHook() {
        return this.hookOperations;
    }

    public StateOperations opsForState() {
        return this;
    }

    public Mono<Boolean> isAlive() {
        return this.getConfigs().hasElement().onErrorResume(err -> Mono.just((Object)false));
    }

    public Mono<Map<String, String>> getConfigs() {
        return this.client.request(new GetServerConfig()).filter(res -> res.getCode() == 0 && !CollectionUtils.isEmpty((Collection)((Collection)res.getData()))).map(res -> (Map)((List)res.getData()).get(0));
    }

    public Mono<Map<String, String>> setConfigs(Map<String, String> configs) {
        return this.client.request(new SetServerConfig(configs)).map(res -> {
            res.assertSuccess();
            return configs;
        });
    }
}

