/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.fx;

import java.io.File;
import java.io.IOException;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.FileChooser;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.fx.ChartCanvas;
import org.jfree.chart.fx.interaction.ChartMouseListenerFX;
import org.jfree.chart.fx.interaction.ZoomHandlerFX;
import org.jfree.chart.ui.Drawable;
import org.jfree.chart.util.Args;
import org.jfree.chart.util.ExportUtils;

public class ChartViewer
extends Region {
    private ChartCanvas canvas;
    private Rectangle zoomRectangle;
    private ContextMenu contextMenu;

    public ChartViewer() {
        this(null);
    }

    public ChartViewer(JFreeChart chart) {
        this(chart, true);
    }

    public ChartViewer(JFreeChart chart, boolean contextMenuEnabled) {
        this.canvas = new ChartCanvas(chart);
        this.canvas.setTooltipEnabled(true);
        this.canvas.addMouseHandler(new ZoomHandlerFX("zoom", this));
        this.setFocusTraversable(true);
        this.getChildren().add((Object)this.canvas);
        this.zoomRectangle = new Rectangle(0.0, 0.0, (Paint)new Color(0.0, 0.0, 1.0, 0.25));
        this.zoomRectangle.setManaged(false);
        this.zoomRectangle.setVisible(false);
        this.getChildren().add((Object)this.zoomRectangle);
        this.contextMenu = this.createContextMenu();
        this.setOnContextMenuRequested(event -> this.contextMenu.show(this.getScene().getWindow(), event.getScreenX(), event.getScreenY()));
        this.contextMenu.setOnShowing(e -> this.getCanvas().setTooltipEnabled(false));
        this.contextMenu.setOnHiding(e -> this.getCanvas().setTooltipEnabled(true));
    }

    public JFreeChart getChart() {
        return this.canvas.getChart();
    }

    public void setChart(JFreeChart chart) {
        Args.nullNotPermitted((Object)chart, (String)"chart");
        this.canvas.setChart(chart);
    }

    public ChartCanvas getCanvas() {
        return this.canvas;
    }

    public ContextMenu getContextMenu() {
        return this.contextMenu;
    }

    public ChartRenderingInfo getRenderingInfo() {
        return this.getCanvas().getRenderingInfo();
    }

    public Paint getZoomFillPaint() {
        return this.zoomRectangle.getFill();
    }

    public void setZoomFillPaint(Paint paint) {
        this.zoomRectangle.setFill(paint);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.canvas.setLayoutX(0.0);
        this.canvas.setLayoutY(0.0);
        this.canvas.setWidth(this.getWidth());
        this.canvas.setHeight(this.getHeight());
    }

    public void addChartMouseListener(ChartMouseListenerFX listener) {
        Args.nullNotPermitted((Object)listener, (String)"listener");
        this.canvas.addChartMouseListener(listener);
    }

    public void removeChartMouseListener(ChartMouseListenerFX listener) {
        Args.nullNotPermitted((Object)listener, (String)"listener");
        this.canvas.removeChartMouseListener(listener);
    }

    private ContextMenu createContextMenu() {
        ContextMenu menu = new ContextMenu();
        menu.setAutoHide(true);
        Menu export = new Menu("Export As");
        MenuItem pngItem = new MenuItem("PNG...");
        pngItem.setOnAction(e -> this.handleExportToPNG());
        export.getItems().add((Object)pngItem);
        MenuItem jpegItem = new MenuItem("JPEG...");
        jpegItem.setOnAction(e -> this.handleExportToJPEG());
        export.getItems().add((Object)jpegItem);
        if (ExportUtils.isOrsonPDFAvailable()) {
            MenuItem pdfItem = new MenuItem("PDF...");
            pdfItem.setOnAction(e -> this.handleExportToPDF());
            export.getItems().add((Object)pdfItem);
        }
        if (ExportUtils.isJFreeSVGAvailable()) {
            MenuItem svgItem = new MenuItem("SVG...");
            svgItem.setOnAction(e -> this.handleExportToSVG());
            export.getItems().add((Object)svgItem);
        }
        menu.getItems().add((Object)export);
        return menu;
    }

    private void handleExportToPDF() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export to PDF");
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Portable Document Format (PDF)", new String[]{"*.pdf"});
        chooser.getExtensionFilters().add((Object)filter);
        File file = chooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            ExportUtils.writeAsPDF((Drawable)this.canvas.getChart(), (int)((int)this.getWidth()), (int)((int)this.getHeight()), (File)file);
        }
    }

    private void handleExportToSVG() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export to SVG");
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Scalable Vector Graphics (SVG)", new String[]{"*.svg"});
        chooser.getExtensionFilters().add((Object)filter);
        File file = chooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            ExportUtils.writeAsSVG((Drawable)this.canvas.getChart(), (int)((int)this.getWidth()), (int)((int)this.getHeight()), (File)file);
        }
    }

    private void handleExportToPNG() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export to PNG");
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Portable Network Graphics (PNG)", new String[]{"*.png"});
        chooser.getExtensionFilters().add((Object)filter);
        File file = chooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            try {
                ExportUtils.writeAsPNG((Drawable)this.canvas.getChart(), (int)((int)this.getWidth()), (int)((int)this.getHeight()), (File)file);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void handleExportToJPEG() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export to JPEG");
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("JPEG", new String[]{"*.jpg"});
        chooser.getExtensionFilters().add((Object)filter);
        File file = chooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            try {
                ExportUtils.writeAsJPEG((Drawable)this.canvas.getChart(), (int)((int)this.getWidth()), (int)((int)this.getHeight()), (File)file);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void showZoomRectangle(double x, double y, double w, double h) {
        this.zoomRectangle.setX(x);
        this.zoomRectangle.setY(y);
        this.zoomRectangle.setWidth(w);
        this.zoomRectangle.setHeight(h);
        this.zoomRectangle.setVisible(true);
    }

    public void hideZoomRectangle() {
        this.zoomRectangle.setVisible(false);
    }
}

