/*
 * Decompiled with CFR 0.152.
 */
package org.jfxcore.command;

import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.event.Event;
import org.jfxcore.command.AsyncCommand;
import org.jfxcore.command.Command;
import org.jfxcore.command.InvokeCommandActionList;
import org.jfxcore.interaction.TriggerAction;

@DefaultProperty(value="command")
public class InvokeCommandAction
extends TriggerAction<Object, Object> {
    private final DisabledValue disabled = new DisabledValue();
    private final CommandProperty command = new CommandProperty();
    private ObjectProperty<Object> parameter;
    private BooleanProperty passEventToCommand;
    private BooleanProperty disabledWhenExecuting;
    private BooleanProperty disabledWhenNotExecutable;

    ReadOnlyBooleanProperty disabledProperty() {
        return this.disabled;
    }

    public final ObjectProperty<Command> commandProperty() {
        return this.command;
    }

    public final Command getCommand() {
        return (Command)this.command.get();
    }

    public final void setCommand(Command command) {
        this.command.set(command);
    }

    public final ObjectProperty<Object> parameterProperty() {
        if (this.parameter == null) {
            this.parameter = new SimpleObjectProperty((Object)this, "parameter");
        }
        return this.parameter;
    }

    public final Object getParameter() {
        return this.parameter != null ? this.parameter.get() : null;
    }

    public final void setParameter(Object parameter) {
        if (this.parameter != null || parameter != null) {
            this.parameterProperty().set(parameter);
        }
    }

    public final BooleanProperty passEventToCommandProperty() {
        if (this.passEventToCommand == null) {
            this.passEventToCommand = new SimpleBooleanProperty((Object)this, "passEventToCommand");
        }
        return this.passEventToCommand;
    }

    public final boolean isPassEventToCommand() {
        return this.passEventToCommand != null && this.passEventToCommand.get();
    }

    public final void setPassEventToCommand(boolean value) {
        if (this.passEventToCommand != null || value) {
            this.passEventToCommandProperty().set(value);
        }
    }

    public final BooleanProperty disabledWhenExecutingProperty() {
        if (this.disabledWhenExecuting == null) {
            this.disabledWhenExecuting = new SimpleBooleanProperty(this, "disabledWhenExecuting", true){

                protected void invalidated() {
                    InvokeCommandAction.this.disabled.invalidated((Observable)this);
                }
            };
        }
        return this.disabledWhenExecuting;
    }

    public final boolean isDisabledWhenExecuting() {
        return this.disabledWhenExecuting == null || this.disabledWhenExecuting.get();
    }

    public final void setDisabledWhenExecuting(boolean value) {
        if (this.disabledWhenExecuting != null || !value) {
            this.disabledWhenExecutingProperty().set(value);
        }
    }

    public final BooleanProperty disabledWhenNotExecutableProperty() {
        if (this.disabledWhenNotExecutable == null) {
            this.disabledWhenNotExecutable = new SimpleBooleanProperty(this, "disabledWhenNotExecutable", true){

                protected void invalidated() {
                    InvokeCommandAction.this.disabled.invalidated((Observable)this);
                }
            };
        }
        return this.disabledWhenNotExecutable;
    }

    public final boolean isDisabledWhenNotExecutable() {
        return this.disabledWhenNotExecutable == null || this.disabledWhenNotExecutable.get();
    }

    public final void setDisabledWhenNotExecutable(boolean value) {
        if (this.disabledWhenNotExecutable != null || !value) {
            this.disabledWhenNotExecutableProperty().set(value);
        }
    }

    public InvokeCommandAction() {
    }

    public InvokeCommandAction(@NamedArg(value="command") Command command) {
        this.setCommand(command);
    }

    public InvokeCommandAction(@NamedArg(value="command") Command command, @NamedArg(value="parameter") Object parameter) {
        this.setCommand(command);
        this.setParameter(parameter);
    }

    @Override
    protected final void onExecute(Object parameter) {
        Command command = this.getCommand();
        if (command != null && command.isExecutable()) {
            AsyncCommand ac;
            if (command instanceof AsyncCommand && (ac = (AsyncCommand)command).isExecuting()) {
                ac.cancel();
            } else {
                Object actualParam = this.getParameter();
                if (actualParam == null && this.isPassEventToCommand() && parameter instanceof Event) {
                    Event event = (Event)parameter;
                    actualParam = event;
                }
                command.execute(actualParam);
            }
        }
    }

    @Override
    protected final void onAttached(Object associatedObject) {
        InvokeCommandActionList.get(associatedObject).add(this);
    }

    @Override
    protected final void onDetached(Object associatedObject) {
        InvokeCommandActionList.get(associatedObject).remove(this);
    }

    private class DisabledValue
    extends ReadOnlyBooleanPropertyBase
    implements InvalidationListener {
        boolean disabledWhenNotExecutable = true;
        boolean disabledWhenExecuting = true;
        boolean executing;
        boolean executable;

        private DisabledValue() {
        }

        void set(boolean executable, boolean executing) {
            boolean oldValue = this.get();
            this.executable = executable;
            this.executing = executing;
            this.fireValueChangedEvent(oldValue);
        }

        public Object getBean() {
            return InvokeCommandAction.this;
        }

        public String getName() {
            return "disabled";
        }

        public boolean get() {
            return !this.executable && this.disabledWhenNotExecutable || this.executing && this.disabledWhenExecuting;
        }

        public Boolean getValue() {
            return this.get();
        }

        public void invalidated(Observable observable) {
            boolean current = this.get();
            boolean value = ((ObservableBooleanValue)observable).get();
            if (observable == InvokeCommandAction.this.disabledWhenExecuting) {
                this.disabledWhenExecuting = value;
            } else if (observable == InvokeCommandAction.this.disabledWhenNotExecutable) {
                this.disabledWhenNotExecutable = value;
            } else {
                Command command = InvokeCommandAction.this.getCommand();
                if (command != null) {
                    AsyncCommand c;
                    if (observable == command.executableProperty()) {
                        this.executable = value;
                    } else if (command instanceof AsyncCommand && observable == (c = (AsyncCommand)command).executingProperty()) {
                        this.executing = value;
                    }
                }
            }
            this.fireValueChangedEvent(current);
        }

        private void fireValueChangedEvent(boolean oldValue) {
            if (oldValue != this.get()) {
                this.fireValueChangedEvent();
            }
        }
    }

    private class CommandProperty
    extends ObjectPropertyBase<Command> {
        Command currentValue;

        private CommandProperty() {
        }

        public Object getBean() {
            return InvokeCommandAction.this;
        }

        public String getName() {
            return "command";
        }

        protected void invalidated() {
            AsyncCommand c;
            Command command;
            boolean newExecutable = false;
            boolean newExecuting = false;
            if (this.currentValue != null) {
                this.currentValue.executableProperty().removeListener((InvalidationListener)InvokeCommandAction.this.disabled);
            }
            if ((command = this.currentValue) instanceof AsyncCommand) {
                c = (AsyncCommand)command;
                c.executingProperty().removeListener((InvalidationListener)InvokeCommandAction.this.disabled);
            }
            this.currentValue = (Command)this.get();
            if (this.currentValue != null) {
                this.currentValue.executableProperty().addListener((InvalidationListener)InvokeCommandAction.this.disabled);
                newExecutable = this.currentValue.isExecutable();
            }
            if ((command = this.currentValue) instanceof AsyncCommand) {
                c = (AsyncCommand)command;
                c.executingProperty().addListener((InvalidationListener)InvokeCommandAction.this.disabled);
                newExecuting = c.isExecuting();
            }
            InvokeCommandAction.this.disabled.set(newExecutable, newExecuting);
        }
    }
}

