/*
 * Decompiled with CFR 0.152.
 */
package org.jfxcore.command;

import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.jfxcore.command.Command;

public class RelayCommand<T>
extends Command {
    private final Consumer<T> operation;
    private final Consumer<Throwable> exceptionHandler;
    private final BooleanProperty executable = new SimpleBooleanProperty((Object)this, "executable", true);

    public RelayCommand(Runnable operation) {
        Objects.requireNonNull(operation, "operation cannot be null");
        this.operation = unused -> operation.run();
        this.exceptionHandler = null;
    }

    public RelayCommand(Runnable operation, Consumer<Throwable> exceptionHandler) {
        Objects.requireNonNull(operation, "operation cannot be null");
        this.operation = unused -> operation.run();
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler cannot be null");
    }

    public RelayCommand(Consumer<T> operation) {
        this.operation = Objects.requireNonNull(operation, "operation cannot be null");
        this.exceptionHandler = null;
    }

    public RelayCommand(Consumer<T> operation, Consumer<Throwable> exceptionHandler) {
        this.operation = Objects.requireNonNull(operation, "operation cannot be null");
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler cannot be null");
    }

    public final BooleanProperty executableProperty() {
        return this.executable;
    }

    @Override
    public final boolean isExecutable() {
        return this.executable.get();
    }

    public final void setExecutable(boolean executable) {
        this.executable.set(executable);
    }

    @Override
    protected void onExecute(Object parameter) {
        try {
            this.operation.accept(parameter);
        }
        catch (Throwable ex) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.accept(ex);
            }
            throw ex;
        }
    }
}

