/*
 * Decompiled with CFR 0.152.
 */
package org.jfxcore.command;

import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import org.jfxcore.command.AsyncCommand;
import org.jfxcore.command.StandardCommandCapabilities;

public class ServiceCommand
extends AsyncCommand
implements StandardCommandCapabilities.Message,
StandardCommandCapabilities.Title,
StandardCommandCapabilities.Progress {
    private final Service<?> service;
    private final InvalidationListener exceptionChangedListener;
    private final BooleanProperty executable = new SimpleBooleanProperty((Object)this, "executable", true);
    private final ReadOnlyBooleanWrapper executing = new ReadOnlyBooleanWrapper((Object)this, "executing");
    private final ReadOnlyDoubleWrapper progress = new ReadOnlyDoubleWrapper((Object)this, "progress", -1.0);
    private final ReadOnlyStringWrapper message = new ReadOnlyStringWrapper((Object)this, "message");
    private final ReadOnlyStringWrapper title = new ReadOnlyStringWrapper((Object)this, "title");

    public ServiceCommand(Service<?> service) {
        this(service, null, 0);
    }

    public ServiceCommand(Service<?> service, Consumer<Throwable> exceptionHandler) {
        this(service, Objects.requireNonNull(exceptionHandler, "exceptionHandler cannot be null"), 0);
    }

    private ServiceCommand(Service<?> service, Consumer<Throwable> exceptionHandler, int ignored) {
        this.service = Objects.requireNonNull(service, "service cannot be null");
        this.executing.bind((ObservableValue)service.runningProperty());
        this.message.bind((ObservableValue)service.messageProperty());
        this.title.bind((ObservableValue)service.titleProperty());
        this.progress.bind((ObservableValue)service.progressProperty());
        if (exceptionHandler != null) {
            this.exceptionChangedListener = observable -> {
                Throwable t = (Throwable)((ObservableValue)observable).getValue();
                if (t != null) {
                    exceptionHandler.accept(t);
                }
            };
            service.exceptionProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.exceptionChangedListener));
        } else {
            this.exceptionChangedListener = null;
        }
    }

    public final BooleanProperty executableProperty() {
        return this.executable;
    }

    @Override
    public final boolean isExecutable() {
        return this.executable.get();
    }

    public final void setExecutable(boolean executable) {
        this.executable.set(executable);
    }

    @Override
    public final ReadOnlyBooleanProperty executingProperty() {
        return this.executing.getReadOnlyProperty();
    }

    @Override
    public final boolean isExecuting() {
        return this.executing.get();
    }

    @Override
    public final ReadOnlyDoubleProperty progressProperty() {
        return this.progress.getReadOnlyProperty();
    }

    @Override
    public final double getProgress() {
        return this.progress.get();
    }

    @Override
    public final ReadOnlyStringProperty messageProperty() {
        return this.message.getReadOnlyProperty();
    }

    @Override
    public final String getMessage() {
        return this.message.get();
    }

    @Override
    public final ReadOnlyStringProperty titleProperty() {
        return this.title.getReadOnlyProperty();
    }

    @Override
    public final String getTitle() {
        return this.title.get();
    }

    @Override
    public void cancel() {
        this.service.cancel();
    }

    @Override
    protected void onExecute(Object parameter) {
        if (this.isExecuting()) {
            return;
        }
        this.service.restart();
    }
}

