/*
 * Decompiled with CFR 0.152.
 */
package org.jfxcore.interaction;

import java.util.Objects;
import javafx.beans.NamedArg;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import org.jfxcore.interaction.Trigger;
import org.jfxcore.interaction.TriggerAction;

public class EventTrigger<E extends Event>
extends Trigger<EventTarget, E> {
    private final EventType<E> eventType;
    private final boolean eventFilter;
    private final EventHandler<E> handler = event -> {
        if (this.handleEvent(event)) {
            this.runActions(event);
            event.consume();
        }
    };

    public EventTrigger(@NamedArg(value="eventType") EventType<E> eventType) {
        this.eventType = Objects.requireNonNull(eventType, "eventType cannot be null");
        this.eventFilter = false;
    }

    public EventTrigger(@NamedArg(value="eventType") EventType<E> eventType, @NamedArg(value="eventFilter") boolean eventFilter) {
        this.eventType = Objects.requireNonNull(eventType, "eventType cannot be null");
        this.eventFilter = eventFilter;
    }

    @SafeVarargs
    public EventTrigger(@NamedArg(value="eventType") EventType<E> eventType, TriggerAction<? super EventTarget, ? super E> ... actions) {
        super(actions);
        this.eventType = Objects.requireNonNull(eventType, "eventType cannot be null");
        this.eventFilter = false;
    }

    @SafeVarargs
    public EventTrigger(@NamedArg(value="eventType") EventType<E> eventType, @NamedArg(value="eventFilter") boolean eventFilter, TriggerAction<? super EventTarget, ? super E> ... actions) {
        super(actions);
        this.eventType = Objects.requireNonNull(eventType, "eventType cannot be null");
        this.eventFilter = eventFilter;
    }

    protected boolean handleEvent(E event) {
        return true;
    }

    @Override
    protected final void onAttached(EventTarget associatedObject) {
        if (this.eventFilter) {
            associatedObject.addEventFilter(this.eventType, this.handler);
        } else {
            associatedObject.addEventHandler(this.eventType, this.handler);
        }
    }

    @Override
    protected final void onDetached(EventTarget associatedObject) {
        if (this.eventFilter) {
            associatedObject.removeEventFilter(this.eventType, this.handler);
        } else {
            associatedObject.removeEventHandler(this.eventType, this.handler);
        }
    }
}

