/*
 * Decompiled with CFR 0.152.
 */
package org.jfxcore.interaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.jfxcore.interaction.Attachable;
import org.jfxcore.interaction.Behavior;
import org.jfxcore.interaction.Trigger;

public final class Interaction {
    private static final Map<Object, ObservableList<?>> behaviorLists = new WeakHashMap();
    private static final Map<Object, ObservableList<?>> triggerLists = new WeakHashMap();

    private Interaction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ObservableList<Behavior<? super T>> getBehaviors(T owner) {
        Objects.requireNonNull(owner, "owner cannot be null");
        if (owner instanceof Node) {
            Node node = (Node)owner;
            BehaviorList list = (BehaviorList)((Object)node.getProperties().get(BehaviorList.class));
            if (list == null) {
                list = new BehaviorList(node);
                node.getProperties().put(BehaviorList.class, list);
            }
            return list;
        }
        Map<Object, ObservableList<?>> map = behaviorLists;
        synchronized (map) {
            return behaviorLists.computeIfAbsent(owner, key -> new BehaviorList(owner));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ObservableList<Trigger<? super T, ?>> getTriggers(T owner) {
        Objects.requireNonNull(owner, "owner cannot be null");
        if (owner instanceof Node) {
            Node node = (Node)owner;
            TriggerList list = (TriggerList)((Object)node.getProperties().get(TriggerList.class));
            if (list == null) {
                list = new TriggerList(node);
                node.getProperties().put(TriggerList.class, list);
            }
            return list;
        }
        Map<Object, ObservableList<?>> map = triggerLists;
        synchronized (map) {
            return triggerLists.computeIfAbsent(owner, key -> new TriggerList(owner));
        }
    }

    private static class BehaviorList<T, U extends Behavior<? super T>>
    extends AttachableList<T, U> {
        BehaviorList(T owner) {
            super(owner);
        }

        @Override
        String elementName() {
            return Behavior.class.getSimpleName();
        }

        public String toString() {
            return BehaviorList.class.getName();
        }
    }

    private static class TriggerList<T, U extends Trigger<? super T, ?>>
    extends AttachableList<T, U> {
        TriggerList(T owner) {
            super(owner);
        }

        @Override
        String elementName() {
            return Trigger.class.getSimpleName();
        }

        public String toString() {
            return TriggerList.class.getName();
        }
    }

    private static abstract class AttachableList<T, U extends Attachable<? super T>>
    extends ModifiableObservableListBase<U> {
        final List<U> backingList = new ArrayList<U>(2);
        final T owner;

        AttachableList(T owner) {
            this.owner = owner;
        }

        public U get(int index) {
            return (U)((Attachable)this.backingList.get(index));
        }

        public int size() {
            return this.backingList.size();
        }

        protected void doAdd(int index, U element) {
            this.checkPreconditions(element);
            this.backingList.add(index, element);
            ((Attachable)element).associatedObject = this.owner;
            try {
                ((Attachable)element).attach(this.owner);
            }
            catch (Throwable ex) {
                Thread currentThread = Thread.currentThread();
                currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, ex);
            }
        }

        protected U doSet(int index, U element) {
            this.checkPreconditions(element);
            Attachable oldElement = (Attachable)this.backingList.set(index, element);
            Throwable exception = null;
            try {
                oldElement.detach(this.owner);
            }
            catch (Throwable ex) {
                exception = ex;
            }
            oldElement.associatedObject = null;
            ((Attachable)element).associatedObject = this.owner;
            try {
                ((Attachable)element).attach(this.owner);
            }
            catch (Throwable ex) {
                if (exception != null) {
                    ex.addSuppressed(exception);
                }
                exception = ex;
            }
            if (exception != null) {
                Thread currentThread = Thread.currentThread();
                currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, exception);
            }
            return (U)oldElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected U doRemove(int index) {
            Attachable oldElement = (Attachable)this.backingList.remove(index);
            try {
                oldElement.detach(this.owner);
            }
            catch (Throwable ex) {
                Thread currentThread = Thread.currentThread();
                currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, ex);
            }
            finally {
                oldElement.associatedObject = null;
            }
            return (U)oldElement;
        }

        abstract String elementName();

        private void checkPreconditions(U element) {
            if (element == null) {
                throw new NullPointerException(this.elementName() + " cannot be null.");
            }
            if (((Attachable)element).associatedObject == this.owner) {
                throw new IllegalStateException(this.elementName() + " cannot be attached to the same object more than once.");
            }
            if (((Attachable)element).associatedObject != null) {
                throw new IllegalStateException(this.elementName() + " cannot be attached to multiple objects.");
            }
        }
    }
}

