/*
 * Decompiled with CFR 0.152.
 */
package org.jfxcore.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.scene.Node;
import org.jfxcore.command.Command;
import org.jfxcore.command.CommandHandlerBehavior;
import org.jfxcore.command.InvokeCommandAction;
import org.jfxcore.command.InvokeCommandActionList;

final class CommandHandlerBehaviorList
extends ArrayList<CommandHandlerBehavior<?>> {
    private static final Map<Object, CommandHandlerBehaviorList> lists = new WeakHashMap<Object, CommandHandlerBehaviorList>();
    private final Object owner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandHandlerBehaviorList tryGet(Object owner) {
        Node node;
        if (owner instanceof Node && (node = (Node)owner).hasProperties()) {
            return (CommandHandlerBehaviorList)node.getProperties().get(CommandHandlerBehaviorList.class);
        }
        Map<Object, CommandHandlerBehaviorList> map = lists;
        synchronized (map) {
            return lists.get(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandHandlerBehaviorList get(Object owner) {
        if (owner instanceof Node) {
            Node node = (Node)owner;
            return (CommandHandlerBehaviorList)node.getProperties().computeIfAbsent(CommandHandlerBehaviorList.class, key -> new CommandHandlerBehaviorList(node));
        }
        Map<Object, CommandHandlerBehaviorList> map = lists;
        synchronized (map) {
            return lists.computeIfAbsent(owner, key -> new CommandHandlerBehaviorList(owner));
        }
    }

    private CommandHandlerBehaviorList(Object owner) {
        super(2);
        this.owner = owner;
    }

    @Override
    public boolean add(CommandHandlerBehavior handler) {
        if (handler == null) {
            throw new NullPointerException(CommandHandlerBehavior.class.getSimpleName() + " cannot be null");
        }
        if (this.contains(handler)) {
            throw new IllegalStateException(CommandHandlerBehavior.class.getSimpleName() + " is already set on " + String.valueOf(this.owner));
        }
        super.add(handler);
        this.invokeHandler(handler, true);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.invokeHandler((CommandHandlerBehavior)o, false);
            return true;
        }
        return false;
    }

    private void invokeHandler(CommandHandlerBehavior<?> handler, boolean attach) {
        Iterator iterator = InvokeCommandActionList.get(this.owner).iterator();
        while (iterator.hasNext()) {
            InvokeCommandAction action = (InvokeCommandAction)iterator.next();
            Command command = action.getCommand();
            if (command == null) continue;
            try {
                if (attach) {
                    handler.onAttached(command);
                    continue;
                }
                handler.onDetached(command);
            }
            catch (Throwable ex) {
                Thread thread = Thread.currentThread();
                thread.getUncaughtExceptionHandler().uncaughtException(thread, ex);
            }
        }
    }
}

