/*
 * Decompiled with CFR 0.152.
 */
package org.jfxcore.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.collections.ModifiableObservableListBase;
import javafx.scene.Node;
import org.jfxcore.command.Command;
import org.jfxcore.command.CommandHandlerBehavior;
import org.jfxcore.command.CommandHandlerBehaviorList;
import org.jfxcore.command.InvokeCommandAction;

final class InvokeCommandActionList
extends ModifiableObservableListBase<InvokeCommandAction> {
    private static final Map<Object, InvokeCommandActionList> lists = new WeakHashMap<Object, InvokeCommandActionList>();
    private final Object owner;
    private final List<InvokeCommandAction> list = new ArrayList<InvokeCommandAction>(1);
    private final ChangeListener<Command> commandChanged = (observable, oldValue, newValue) -> {
        Command removedCommand = this.contains((Command)oldValue, 0) ? oldValue : null;
        Command addedCommand = this.contains((Command)newValue, 1) ? newValue : null;
        this.updateCommand(removedCommand, addedCommand);
    };
    private final InvalidationListener disabledInvalidated = observable -> this.updateDisabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InvokeCommandActionList get(Object owner) {
        if (owner instanceof Node) {
            Node node = (Node)owner;
            return (InvokeCommandActionList)((Object)node.getProperties().computeIfAbsent(InvokeCommandActionList.class, key -> new InvokeCommandActionList(node)));
        }
        Map<Object, InvokeCommandActionList> map = lists;
        synchronized (map) {
            return lists.computeIfAbsent(owner, key -> new InvokeCommandActionList(owner));
        }
    }

    private InvokeCommandActionList(Object owner) {
        this.owner = owner;
    }

    public InvokeCommandAction get(int index) {
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    protected InvokeCommandAction doSet(int index, InvokeCommandAction action) {
        return this.doAddOrSet(index, action, false);
    }

    protected void doAdd(int index, InvokeCommandAction action) {
        this.doAddOrSet(index, action, true);
    }

    private InvokeCommandAction doAddOrSet(int index, InvokeCommandAction action, boolean add) {
        action.disabledProperty().addListener(this.disabledInvalidated);
        action.commandProperty().addListener(this.commandChanged);
        InvokeCommandAction oldValue = null;
        if (add) {
            this.list.add(action);
        } else {
            oldValue = this.list.set(index, action);
        }
        this.updateDisabled();
        Command addedCommand = action.getCommand();
        if (addedCommand != null && this.contains(addedCommand, 1)) {
            this.updateCommand(null, addedCommand);
        }
        return oldValue;
    }

    protected InvokeCommandAction doRemove(int index) {
        InvokeCommandAction action = this.get(index);
        action.disabledProperty().removeListener(this.disabledInvalidated);
        action.commandProperty().removeListener(this.commandChanged);
        this.list.remove(index);
        Command removedCommand = action.getCommand();
        if (removedCommand != null && this.contains(removedCommand, 0)) {
            this.updateCommand(removedCommand, null);
        }
        this.updateDisabled();
        return action;
    }

    private void updateCommand(Command removedCommand, Command addedCommand) {
        if (removedCommand != null) {
            this.invokeCommand(removedCommand, false);
            this.invokeHandler(removedCommand, false);
        }
        if (addedCommand != null) {
            this.invokeCommand(addedCommand, true);
            this.invokeHandler(addedCommand, true);
        }
    }

    private void invokeCommand(Command command, boolean attach) {
        try {
            if (attach) {
                command.onAttached(this.owner);
            } else {
                command.onDetached(this.owner);
            }
        }
        catch (Throwable ex) {
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException(thread, ex);
        }
    }

    private void invokeHandler(Command command, boolean attach) {
        CommandHandlerBehaviorList commandHandlerBehaviors = CommandHandlerBehaviorList.tryGet(this.owner);
        if (commandHandlerBehaviors == null || commandHandlerBehaviors.isEmpty()) {
            return;
        }
        for (CommandHandlerBehavior commandHandlerBehavior : commandHandlerBehaviors) {
            try {
                if (attach) {
                    commandHandlerBehavior.onAttached(command);
                    continue;
                }
                commandHandlerBehavior.onDetached(command);
            }
            catch (Throwable ex) {
                Thread thread = Thread.currentThread();
                thread.getUncaughtExceptionHandler().uncaughtException(thread, ex);
            }
        }
    }

    private void updateDisabled() {
        Node node;
        Object object = this.owner;
        if (object instanceof Node && !(node = (Node)object).disableProperty().isBound()) {
            node.setDisable(this.isDisabled());
        }
    }

    private boolean isDisabled() {
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            if (!this.get(i).disabledProperty().get()) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Command command, int n) {
        int c = 0;
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            if (this.get(i).getCommand() != command || ++c <= n) continue;
            return false;
        }
        return c == n;
    }
}

