/*
 * Decompiled with CFR 0.152.
 */
package org.jfxcore.interaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import javafx.application.Platform;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.util.Subscription;
import org.jfxcore.interaction.Attachable;
import org.jfxcore.interaction.Behavior;
import org.jfxcore.interaction.InteractionException;
import org.jfxcore.interaction.InteractionListener;
import org.jfxcore.interaction.InteractionRequest;
import org.jfxcore.interaction.InteractionRequestBase;
import org.jfxcore.interaction.Trigger;
import org.jfxcore.interaction.UnhandledInteractionException;

public final class Interaction<P, R> {
    private final List<InteractionListener<P, R>> listeners = new ArrayList<InteractionListener<P, R>>(2);
    private List<InteractionListener<P, R>> toBeAdded;
    private List<InteractionListener<P, R>> toBeRemoved;
    private int lockCount;
    private static final Map<Object, ObservableList<?>> behaviorLists = new WeakHashMap();
    private static final Map<Object, ObservableList<?>> triggerLists = new WeakHashMap();

    public InteractionRequest<P, R> request(P payload) {
        InteractionRequestBase.Default request = new InteractionRequestBase.Default(this, payload);
        this.handleRequest(request);
        return request;
    }

    public R requestAndWait(P payload) {
        InteractionRequestBase request = Platform.isFxApplicationThread() ? new InteractionRequestBase.AwaitableEventLoop(this, payload) : new InteractionRequestBase.AwaitableMonitor(this, payload);
        this.handleRequest(request);
        request.await();
        if (request.isCancelled()) {
            throw new CancellationException();
        }
        if (request.getException() != null) {
            throw new InteractionException("The interaction request was completed with an exception.", request.getException(), request);
        }
        return request.getResponse();
    }

    private void handleRequest(InteractionRequestBase<P, R> request) {
        List<InteractionListener<P, R>> list = this.listeners;
        synchronized (list) {
            try {
                ++this.lockCount;
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    if (!this.listeners.get(i).accept(request) && !request.isDone()) continue;
                    return;
                }
                throw new UnhandledInteractionException("No listener accepted the interaction request.", request);
            }
            finally {
                --this.lockCount;
                if (this.toBeRemoved != null) {
                    for (InteractionListener<P, R> listener : this.toBeRemoved) {
                        this.removeListenerFromList(this.listeners, listener);
                    }
                    this.toBeRemoved = null;
                }
                if (this.toBeAdded != null) {
                    for (InteractionListener<P, R> listener : this.toBeAdded) {
                        this.removeListenerFromList(this.listeners, listener);
                    }
                    this.toBeAdded = null;
                }
            }
        }
    }

    public Subscription subscribe(InteractionListener<P, R> listener) {
        this.addListener(listener);
        return () -> this.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InteractionListener<P, R> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        List<InteractionListener<P, R>> list = this.listeners;
        synchronized (list) {
            if (this.lockCount > 0) {
                if (this.toBeRemoved == null || !this.removeListenerFromList(this.toBeRemoved, listener)) {
                    if (this.toBeAdded == null) {
                        this.toBeAdded = new ArrayList<InteractionListener<P, R>>(2);
                    }
                    this.toBeAdded.add(listener);
                }
            } else {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InteractionListener<P, R> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        List<InteractionListener<P, R>> list = this.listeners;
        synchronized (list) {
            if (this.lockCount > 0) {
                if (this.toBeAdded == null || !this.removeListenerFromList(this.toBeAdded, listener)) {
                    if (this.toBeRemoved == null) {
                        this.toBeRemoved = new ArrayList<InteractionListener<P, R>>(2);
                    }
                    this.toBeRemoved.add(listener);
                }
            } else {
                this.removeListenerFromList(this.listeners, listener);
            }
        }
    }

    private boolean removeListenerFromList(List<InteractionListener<P, R>> list, InteractionListener<P, R> listener) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!listener.equals(list.get(i))) continue;
            list.remove(i);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ObservableList<Behavior<? super T>> getBehaviors(T owner) {
        Objects.requireNonNull(owner, "owner cannot be null");
        if (owner instanceof Node) {
            Node node = (Node)owner;
            BehaviorList list = (BehaviorList)((Object)node.getProperties().get(BehaviorList.class));
            if (list == null) {
                list = new BehaviorList(node);
                node.getProperties().put(BehaviorList.class, list);
            }
            return list;
        }
        Map<Object, ObservableList<?>> map = behaviorLists;
        synchronized (map) {
            return behaviorLists.computeIfAbsent(owner, key -> new BehaviorList(owner));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ObservableList<Trigger<? super T, ?>> getTriggers(T owner) {
        Objects.requireNonNull(owner, "owner cannot be null");
        if (owner instanceof Node) {
            Node node = (Node)owner;
            TriggerList list = (TriggerList)((Object)node.getProperties().get(TriggerList.class));
            if (list == null) {
                list = new TriggerList(node);
                node.getProperties().put(TriggerList.class, list);
            }
            return list;
        }
        Map<Object, ObservableList<?>> map = triggerLists;
        synchronized (map) {
            return triggerLists.computeIfAbsent(owner, key -> new TriggerList(owner));
        }
    }

    private static class BehaviorList<T, U extends Behavior<? super T>>
    extends AttachableList<T, U> {
        BehaviorList(T owner) {
            super(owner);
        }

        @Override
        String elementName() {
            return Behavior.class.getSimpleName();
        }

        public String toString() {
            return BehaviorList.class.getName();
        }
    }

    private static class TriggerList<T, U extends Trigger<? super T, ?>>
    extends AttachableList<T, U> {
        TriggerList(T owner) {
            super(owner);
        }

        @Override
        String elementName() {
            return Trigger.class.getSimpleName();
        }

        public String toString() {
            return TriggerList.class.getName();
        }
    }

    private static abstract class AttachableList<T, U extends Attachable<? super T>>
    extends ModifiableObservableListBase<U> {
        final List<U> backingList = new ArrayList<U>(2);
        final T owner;

        AttachableList(T owner) {
            this.owner = owner;
        }

        public U get(int index) {
            return (U)((Attachable)this.backingList.get(index));
        }

        public int size() {
            return this.backingList.size();
        }

        protected void doAdd(int index, U element) {
            this.checkPreconditions(element);
            this.backingList.add(index, element);
            ((Attachable)element).associatedObject = this.owner;
            try {
                ((Attachable)element).attach(this.owner);
            }
            catch (Throwable ex) {
                Thread currentThread = Thread.currentThread();
                currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, ex);
            }
        }

        protected U doSet(int index, U element) {
            this.checkPreconditions(element);
            Attachable oldElement = (Attachable)this.backingList.set(index, element);
            Throwable exception = null;
            try {
                oldElement.detach(this.owner);
            }
            catch (Throwable ex) {
                exception = ex;
            }
            oldElement.associatedObject = null;
            ((Attachable)element).associatedObject = this.owner;
            try {
                ((Attachable)element).attach(this.owner);
            }
            catch (Throwable ex) {
                if (exception != null) {
                    ex.addSuppressed(exception);
                }
                exception = ex;
            }
            if (exception != null) {
                Thread currentThread = Thread.currentThread();
                currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, exception);
            }
            return (U)oldElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected U doRemove(int index) {
            Attachable oldElement = (Attachable)this.backingList.remove(index);
            try {
                oldElement.detach(this.owner);
            }
            catch (Throwable ex) {
                Thread currentThread = Thread.currentThread();
                currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, ex);
            }
            finally {
                oldElement.associatedObject = null;
            }
            return (U)oldElement;
        }

        abstract String elementName();

        private void checkPreconditions(U element) {
            if (element == null) {
                throw new NullPointerException(this.elementName() + " cannot be null.");
            }
            if (((Attachable)element).associatedObject == this.owner) {
                throw new IllegalStateException(this.elementName() + " cannot be attached to the same object more than once.");
            }
            if (((Attachable)element).associatedObject != null) {
                throw new IllegalStateException(this.elementName() + " cannot be attached to multiple objects.");
            }
        }
    }
}

