/*
 * Decompiled with CFR 0.152.
 */
package org.jfxcore.interaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.application.Platform;
import org.jfxcore.interaction.Interaction;
import org.jfxcore.interaction.InteractionException;
import org.jfxcore.interaction.InteractionRequest;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class InteractionRequestBase<P, R>
implements InteractionRequest<P, R> {
    private final P payload;
    private final Interaction<P, R> interaction;
    private List<CompletionAction<R>> completionActions;
    private State state = State.RUNNING;
    private R response;
    private Throwable exception;

    InteractionRequestBase(Interaction<P, R> interaction, P payload) {
        this.interaction = interaction;
        this.payload = payload;
    }

    Executor defaultExecutor() {
        return ForkJoinPool.commonPool();
    }

    @Override
    public final Interaction<P, R> getInteraction() {
        return this.interaction;
    }

    @Override
    public final P getPayload() {
        return this.payload;
    }

    final R getResponse() {
        return this.response;
    }

    final Throwable getException() {
        return this.exception;
    }

    @Override
    public final synchronized boolean isDone() {
        return this.state != State.RUNNING;
    }

    @Override
    public final synchronized boolean isCompleted() {
        return this.state == State.COMPLETED;
    }

    final synchronized boolean setCompleted(R value) {
        if (this.state != State.RUNNING) {
            return false;
        }
        this.state = State.COMPLETED;
        this.response = value;
        this.runCompletionActions();
        return true;
    }

    @Override
    public final synchronized boolean isCompletedExceptionally() {
        return this.state == State.COMPLETED_EXCEPTIONALLY;
    }

    final synchronized boolean setCompletedExceptionally(Throwable ex) {
        if (this.state != State.RUNNING) {
            return false;
        }
        this.state = State.COMPLETED_EXCEPTIONALLY;
        this.exception = ex;
        this.runCompletionActions();
        return true;
    }

    @Override
    public void cancel() {
        this.setCancelled();
    }

    @Override
    public final synchronized boolean isCancelled() {
        return this.state == State.CANCELLED;
    }

    final synchronized boolean setCancelled() {
        if (this.state != State.RUNNING) {
            return false;
        }
        this.state = State.CANCELLED;
        this.runCompletionActions();
        return true;
    }

    @Override
    public <U> CompletionStage<U> thenApply(Function<? super R, ? extends U> fn) {
        return this.thenApplyImpl(fn, null);
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super R, ? extends U> fn) {
        return this.thenApplyImpl(fn, this.defaultExecutor());
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super R, ? extends U> fn, Executor executor) {
        return this.thenApplyImpl(fn, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private <U> CompletionStage<U> thenApplyImpl(final Function<? super R, ? extends U> fn, Executor executor) {
        final CompletableFuture newStage = new CompletableFuture();
        this.addCompletionAction(new CompletionAction<R>(executor){

            @Override
            void complete(R value, Throwable exception) {
                if (exception != null) {
                    newStage.completeExceptionally(exception);
                } else {
                    try {
                        newStage.complete(fn.apply(value));
                    }
                    catch (Throwable ex) {
                        newStage.completeExceptionally(ex);
                    }
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    @Override
    public CompletionStage<Void> thenAccept(Consumer<? super R> action) {
        return this.thenAcceptImpl(action, null);
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super R> action) {
        return this.thenAcceptImpl(action, this.defaultExecutor());
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super R> action, Executor executor) {
        return this.thenAcceptImpl(action, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private synchronized CompletionStage<Void> thenAcceptImpl(final Consumer<? super R> action, Executor executor) {
        final CompletableFuture<Void> newStage = new CompletableFuture<Void>();
        this.addCompletionAction(new CompletionAction<R>(executor){

            @Override
            void complete(R value, Throwable exception) {
                if (exception != null) {
                    newStage.completeExceptionally(exception);
                } else {
                    try {
                        action.accept(value);
                        newStage.complete(null);
                    }
                    catch (Throwable ex) {
                        newStage.completeExceptionally(ex);
                    }
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    @Override
    public CompletionStage<Void> thenRun(Runnable action) {
        return this.thenRunImpl(action, null);
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action) {
        return this.thenRunImpl(action, this.defaultExecutor());
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.thenRunImpl(action, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private synchronized CompletionStage<Void> thenRunImpl(final Runnable action, Executor executor) {
        final CompletableFuture<Void> newStage = new CompletableFuture<Void>();
        this.addCompletionAction(new CompletionAction<R>(executor){

            @Override
            void complete(R value, Throwable exception) {
                if (exception != null) {
                    newStage.completeExceptionally(exception);
                } else {
                    try {
                        action.run();
                        newStage.complete(null);
                    }
                    catch (Throwable ex) {
                        newStage.completeExceptionally(ex);
                    }
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    @Override
    public <U, V> CompletionStage<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super R, ? super U, ? extends V> fn) {
        return this.thenCombineImpl(other, fn, null);
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super R, ? super U, ? extends V> fn) {
        return this.thenCombineImpl(other, fn, this.defaultExecutor());
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super R, ? super U, ? extends V> fn, Executor executor) {
        return this.thenCombineImpl(other, fn, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private synchronized <U, V> CompletionStage<V> thenCombineImpl(CompletionStage<? extends U> other, final BiFunction<? super R, ? super U, ? extends V> fn, Executor executor) {
        final CompletableFuture newStage = new CompletableFuture();
        final BiResult result = new BiResult();
        final MutableInt count = new MutableInt();
        other.whenCompleteAsync((? super T value, ? super Throwable ex) -> {
            BiResult biResult = result;
            synchronized (biResult) {
                result.value2 = value;
                result.exception2 = ex;
                if (++count.value == 2) {
                    this.thenCombineImplResult(newStage, fn, result);
                }
            }
        }, Objects.requireNonNullElse(executor, Runnable::run));
        this.addCompletionAction(new CompletionAction<R>(executor){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void complete(R value, Throwable exception) {
                BiResult biResult = result;
                synchronized (biResult) {
                    result.value1 = value;
                    result.exception1 = exception;
                    if (++count.value == 2) {
                        InteractionRequestBase.this.thenCombineImplResult(newStage, fn, result);
                    }
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    private <V, R1, R2> void thenCombineImplResult(CompletableFuture<V> newStage, BiFunction<? super R1, ? super R2, ? extends V> fn, BiResult<R1, R2> result) {
        if (result.exception1 != null) {
            newStage.completeExceptionally(result.exception1);
        } else if (result.exception2 != null) {
            newStage.completeExceptionally(result.exception2);
        } else {
            try {
                newStage.complete(fn.apply(result.value1, result.value2));
            }
            catch (Throwable ex) {
                newStage.completeExceptionally(ex);
            }
        }
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super R, ? super U> action) {
        return this.thenAcceptBothImpl(other, action, null);
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super R, ? super U> action) {
        return this.thenAcceptBothImpl(other, action, this.defaultExecutor());
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super R, ? super U> action, Executor executor) {
        return this.thenAcceptBothImpl(other, action, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private synchronized <U> CompletionStage<Void> thenAcceptBothImpl(CompletionStage<? extends U> other, final BiConsumer<? super R, ? super U> action, Executor executor) {
        final CompletableFuture<Void> newStage = new CompletableFuture<Void>();
        final BiResult result = new BiResult();
        final MutableInt count = new MutableInt();
        other.whenCompleteAsync((? super T value, ? super Throwable ex) -> {
            BiResult biResult = result;
            synchronized (biResult) {
                result.value2 = value;
                result.exception2 = ex;
                if (++count.value == 2) {
                    this.thenAcceptBothImplResult(newStage, action, result);
                }
            }
        }, Objects.requireNonNullElse(executor, Runnable::run));
        this.addCompletionAction(new CompletionAction<R>(executor){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void complete(R value, Throwable exception) {
                BiResult biResult = result;
                synchronized (biResult) {
                    result.value1 = value;
                    result.exception1 = exception;
                    if (++count.value == 2) {
                        InteractionRequestBase.this.thenAcceptBothImplResult(newStage, action, result);
                    }
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    private <U> void thenAcceptBothImplResult(CompletableFuture<Void> newStage, BiConsumer<? super R, ? super U> action, BiResult<R, U> result) {
        if (result.exception1 != null) {
            newStage.completeExceptionally(result.exception1);
        } else if (result.exception2 != null) {
            newStage.completeExceptionally(result.exception2);
        } else {
            try {
                action.accept(result.value1, result.value2);
                newStage.complete(null);
            }
            catch (Throwable ex) {
                newStage.completeExceptionally(ex);
            }
        }
    }

    @Override
    public CompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.runAfterBothImpl(other, action, null);
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterBothImpl(other, action, this.defaultExecutor());
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.runAfterBothImpl(other, action, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private synchronized CompletionStage<Void> runAfterBothImpl(CompletionStage<?> other, final Runnable action, Executor executor) {
        final CompletableFuture<Void> newStage = new CompletableFuture<Void>();
        final BiResult result = new BiResult();
        final MutableInt count = new MutableInt();
        other.whenCompleteAsync((? super T value, ? super Throwable ex) -> {
            BiResult biResult = result;
            synchronized (biResult) {
                result.exception2 = ex;
                if (++count.value == 2) {
                    this.runAfterBothImplResult(newStage, action, result);
                }
            }
        }, Objects.requireNonNullElse(executor, Runnable::run));
        this.addCompletionAction(new CompletionAction<R>(executor){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void complete(R value, Throwable exception) {
                BiResult biResult = result;
                synchronized (biResult) {
                    result.exception1 = exception;
                    if (++count.value == 2) {
                        InteractionRequestBase.this.runAfterBothImplResult(newStage, action, result);
                    }
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    private void runAfterBothImplResult(CompletableFuture<Void> newStage, Runnable action, BiResult<Object, Object> result) {
        if (result.exception1 != null) {
            newStage.completeExceptionally(result.exception1);
        } else if (result.exception2 != null) {
            newStage.completeExceptionally(result.exception2);
        } else {
            try {
                action.run();
                newStage.complete(null);
            }
            catch (Throwable ex) {
                newStage.completeExceptionally(ex);
            }
        }
    }

    @Override
    public <U> CompletionStage<U> applyToEither(CompletionStage<? extends R> other, Function<? super R, U> fn) {
        return this.applyToEitherImpl(other, fn, null);
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends R> other, Function<? super R, U> fn) {
        return this.applyToEitherImpl(other, fn, this.defaultExecutor());
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends R> other, Function<? super R, U> fn, Executor executor) {
        return this.applyToEitherImpl(other, fn, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private synchronized <U> CompletionStage<U> applyToEitherImpl(CompletionStage<? extends R> other, final Function<? super R, U> fn, Executor executor) {
        final CompletableFuture newStage = new CompletableFuture();
        final BiResult result = new BiResult();
        final MutableInt count = new MutableInt();
        other.whenCompleteAsync((? super T value, ? super Throwable ex) -> {
            BiResult biResult = result;
            synchronized (biResult) {
                result.value2 = value;
                result.exception2 = ex;
                if (result.exception1 != null || ++count.value == 2) {
                    this.applyToEitherImplResult(newStage, fn, result);
                }
            }
        }, Objects.requireNonNullElse(executor, Runnable::run));
        this.addCompletionAction(new CompletionAction<R>(executor){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void complete(R value, Throwable exception) {
                BiResult biResult = result;
                synchronized (biResult) {
                    result.value1 = value;
                    result.exception1 = exception;
                    if (result.exception2 != null || ++count.value == 2) {
                        InteractionRequestBase.this.applyToEitherImplResult(newStage, fn, result);
                    }
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    private <U> void applyToEitherImplResult(CompletableFuture<U> newStage, Function<? super R, U> fn, BiResult<R, R> result) {
        if (result.exception1 != null && result.exception2 != null) {
            newStage.completeExceptionally(result.exception1);
        } else {
            try {
                newStage.complete(fn.apply(result.exception1 != null ? result.value2 : result.value1));
            }
            catch (Throwable ex) {
                newStage.completeExceptionally(ex);
            }
        }
    }

    @Override
    public CompletionStage<Void> acceptEither(CompletionStage<? extends R> other, Consumer<? super R> action) {
        return this.acceptEitherImpl(other, action, null);
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends R> other, Consumer<? super R> action) {
        return this.acceptEitherImpl(other, action, this.defaultExecutor());
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends R> other, Consumer<? super R> action, Executor executor) {
        return this.acceptEitherImpl(other, action, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private synchronized CompletionStage<Void> acceptEitherImpl(CompletionStage<? extends R> other, final Consumer<? super R> action, Executor executor) {
        final CompletableFuture<Void> newStage = new CompletableFuture<Void>();
        final BiResult result = new BiResult();
        final MutableInt count = new MutableInt();
        other.whenCompleteAsync((? super T value, ? super Throwable ex) -> {
            BiResult biResult = result;
            synchronized (biResult) {
                result.value2 = value;
                result.exception2 = ex;
                if (result.exception1 != null || ++count.value == 2) {
                    this.acceptEitherImplResult(newStage, action, result);
                }
            }
        }, Objects.requireNonNullElse(executor, Runnable::run));
        this.addCompletionAction(new CompletionAction<R>(executor){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void complete(R value, Throwable exception) {
                BiResult biResult = result;
                synchronized (biResult) {
                    result.value1 = value;
                    result.exception1 = exception;
                    if (result.exception2 != null || ++count.value == 2) {
                        InteractionRequestBase.this.acceptEitherImplResult(newStage, action, result);
                    }
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    private void acceptEitherImplResult(CompletableFuture<Void> newStage, Consumer<? super R> action, BiResult<R, R> result) {
        if (result.exception1 != null && result.exception2 != null) {
            newStage.completeExceptionally(result.exception1);
        } else {
            try {
                action.accept(result.exception1 != null ? result.value2 : result.value1);
                newStage.complete(null);
            }
            catch (Throwable ex) {
                newStage.completeExceptionally(ex);
            }
        }
    }

    @Override
    public CompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherImpl(other, action, null);
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherImpl(other, action, this.defaultExecutor());
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.runAfterEitherImpl(other, action, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private synchronized CompletionStage<Void> runAfterEitherImpl(CompletionStage<?> other, final Runnable action, Executor executor) {
        final CompletableFuture<Void> newStage = new CompletableFuture<Void>();
        final BiResult result = new BiResult();
        final MutableInt count = new MutableInt();
        other.whenCompleteAsync((? super T value, ? super Throwable ex) -> {
            BiResult biResult = result;
            synchronized (biResult) {
                result.exception2 = ex;
                if (result.exception1 != null || ++count.value == 2) {
                    this.runAfterEitherImplResult(newStage, action, result);
                }
            }
        }, Objects.requireNonNullElse(executor, Runnable::run));
        this.addCompletionAction(new CompletionAction<R>(executor){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void complete(R value, Throwable exception) {
                BiResult biResult = result;
                synchronized (biResult) {
                    result.exception1 = exception;
                    if (result.exception2 != null || ++count.value == 2) {
                        InteractionRequestBase.this.runAfterEitherImplResult(newStage, action, result);
                    }
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    private void runAfterEitherImplResult(CompletableFuture<Void> newStage, Runnable action, BiResult<Object, Object> result) {
        if (result.exception1 != null && result.exception2 != null) {
            newStage.completeExceptionally(result.exception1);
        } else {
            try {
                action.run();
                newStage.complete(null);
            }
            catch (Throwable ex) {
                newStage.completeExceptionally(ex);
            }
        }
    }

    @Override
    public <U> CompletionStage<U> thenCompose(Function<? super R, ? extends CompletionStage<U>> fn) {
        return this.thenComposeImpl(fn, null);
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super R, ? extends CompletionStage<U>> fn) {
        return this.thenComposeImpl(fn, this.defaultExecutor());
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super R, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.thenComposeImpl(fn, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private synchronized <U> CompletionStage<U> thenComposeImpl(final Function<? super R, ? extends CompletionStage<U>> fn, Executor executor) {
        final CompletableFuture newStage = new CompletableFuture();
        final Executor composeExecutor = executor;
        this.addCompletionAction(new CompletionAction<R>(null){

            @Override
            void complete(R value, Throwable exception) {
                if (exception != null) {
                    newStage.completeExceptionally(exception);
                } else {
                    try {
                        ((CompletionStage)fn.apply(value)).whenCompleteAsync((composeValue, composeException) -> {
                            if (composeException != null) {
                                newStage.completeExceptionally((Throwable)composeException);
                            } else {
                                newStage.complete(composeValue);
                            }
                        }, Objects.requireNonNullElse(composeExecutor, Runnable::run));
                    }
                    catch (Throwable ex) {
                        newStage.completeExceptionally(ex);
                    }
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    @Override
    public synchronized <U> CompletionStage<U> handle(BiFunction<? super R, Throwable, ? extends U> fn) {
        return this.handleImpl(fn, null);
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super R, Throwable, ? extends U> fn) {
        return this.handleImpl(fn, this.defaultExecutor());
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super R, Throwable, ? extends U> fn, Executor executor) {
        return this.handleImpl(fn, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private synchronized <U> CompletionStage<U> handleImpl(final BiFunction<? super R, Throwable, ? extends U> fn, Executor executor) {
        final CompletableFuture newStage = new CompletableFuture();
        this.addCompletionAction(new CompletionAction<R>(executor){

            @Override
            void complete(R value, Throwable exception) {
                if (InteractionRequestBase.this.isCompleted() || InteractionRequestBase.this.isCompletedExceptionally()) {
                    try {
                        newStage.complete(fn.apply(value, exception));
                    }
                    catch (Throwable ex) {
                        newStage.completeExceptionally(ex);
                    }
                } else {
                    newStage.cancel(false);
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    @Override
    public CompletionStage<R> whenComplete(BiConsumer<? super R, ? super Throwable> action) {
        return this.whenCompleteImpl(action, null);
    }

    @Override
    public CompletionStage<R> whenCompleteAsync(BiConsumer<? super R, ? super Throwable> action) {
        return this.whenCompleteImpl(action, this.defaultExecutor());
    }

    @Override
    public CompletionStage<R> whenCompleteAsync(BiConsumer<? super R, ? super Throwable> action, Executor executor) {
        return this.whenCompleteImpl(action, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    private synchronized CompletionStage<R> whenCompleteImpl(final BiConsumer<? super R, ? super Throwable> action, Executor executor) {
        final CompletableFuture newStage = new CompletableFuture();
        this.addCompletionAction(new CompletionAction<R>(executor){

            @Override
            void complete(R value, Throwable exception) {
                if (InteractionRequestBase.this.isCompleted()) {
                    try {
                        action.accept(value, exception);
                        newStage.complete(value);
                    }
                    catch (Throwable ex) {
                        newStage.completeExceptionally(ex);
                    }
                } else if (InteractionRequestBase.this.isCompletedExceptionally()) {
                    try {
                        action.accept(value, exception);
                        newStage.completeExceptionally(exception);
                    }
                    catch (Throwable ex) {
                        newStage.completeExceptionally(exception);
                    }
                } else {
                    newStage.cancel(false);
                }
            }

            @Override
            void cancel() {
                newStage.cancel(false);
            }
        });
        return newStage;
    }

    @Override
    public synchronized CompletionStage<R> exceptionally(final Function<Throwable, ? extends R> fn) {
        final CompletableFuture newStage = new CompletableFuture();
        this.addCompletionAction(new CompletionAction<R>(null){

            @Override
            void cancel() {
                newStage.cancel(false);
            }

            @Override
            void complete(R value, Throwable exception) {
                if (exception != null) {
                    try {
                        newStage.complete(fn.apply(exception));
                    }
                    catch (Throwable ex) {
                        newStage.completeExceptionally(exception);
                    }
                } else {
                    newStage.complete(value);
                }
            }
        });
        return newStage;
    }

    @Override
    public CompletableFuture<R> toCompletableFuture() {
        return (CompletableFuture)this.thenApply((Function)x -> x);
    }

    void await() {
    }

    private void addCompletionAction(CompletionAction<R> action) {
        if (this.state == State.RUNNING) {
            if (this.completionActions == null) {
                this.completionActions = new ArrayList<CompletionAction<R>>(2);
            }
            this.completionActions.add(action);
        } else if (this.state == State.CANCELLED) {
            action.cancel();
        } else if (action.executor != null) {
            action.executor.execute(() -> action.complete(this.response, this.exception));
        } else {
            action.complete(this.response, this.exception);
        }
    }

    private void runCompletionActions() {
        if (this.completionActions == null) {
            return;
        }
        if (this.state == State.CANCELLED) {
            for (CompletionAction<R> action : this.completionActions) {
                action.cancel();
            }
        } else {
            for (CompletionAction<R> action : this.completionActions) {
                if (action.executor != null) {
                    action.executor.execute(() -> action.complete(this.response, this.exception));
                    continue;
                }
                action.complete(this.response, this.exception);
            }
        }
    }

    static enum State {
        RUNNING,
        COMPLETED,
        COMPLETED_EXCEPTIONALLY,
        CANCELLED;

    }

    private static abstract class CompletionAction<R> {
        final Executor executor;

        private CompletionAction(Executor executor) {
            this.executor = executor;
        }

        abstract void complete(R var1, Throwable var2);

        abstract void cancel();
    }

    private static class BiResult<R1, R2> {
        R1 value1;
        R2 value2;
        Throwable exception1;
        Throwable exception2;

        private BiResult() {
        }
    }

    private static class MutableInt {
        int value;

        private MutableInt() {
        }
    }

    static final class AwaitableMonitor<P, R>
    extends InteractionRequestBase<P, R> {
        AwaitableMonitor(Interaction<P, R> interaction, P payload) {
            super(interaction, payload);
        }

        @Override
        synchronized void await() {
            if (this.isDone()) {
                return;
            }
            while (!this.isDone()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    throw new InteractionException("Interaction was interrupted", e, this);
                }
            }
        }

        @Override
        public synchronized void cancel() {
            if (this.setCancelled()) {
                this.notifyAll();
            }
        }

        @Override
        public synchronized void complete(R response) {
            if (this.setCompleted(response)) {
                this.notifyAll();
            }
        }

        @Override
        public synchronized void completeExceptionally(Throwable cause) {
            if (this.setCompletedExceptionally(cause)) {
                this.notifyAll();
            }
        }
    }

    static final class AwaitableEventLoop<P, R>
    extends InteractionRequestBase<P, R> {
        private boolean nestedEventLoopStarted;

        AwaitableEventLoop(Interaction<P, R> interaction, P payload) {
            super(interaction, payload);
        }

        @Override
        void await() {
            if (!this.isDone()) {
                this.nestedEventLoopStarted = true;
                Platform.enterNestedEventLoop((Object)this);
            }
        }

        @Override
        public void complete(R response) {
            if (this.setCompleted(response)) {
                if (Platform.isFxApplicationThread()) {
                    this.completeImpl();
                } else {
                    Platform.runLater(this::completeImpl);
                }
            }
        }

        @Override
        public void completeExceptionally(Throwable cause) {
            if (this.setCompletedExceptionally(cause)) {
                if (Platform.isFxApplicationThread()) {
                    this.completeImpl();
                } else {
                    Platform.runLater(this::completeImpl);
                }
            }
        }

        private void completeImpl() {
            if (this.nestedEventLoopStarted) {
                Platform.exitNestedEventLoop((Object)this, null);
            }
        }
    }

    static final class Default<P, R>
    extends InteractionRequestBase<P, R> {
        Default(Interaction<P, R> interaction, P payload) {
            super(interaction, payload);
        }

        @Override
        public void complete(R response) {
            this.setCompleted(response);
        }

        @Override
        public void completeExceptionally(Throwable cause) {
            this.setCompletedExceptionally(cause);
        }
    }
}

