/*
 * Decompiled with CFR 0.152.
 */
package org.jfxcore.interaction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;
import org.jfxcore.interaction.Attachable;
import org.jfxcore.interaction.TriggerAction;

@DefaultProperty(value="actions")
public abstract class Trigger<T, P>
extends Attachable<T> {
    private final ActionList<T, P> actions;

    protected Trigger() {
        this.actions = new ActionList(this, 2);
    }

    @SafeVarargs
    protected Trigger(TriggerAction<? super T, ? super P> ... actions) {
        this.actions = new ActionList(this, actions.length);
        this.actions.addAll(actions);
    }

    @Override
    public final T getAssociatedObject() {
        return super.getAssociatedObject();
    }

    public final ObservableList<TriggerAction<? super T, ? super P>> getActions() {
        return this.actions;
    }

    protected void runActions(P parameter) {
        for (TriggerAction action : this.getActions()) {
            try {
                action.onExecute(parameter);
            }
            catch (Throwable ex) {
                Thread currentThread = Thread.currentThread();
                currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, ex);
            }
        }
    }

    protected void onAttached(T associatedObject) {
    }

    protected void onDetached(T associatedObject) {
    }

    @Override
    final void attach(T associatedObject) {
        this.onAttached(associatedObject);
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            TriggerAction action = (TriggerAction)iterator.next();
            try {
                action.onAttached(associatedObject);
            }
            catch (Throwable ex) {
                Thread currentThread = Thread.currentThread();
                currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, ex);
            }
        }
    }

    @Override
    final void detach(T associatedObject) {
        this.onDetached(associatedObject);
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            TriggerAction action = (TriggerAction)iterator.next();
            try {
                action.onDetached(associatedObject);
            }
            catch (Throwable ex) {
                Thread currentThread = Thread.currentThread();
                currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, ex);
            }
        }
    }

    private static class ActionList<T, P>
    extends ModifiableObservableListBase<TriggerAction<? super T, ? super P>> {
        final List<TriggerAction<? super T, ? super P>> backingList;
        final Trigger<T, P> trigger;

        ActionList(Trigger<T, P> trigger, int initialCapacity) {
            this.trigger = trigger;
            this.backingList = new ArrayList<TriggerAction<? super T, ? super P>>(initialCapacity);
        }

        public TriggerAction<? super T, ? super P> get(int index) {
            return this.backingList.get(index);
        }

        public int size() {
            return this.backingList.size();
        }

        protected void doAdd(int index, TriggerAction<? super T, ? super P> element) {
            this.checkPreconditions(element);
            this.backingList.add(index, element);
            element.associatedTrigger = this.trigger;
            Object associatedObject = this.trigger.associatedObject;
            if (associatedObject != null) {
                try {
                    element.onAttached(associatedObject);
                }
                catch (Throwable ex) {
                    Thread currentThread = Thread.currentThread();
                    currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, ex);
                }
            }
        }

        protected TriggerAction<? super T, ? super P> doSet(int index, TriggerAction<? super T, ? super P> element) {
            this.checkPreconditions(element);
            TriggerAction<Object, P> oldElement = this.backingList.set(index, element);
            Object associatedObject = this.trigger.associatedObject;
            if (associatedObject == null) {
                return oldElement;
            }
            Throwable exception = null;
            try {
                oldElement.onDetached(associatedObject);
            }
            catch (Throwable ex) {
                exception = ex;
            }
            oldElement.associatedTrigger = null;
            element.associatedTrigger = this.trigger;
            try {
                element.onAttached(associatedObject);
            }
            catch (Throwable ex) {
                if (exception != null) {
                    ex.addSuppressed(exception);
                }
                exception = ex;
            }
            if (exception != null) {
                Thread currentThread = Thread.currentThread();
                currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, exception);
            }
            return oldElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TriggerAction<? super T, ? super P> doRemove(int index) {
            TriggerAction<Object, P> oldAction = this.backingList.remove(index);
            Object associatedObject = this.trigger.associatedObject;
            try {
                if (associatedObject != null) {
                    oldAction.onDetached(associatedObject);
                }
            }
            catch (Throwable ex) {
                Thread currentThread = Thread.currentThread();
                currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, ex);
            }
            finally {
                oldAction.associatedTrigger = null;
            }
            return oldAction;
        }

        private void checkPreconditions(TriggerAction<?, ?> action) {
            if (action == null) {
                throw new NullPointerException(TriggerAction.class.getSimpleName() + " cannot be null.");
            }
            if (action.associatedTrigger == this.trigger) {
                throw new IllegalStateException(TriggerAction.class.getSimpleName() + " cannot be added to the same trigger more than once.");
            }
            if (action.associatedTrigger != null) {
                throw new IllegalStateException(TriggerAction.class.getSimpleName() + " cannot be added to multiple triggers.");
            }
        }
    }
}

