/*
 * Decompiled with CFR 0.152.
 */
package org.jfxcore.interaction;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javafx.beans.WeakListener;
import org.jfxcore.interaction.InteractionListener;
import org.jfxcore.interaction.InteractionRequest;

public final class WeakInteractionListener<P, R>
implements InteractionListener<P, R>,
WeakListener {
    private final WeakReference<InteractionListener<P, R>> wref;

    public WeakInteractionListener(InteractionListener<P, R> listener) {
        this.wref = new WeakReference<InteractionListener<P, R>>(Objects.requireNonNull(listener, "listener cannot be null"));
    }

    public boolean wasGarbageCollected() {
        return false;
    }

    @Override
    public boolean accept(InteractionRequest<P, R> request) {
        InteractionListener ref = (InteractionListener)this.wref.get();
        if (ref == null) {
            request.getInteraction().removeListener(this);
            return false;
        }
        return ref.accept(request);
    }
}

