/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info;

import org.jutils.jhardware.info.HardwareInfo;
import org.jutils.jhardware.info.InfoType;
import org.jutils.jhardware.info.bios.unix.UnixBiosInfo;
import org.jutils.jhardware.info.bios.windows.WindowsBiosInfo;
import org.jutils.jhardware.info.memory.unix.UnixMemoryInfo;
import org.jutils.jhardware.info.memory.windows.WindowsMemoryInfo;
import org.jutils.jhardware.info.motherboard.unix.UnixMotherboardInfo;
import org.jutils.jhardware.info.motherboard.windows.WindowsMotherboardInfo;
import org.jutils.jhardware.info.os.unix.UnixOSInfo;
import org.jutils.jhardware.info.os.windows.WindowsOSInfo;
import org.jutils.jhardware.info.processor.unix.UnixProcessorInfo;
import org.jutils.jhardware.info.processor.windows.WindowsProcessorInfo;
import org.jutils.jhardware.util.OSDetector;

public class HardwareFactory {
    public static HardwareInfo get(InfoType type) {
        switch (type) {
            case PROCESSOR: {
                if (OSDetector.isWindows()) {
                    return new WindowsProcessorInfo();
                }
                if (OSDetector.isUnix()) {
                    return new UnixProcessorInfo();
                }
            }
            case MEMORY: {
                if (OSDetector.isWindows()) {
                    return new WindowsMemoryInfo();
                }
                if (OSDetector.isUnix()) {
                    return new UnixMemoryInfo();
                }
            }
            case BIOS: {
                if (OSDetector.isWindows()) {
                    return new WindowsBiosInfo();
                }
                if (OSDetector.isUnix()) {
                    return new UnixBiosInfo();
                }
            }
            case MOTHERBOARD: {
                if (OSDetector.isWindows()) {
                    return new WindowsMotherboardInfo();
                }
                if (OSDetector.isUnix()) {
                    return new UnixMotherboardInfo();
                }
            }
            case OS: {
                if (OSDetector.isWindows()) {
                    return new WindowsOSInfo();
                }
                if (!OSDetector.isUnix()) break;
                return new UnixOSInfo();
            }
        }
        throw new IllegalArgumentException("Type of hardware not supported: " + (Object)((Object)type));
    }
}

